/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.Configuration;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;

public class EP
implements Serializable {
    public String host;
    public int port;
    public boolean alive;
    public long statusRefreshTs = 0L;
    public int serverMode = -1;
    public int serverStatus = -1;
    public boolean dscControl = false;
    public int sort = Integer.MAX_VALUE;
    public static final int STATUS_VALID_TIME = 20000;
    public static final int SORT_SERVER_MODE_INVALID = -1;
    public static final int SORT_SERVER_NOT_ALIVE = -2;
    public static final int SORT_UNKNOWN = Integer.MAX_VALUE;
    public static final int SORT_NORMAL = 30;
    public static final int SORT_PRIMARY = 20;
    public static final int SORT_STANDBY = 10;
    public static final int SORT_OPEN = 3;
    public static final int SORT_MOUNT = 2;
    public static final int SORT_SUSPEND = 1;
    public int epSeqno;
    public static final int EP_STATUS_OK = 1;
    public static final int EP_STATUS_ERROR = 2;
    public int epStatus;

    protected int getSort(boolean bl) {
        if (bl) {
            return System.currentTimeMillis() - this.statusRefreshTs < 20000L ? this.sort : Integer.MAX_VALUE;
        }
        return this.sort;
    }

    private int calcSort(int n2) {
        int n3 = 0;
        block0 : switch (n2) {
            case 0: {
                switch (this.serverMode) {
                    case 0: {
                        n3 += 300;
                        break block0;
                    }
                    case 1: {
                        n3 += 2000;
                        break block0;
                    }
                    case 2: {
                        n3 += 10;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (this.serverMode) {
                    case 0: {
                        n3 += 30;
                        break block0;
                    }
                    case 1: {
                        n3 += 200;
                        break block0;
                    }
                    case 2: {
                        n3 += 1000;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                if (this.serverMode != 1) {
                    return -1;
                }
                n3 += 20;
                break;
            }
            case 2: {
                if (this.serverMode != 2) {
                    return -1;
                }
                n3 += 10;
                break;
            }
        }
        switch (this.serverStatus) {
            case 3: {
                n3 += 2;
                break;
            }
            case 4: {
                n3 += 3;
                break;
            }
            case 5: {
                ++n3;
                break;
            }
        }
        return n3;
    }

    public EP(String string, int n2) {
        this.host = string;
        this.port = n2;
    }

    private synchronized void refreshStatus(boolean bl, DmdbConnection dmdbConnection) {
        this.alive = bl;
        this.statusRefreshTs = System.currentTimeMillis();
        this.serverMode = bl ? dmdbConnection.svrMode : -1;
        this.serverStatus = bl ? dmdbConnection.svrStat : -1;
        this.dscControl = bl ? dmdbConnection.dscControl : false;
        this.sort = bl ? this.calcSort(dmdbConnection.loginMode) : -2;
    }

    public void connect(DmdbConnection dmdbConnection) {
        dmdbConnection.ep = this;
        dmdbConnection.host = this.host;
        dmdbConnection.port = this.port;
        dmdbConnection.props.setProperty(Configuration.host.getName(), this.host);
        dmdbConnection.props.setProperty(Configuration.port.getName(), String.valueOf(this.port));
        try {
            dmdbConnection.openConnection();
            this.refreshStatus(true, dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.refreshStatus(false, dmdbConnection);
            throw sQLException;
        }
    }

    public static String getServerStatusDesc(int n2) {
        String string = "";
        switch (n2) {
            case 4: {
                string = "OPEN";
                break;
            }
            case 3: {
                string = "MOUNT";
                break;
            }
            case 5: {
                string = "SUSPEND";
                break;
            }
            default: {
                string = "UNKNOW";
            }
        }
        return string;
    }

    public static String getServerModeDesc(int n2) {
        String string = "";
        switch (n2) {
            case 0: {
                string = "NORMAL";
                break;
            }
            case 1: {
                string = "PRIMARY";
                break;
            }
            case 2: {
                string = "STANDBY";
                break;
            }
            default: {
                string = "UNKNOW";
            }
        }
        return string;
    }

    public String toString() {
        return String.valueOf(StringUtil.trimToEmpty(this.host)) + ":" + this.port + " (" + EP.getServerModeDesc(this.serverMode) + ", " + EP.getServerStatusDesc(this.serverStatus) + (this.dscControl ? ", DSC CONTROL)" : ")");
    }
}

