/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import uk.ac.rdg.resc.edal.graphics.style.StyleXMLParser;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScheme;

@XmlType(namespace="http://www.resc.reading.ac.uk", propOrder={"minColour", "colours", "noDataColour"}, name="ThresholdColourSchemeType")
public class ThresholdColourScheme
extends ColourScheme {
    @XmlElement(name="MinColour", required=true, nillable=false)
    @XmlJavaTypeAdapter(value=StyleXMLParser.ColorAdapter.class)
    private Color minColour;
    @XmlElement(name="MissingDataColour")
    @XmlJavaTypeAdapter(value=StyleXMLParser.ColorAdapter.class)
    private Color noDataColour = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    @XmlElement(name="ThresholdValue", required=true)
    private List<ColourAndValue> colours;

    void afterUnmarshal(Unmarshaller u, Object parent) {
        this.initialiseColours();
    }

    ThresholdColourScheme() {
    }

    public ThresholdColourScheme(Color minColour, List<ColourAndValue> colours, Color noDataColour) {
        this.minColour = minColour;
        this.noDataColour = noDataColour;
        this.colours = colours;
        this.initialiseColours();
    }

    @Override
    public Color getColor(Number value) {
        if (value == null || Float.isNaN(value.floatValue())) {
            return this.noDataColour;
        }
        for (ColourAndValue band : this.colours) {
            if (!(value.floatValue() > band.value.floatValue())) continue;
            return band.colour;
        }
        return this.minColour;
    }

    private void initialiseColours() {
        if (this.colours == null || this.colours.size() < 1) {
            throw new IllegalArgumentException("Threshold values must not be null and must have at least one value");
        }
        Float value = Float.valueOf(-3.4028235E38f);
        for (ColourAndValue band : this.colours) {
            if (band.value.floatValue() < value.floatValue()) {
                throw new IllegalArgumentException("Threshold bands must be in ascending order of value");
            }
            value = band.value;
        }
        Collections.reverse(this.colours);
    }

    @Override
    public Float getScaleMin() {
        return this.colours.get(0).value;
    }

    @Override
    public Float getScaleMax() {
        return this.colours.get(this.colours.size() - 1).value;
    }

    @XmlType(namespace="http://www.resc.reading.ac.uk", propOrder={}, name="ColourAndValueType")
    public static class ColourAndValue {
        @XmlElement(name="Colour", required=true, nillable=false)
        @XmlJavaTypeAdapter(value=StyleXMLParser.ColorAdapter.class)
        private Color colour;
        @XmlElement(name="Value", required=true, nillable=false)
        private Float value;
    }
}

