/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import uk.ac.rdg.resc.edal.graphics.style.DataReadingTypes;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.GlyphLayer;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="SubsampledGlyphLayerType")
public class SubsampledGlyphLayer
extends GlyphLayer {
    @XmlElement(name="GlyphSpacing")
    private Float glyphSpacing = Float.valueOf(1.5f);

    void afterUnmarshal(Unmarshaller u, Object parent) {
        this.icon = this.getIcon(this.glyphIconName);
        if ((double)this.glyphSpacing.floatValue() < 1.0 || this.glyphSpacing == null) {
            throw new IllegalArgumentException("Glyph spacing must be non-null and => 1.0");
        }
        this.setXSampleSize((int)((float)this.icon.getWidth() * this.glyphSpacing.floatValue()));
        this.setYSampleSize((int)((float)this.icon.getHeight() * this.glyphSpacing.floatValue()));
    }

    public SubsampledGlyphLayer() throws InstantiationException {
        super(DataReadingTypes.PlotType.SUBSAMPLE);
    }

    public SubsampledGlyphLayer(String dataFieldName, String glyphIconName, float glyphSpacing, ColourScheme colourScheme) throws InstantiationException {
        super(DataReadingTypes.PlotType.SUBSAMPLE);
        this.dataFieldName = dataFieldName;
        this.glyphIconName = glyphIconName;
        this.glyphSpacing = Float.valueOf(glyphSpacing);
        this.colourScheme = colourScheme;
    }

    public float getGlyphSpacing() {
        return this.glyphSpacing.floatValue();
    }
}

