/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.graphics.style.DataReadingTypes;
import uk.ac.rdg.resc.edal.graphics.style.PlottingDatum;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ImageLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.PatternScale;
import uk.ac.rdg.resc.edal.util.Extents;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="PatternLayerType")
public class StippleLayer
extends ImageLayer {
    @XmlElement(name="DataFieldName", required=true)
    private String dataFieldName;
    @XmlElement(name="Scale", required=true)
    private PatternScale scale;
    private static int[][] thresholdMap = new int[][]{{1, 49, 13, 61, 4, 52, 16, 64}, {33, 17, 45, 29, 36, 20, 48, 32}, {9, 57, 5, 53, 12, 60, 8, 56}, {41, 25, 37, 21, 44, 28, 40, 24}, {3, 51, 15, 63, 2, 50, 14, 62}, {35, 19, 47, 31, 34, 18, 46, 30}, {11, 59, 7, 55, 10, 58, 6, 54}, {43, 27, 39, 23, 42, 26, 38, 22}};

    private StippleLayer() {
        super(DataReadingTypes.PlotType.RASTER);
    }

    public StippleLayer(String dataFieldName, PatternScale scale) {
        super(DataReadingTypes.PlotType.RASTER);
        this.dataFieldName = dataFieldName;
        this.scale = scale;
    }

    @Override
    protected void drawIntoImage(BufferedImage image, ImageLayer.DataReader dataReader) {
        int[][] alphas = new int[image.getWidth()][image.getHeight()];
        for (PlottingDatum datum : dataReader.getDataForLayerName(this.dataFieldName)) {
            int alpha;
            alphas[datum.getGridCoords().getXIndex()][datum.getGridCoords().getYIndex()] = alpha = (int)(256.0f * ((float)this.scale.getLevel(datum.getValue()) / (float)(this.scale.getNLevels() - 1)));
        }
        StippleLayer.stippleAlphas(image, alphas, image.getWidth(), image.getHeight());
    }

    private static void stippleAlphas(BufferedImage image, int[][] alphas, int width, int height) {
        int black = Color.black.getRGB();
        int transparent = new Color(0.0f, 0.0f, 0.0f, 0.0f).getRGB();
        for (int x = 0; x < width; ++x) {
            int xmod = x % thresholdMap.length;
            for (int y = 0; y < height; ++y) {
                int alpha = alphas[x][y];
                int ymod = y % thresholdMap[0].length;
                if ((float)alpha > (float)(256 * thresholdMap[xmod][ymod]) / ((float)thresholdMap.length * (float)thresholdMap[0].length + 1.0f)) {
                    image.setRGB(x, y, black);
                    continue;
                }
                image.setRGB(x, y, transparent);
            }
        }
    }

    @Override
    protected Set<Drawable.NameAndRange> getFieldsWithScales() {
        HashSet<Drawable.NameAndRange> ret = new HashSet<Drawable.NameAndRange>();
        if (this.scale.getOpaqueValue().floatValue() > this.scale.getTransparentValue().floatValue()) {
            ret.add(new Drawable.NameAndRange(this, this.dataFieldName, (Extent<Float>)Extents.newExtent((Object)this.scale.getTransparentValue(), (Object)this.scale.getOpaqueValue())));
        } else {
            ret.add(new Drawable.NameAndRange(this, this.dataFieldName, (Extent<Float>)Extents.newExtent((Object)this.scale.getOpaqueValue(), (Object)this.scale.getTransparentValue())));
        }
        return ret;
    }
}

