/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SimpleGrid;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Range2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.graphics.style.DataReadingTypes;
import uk.ac.rdg.resc.edal.graphics.style.PlottingDatum;
import uk.ac.rdg.resc.edal.graphics.style.StyleXMLParser;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScale;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ContourLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ImageLayer;
import uk.ac.rdg.resc.edal.util.Extents;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="SmoothedContourLayerType")
public class SmoothedContourLayer
extends ImageLayer {
    @XmlElement(name="DataFieldName", required=true)
    private String dataFieldName;
    @XmlElement(name="Scale")
    private ColourScale scale = new ColourScale();
    @XmlElement(name="AutoscaleEnabled")
    private Boolean autoscaleEnabled = true;
    @XmlElement(name="NumberOfContours")
    private Double numberOfContours = 10.0;
    @XmlElement(name="ContourLineColour")
    @XmlJavaTypeAdapter(value=StyleXMLParser.ColorAdapter.class)
    private Color contourLineColour = Color.BLACK;
    @XmlElement(name="ContourLineWidth")
    private Integer contourLineWidth = 1;
    @XmlElement(name="ContourLineStyle")
    private ContourLayer.ContourLineStyle contourLineStyle = ContourLayer.ContourLineStyle.DASHED;
    @XmlElement(name="LabelEnabled")
    private Boolean labelEnabled = true;

    private SmoothedContourLayer() {
        super(DataReadingTypes.PlotType.SMOOTHED);
    }

    public SmoothedContourLayer(String dataFieldName, ColourScale scale, boolean autoscaleEnabled, double numberOfContours, Color contourLineColour, int contourLineWidth, ContourLayer.ContourLineStyle contourLineStyle, boolean labelEnabled) {
        super(DataReadingTypes.PlotType.SMOOTHED);
        this.dataFieldName = dataFieldName;
        this.scale = scale;
        this.autoscaleEnabled = autoscaleEnabled;
        this.numberOfContours = numberOfContours;
        this.contourLineColour = contourLineColour;
        this.contourLineWidth = contourLineWidth;
        this.contourLineStyle = contourLineStyle;
        this.labelEnabled = labelEnabled;
    }

    public String getDataFieldName() {
        return this.dataFieldName;
    }

    public ColourScale getScale() {
        return this.scale;
    }

    public boolean isAutoscaleEnabled() {
        return this.autoscaleEnabled;
    }

    public double getNumberOfContours() {
        return this.numberOfContours;
    }

    public Color getContourLineColour() {
        return this.contourLineColour;
    }

    public int getContourLineWidth() {
        return this.contourLineWidth;
    }

    public ContourLayer.ContourLineStyle getContourLineStyle() {
        return this.contourLineStyle;
    }

    public boolean isLabelEnabled() {
        return this.labelEnabled;
    }

    @Override
    protected void drawIntoImage(BufferedImage image, ImageLayer.DataReader dataReader) {
        int width = image.getWidth();
        int height = image.getHeight();
        double[] values = new double[width * height];
        double[] xAxis = new double[width];
        double[] yAxis = new double[height];
        int count = 0;
        for (int i = 0; i < width; ++i) {
            xAxis[i] = i;
            for (int j = 0; j < height; ++j) {
                yAxis[j] = height - j - 1;
                values[count] = Double.NaN;
                ++count;
            }
        }
        Float scaleMin = null;
        Float scaleMax = null;
        if (this.autoscaleEnabled.booleanValue()) {
            scaleMin = Float.valueOf(Float.MAX_VALUE);
            scaleMax = Float.valueOf(-3.4028235E38f);
        } else {
            scaleMin = this.scale.getScaleMin();
            scaleMax = this.scale.getScaleMax();
        }
        for (PlottingDatum datum : dataReader.getDataForLayerName(this.dataFieldName)) {
            float val = datum.getValue() == null ? Float.NaN : datum.getValue().floatValue();
            values[height * datum.getGridCoords().getXIndex() + datum.getGridCoords().getYIndex()] = val;
            if (!this.autoscaleEnabled.booleanValue()) continue;
            if (val < scaleMin.floatValue()) {
                scaleMin = Float.valueOf(val);
            }
            if (!(val > scaleMax.floatValue())) continue;
            scaleMax = Float.valueOf(val);
        }
        SimpleGrid sgtGrid = new SimpleGrid(values, xAxis, yAxis, null);
        CartesianGraph cg = SmoothedContourLayer.getCartesianGraph((SGTData)sgtGrid, width, height);
        double contourSpacing = (double)(scaleMax.floatValue() - scaleMin.floatValue()) / this.numberOfContours;
        Range2D contourValues = new Range2D((double)scaleMin.floatValue(), (double)scaleMax.floatValue(), contourSpacing);
        ContourLevels clevels = ContourLevels.getDefault((Range2D)contourValues);
        DefaultContourLineAttribute defAttr = new DefaultContourLineAttribute();
        defAttr.setColor(this.contourLineColour);
        if (this.contourLineStyle != null) {
            defAttr.setStyle(this.contourLineStyle.getLineStyleInteger());
        }
        defAttr.setWidth((float)this.contourLineWidth.intValue());
        defAttr.setLabelEnabled(this.labelEnabled.booleanValue());
        clevels.setDefaultContourLineAttribute(defAttr);
        GridAttribute attr = new GridAttribute(clevels);
        attr.setStyle(2);
        CartesianRenderer renderer = CartesianRenderer.getRenderer((CartesianGraph)cg, (SGTData)sgtGrid, (Attribute)attr);
        Graphics g = image.getGraphics();
        renderer.draw(g);
    }

    private static CartesianGraph getCartesianGraph(SGTData data, int width, int height) {
        double factor = 96.0;
        double physWidth = (double)width / factor;
        double physHeight = (double)height / factor;
        Layer layer = new Layer("", new Dimension2D(physWidth, physHeight));
        JPane pane = new JPane("id", new Dimension(width, height));
        layer.setPane((AbstractPane)pane);
        layer.setBounds(0, 0, width, height);
        CartesianGraph graph = new CartesianGraph();
        Range2D physXRange = new Range2D(0.0, physWidth);
        Range2D physYRange = new Range2D(0.0, physHeight);
        LinearTransform xt = new LinearTransform(physXRange, data.getXRange());
        LinearTransform yt = new LinearTransform(physYRange, data.getYRange());
        graph.setXTransform((AxisTransform)xt);
        graph.setYTransform((AxisTransform)yt);
        layer.setGraph((Graph)graph);
        return graph;
    }

    @Override
    protected Set<Drawable.NameAndRange> getFieldsWithScales() {
        HashSet<Drawable.NameAndRange> ret = new HashSet<Drawable.NameAndRange>();
        ret.add(new Drawable.NameAndRange(this, this.dataFieldName, (Extent<Float>)Extents.newExtent((Object)this.scale.getScaleMin(), (Object)this.scale.getScaleMax())));
        return ret;
    }
}

