/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.graphics.style.DataReadingTypes;
import uk.ac.rdg.resc.edal.graphics.style.PlottingDatum;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ImageLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.PaletteColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ThresholdColourScheme;
import uk.ac.rdg.resc.edal.util.Extents;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="RasterLayerType")
public class RasterLayer
extends ImageLayer {
    @XmlElement(name="DataFieldName", required=true)
    private String dataFieldName;
    @XmlElements(value={@XmlElement(name="PaletteColourScheme", type=PaletteColourScheme.class), @XmlElement(name="ThresholdColourScheme", type=ThresholdColourScheme.class)})
    private ColourScheme colourScheme = new PaletteColourScheme();

    private RasterLayer() {
        super(DataReadingTypes.PlotType.RASTER);
    }

    public RasterLayer(String dataFieldName, ColourScheme colourScheme) {
        super(DataReadingTypes.PlotType.RASTER);
        this.dataFieldName = dataFieldName;
        this.colourScheme = colourScheme;
    }

    public String getDataFieldName() {
        return this.dataFieldName;
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    @Override
    protected void drawIntoImage(BufferedImage image, ImageLayer.DataReader dataReader) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        for (PlottingDatum datum : dataReader.getDataForLayerName(this.dataFieldName)) {
            pixels[datum.getGridCoords().getXIndex() + datum.getGridCoords().getYIndex() * image.getWidth()] = this.colourScheme.getColor(datum.getValue()).getRGB();
        }
        image.setRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
    }

    @Override
    protected Set<Drawable.NameAndRange> getFieldsWithScales() {
        HashSet<Drawable.NameAndRange> ret = new HashSet<Drawable.NameAndRange>();
        ret.add(new Drawable.NameAndRange(this, this.dataFieldName, (Extent<Float>)Extents.newExtent((Object)this.colourScheme.getScaleMin(), (Object)this.colourScheme.getScaleMax())));
        return ret;
    }
}

