/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(namespace="http://www.resc.reading.ac.uk", propOrder={}, name="PatternScaleType")
public class PatternScale {
    @XmlElement(name="PatternBands")
    private int nLevels = 10;
    @XmlElement(name="OpaqueValue", required=true)
    private Float opaqueValue;
    @XmlElement(name="TransparentValue", required=true)
    private Float transparentValue;
    @XmlElement(name="Logarithmic")
    private Boolean logarithmic = false;

    private PatternScale() {
    }

    public PatternScale(int nLevels, Float transparentValue, Float opaqueValue, Boolean logarithmic) {
        this.nLevels = nLevels;
        this.opaqueValue = opaqueValue;
        this.transparentValue = transparentValue;
        this.logarithmic = logarithmic;
    }

    public int getNLevels() {
        return this.nLevels;
    }

    public Float getOpaqueValue() {
        return this.opaqueValue;
    }

    public Float getTransparentValue() {
        return this.transparentValue;
    }

    public int getLevel(Number value) {
        if (value == null || Float.isNaN(value.floatValue())) {
            return 0;
        }
        if (this.opaqueValue.floatValue() > this.transparentValue.floatValue()) {
            if (value.floatValue() < this.transparentValue.floatValue()) {
                return 0;
            }
            if (value.floatValue() >= this.opaqueValue.floatValue()) {
                return this.nLevels - 1;
            }
            if (this.logarithmic.booleanValue()) {
                return (int)Math.floor(1.0 + (double)(this.nLevels - 2) * ((Math.log(value.floatValue()) - Math.log(this.transparentValue.floatValue())) / (Math.log(this.opaqueValue.floatValue()) - Math.log(this.transparentValue.floatValue()))));
            }
            return (int)Math.floor(1.0f + (float)(this.nLevels - 2) * ((value.floatValue() - this.transparentValue.floatValue()) / (this.opaqueValue.floatValue() - this.transparentValue.floatValue())));
        }
        if (value.floatValue() >= this.transparentValue.floatValue()) {
            return 0;
        }
        if (value.floatValue() < this.opaqueValue.floatValue()) {
            return this.nLevels - 1;
        }
        if (this.logarithmic.booleanValue()) {
            return this.nLevels - 2 - (int)Math.floor(2.0 + (double)(this.nLevels - 2) * ((Math.log(this.transparentValue.floatValue()) - Math.log(value.floatValue())) / (Math.log(this.opaqueValue.floatValue()) - Math.log(this.transparentValue.floatValue()))));
        }
        return this.nLevels - 2 - (int)Math.floor(2.0f + (float)(this.nLevels - 2) * ((this.transparentValue.floatValue() - value.floatValue()) / (this.opaqueValue.floatValue() - this.transparentValue.floatValue())));
    }

    public static void main(String[] args) {
        PatternScale s = new PatternScale(4, Float.valueOf(40.0f), Float.valueOf(0.0f), false);
        System.out.println(s.getLevel(-0.1));
        System.out.println();
        System.out.println(s.getLevel(0.0));
        System.out.println(s.getLevel(5.0));
        System.out.println(s.getLevel(10.0));
        System.out.println(s.getLevel(15.0));
        System.out.println(s.getLevel(19.99999));
        System.out.println();
        System.out.println();
        System.out.println(s.getLevel(20.0));
        System.out.println(s.getLevel(25.0));
        System.out.println(s.getLevel(29.99999));
        System.out.println(s.getLevel(30.0));
        System.out.println(s.getLevel(35.0));
        System.out.println(s.getLevel(39.99999));
        System.out.println();
        System.out.println();
        System.out.println(s.getLevel(40.0));
    }
}

