/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.graphics.style.PlottingDatum;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ImageLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.OpacityTransform;
import uk.ac.rdg.resc.edal.util.Extents;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="LinearOpacityType")
public class LinearOpacity
extends OpacityTransform {
    @XmlElement(name="DataFieldName", required=true)
    private String dataFieldName;
    @XmlElement(name="OpaqueValue", required=true)
    private Float opaqueValue;
    @XmlElement(name="TransparentValue", required=true)
    private Float transparentValue;

    LinearOpacity() {
    }

    public LinearOpacity(String dataFieldName, Float opaqueValue, Float transparentValue) {
        this.dataFieldName = dataFieldName;
        this.opaqueValue = opaqueValue;
        this.transparentValue = transparentValue;
    }

    private Float getOpacityForValue(Float value) {
        boolean highOpaque;
        if (value == null || Float.isNaN(value.floatValue())) {
            return Float.valueOf(1.0f);
        }
        boolean bl = highOpaque = this.opaqueValue.floatValue() > this.transparentValue.floatValue();
        if (highOpaque) {
            if (value.floatValue() > this.opaqueValue.floatValue()) {
                return Float.valueOf(1.0f);
            }
            if (value.floatValue() < this.transparentValue.floatValue()) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf((value.floatValue() - this.transparentValue.floatValue()) / (this.opaqueValue.floatValue() - this.transparentValue.floatValue()));
        }
        if (value.floatValue() < this.opaqueValue.floatValue()) {
            return Float.valueOf(1.0f);
        }
        if (value.floatValue() > this.transparentValue.floatValue()) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(1.0f - (value.floatValue() - this.opaqueValue.floatValue()) / (this.transparentValue.floatValue() - this.opaqueValue.floatValue()));
    }

    @Override
    protected void applyOpacityToImage(BufferedImage image, ImageLayer.DataReader dataReader) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] imagePixels = image.getRGB(0, 0, width, height, null, 0, width);
        for (PlottingDatum datum : dataReader.getDataForLayerName(this.dataFieldName)) {
            int xIndex = datum.getGridCoords().getXIndex();
            int yIndex = datum.getGridCoords().getYIndex();
            int imageIndex = xIndex + yIndex * width;
            int alpha = (int)(this.getOpacityForValue(Float.valueOf(datum.getValue().floatValue())).floatValue() * 255.0f);
            imagePixels[imageIndex] = this.blendPixel(imagePixels[imageIndex], alpha);
        }
        image.setRGB(0, 0, width, height, imagePixels, 0, width);
    }

    @Override
    protected Set<Drawable.NameAndRange> getFieldsWithScales() {
        HashSet<Drawable.NameAndRange> ret = new HashSet<Drawable.NameAndRange>();
        if (this.opaqueValue.floatValue() > this.transparentValue.floatValue()) {
            ret.add(new Drawable.NameAndRange(this, this.dataFieldName, (Extent<Float>)Extents.newExtent((Object)this.transparentValue, (Object)this.opaqueValue)));
        } else {
            ret.add(new Drawable.NameAndRange(this, this.dataFieldName, (Extent<Float>)Extents.newExtent((Object)this.opaqueValue, (Object)this.transparentValue)));
        }
        return ret;
    }

    public static void main(String[] args) {
        LinearOpacity o = new LinearOpacity("a", Float.valueOf(0.0f), Float.valueOf(1.0f));
        LinearOpacity o2 = new LinearOpacity("a", Float.valueOf(1.0f), Float.valueOf(0.0f));
        float i = -0.01f;
        while (i <= 1.01f) {
            System.out.println(i + ", " + o.getOpacityForValue(Float.valueOf(i)) + ", " + o2.getOpacityForValue(Float.valueOf(i)));
            i = (float)((double)i + 0.01);
        }
    }
}

