/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import uk.ac.rdg.resc.edal.coverage.DomainObjectValuePair;
import uk.ac.rdg.resc.edal.coverage.GridCoverage2D;
import uk.ac.rdg.resc.edal.coverage.TrajectoryCoverage;
import uk.ac.rdg.resc.edal.coverage.grid.GridCell2D;
import uk.ac.rdg.resc.edal.coverage.grid.GridCoordinates2D;
import uk.ac.rdg.resc.edal.coverage.grid.GridValuesMatrix;
import uk.ac.rdg.resc.edal.coverage.grid.HorizontalGrid;
import uk.ac.rdg.resc.edal.coverage.grid.RegularAxis;
import uk.ac.rdg.resc.edal.coverage.grid.RegularGrid;
import uk.ac.rdg.resc.edal.coverage.grid.VerticalAxis;
import uk.ac.rdg.resc.edal.coverage.grid.impl.BorderedGrid;
import uk.ac.rdg.resc.edal.coverage.grid.impl.GridCoordinates2DImpl;
import uk.ac.rdg.resc.edal.coverage.grid.impl.RegularGridImpl;
import uk.ac.rdg.resc.edal.coverage.impl.GridCoverage2DWrappedGridSeriesCoverage;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.FeatureCollection;
import uk.ac.rdg.resc.edal.feature.GridFeature;
import uk.ac.rdg.resc.edal.feature.GridSeriesFeature;
import uk.ac.rdg.resc.edal.feature.PointSeriesFeature;
import uk.ac.rdg.resc.edal.feature.ProfileFeature;
import uk.ac.rdg.resc.edal.feature.TrajectoryFeature;
import uk.ac.rdg.resc.edal.geometry.BoundingBox;
import uk.ac.rdg.resc.edal.graphics.style.BilinearInterpolator;
import uk.ac.rdg.resc.edal.graphics.style.DataReadingTypes;
import uk.ac.rdg.resc.edal.graphics.style.FeatureCollectionAndMemberName;
import uk.ac.rdg.resc.edal.graphics.style.GlobalPlottingParams;
import uk.ac.rdg.resc.edal.graphics.style.Id2FeatureAndMember;
import uk.ac.rdg.resc.edal.graphics.style.PlottingDatum;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.position.GeoPosition;
import uk.ac.rdg.resc.edal.position.HorizontalPosition;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.edal.position.VerticalPosition;
import uk.ac.rdg.resc.edal.position.impl.HorizontalPositionImpl;
import uk.ac.rdg.resc.edal.position.impl.VerticalPositionImpl;
import uk.ac.rdg.resc.edal.util.BigList;
import uk.ac.rdg.resc.edal.util.CollectionUtils;
import uk.ac.rdg.resc.edal.util.GISUtils;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="ImageLayerType")
public abstract class ImageLayer
extends Drawable {
    private DataReadingTypes.PlotType plotType;
    private int xSampleSize = 8;
    private int ySampleSize = 8;
    private DataReadingTypes.SubsampleType subsampleType = DataReadingTypes.SubsampleType.CLOSEST;

    private ImageLayer() {
    }

    public ImageLayer(DataReadingTypes.PlotType plotType) {
        this.plotType = plotType;
    }

    @Override
    public BufferedImage drawImage(GlobalPlottingParams params, Id2FeatureAndMember id2Feature) {
        BufferedImage image = new BufferedImage(params.getWidth(), params.getHeight(), 2);
        this.drawIntoImage(image, params, id2Feature);
        return image;
    }

    protected void drawIntoImage(BufferedImage image, final GlobalPlottingParams params, final Id2FeatureAndMember id2Feature) {
        this.drawIntoImage(image, new DataReader(){

            @Override
            public List<PlottingDatum> getDataForLayerName(String layerId) {
                FeatureCollectionAndMemberName featureAndMemberName = id2Feature.getFeatureAndMemberName(layerId);
                return ImageLayer.this.getDataFromFeatures(featureAndMemberName, params);
            }
        });
    }

    public DataReadingTypes.PlotType getPlotType() {
        return this.plotType;
    }

    public void setXSampleSize(int xSampleSize) {
        this.xSampleSize = xSampleSize;
    }

    @XmlTransient
    public int getXSampleSize() {
        return this.xSampleSize;
    }

    public void setYSampleSize(int ySampleSize) {
        this.ySampleSize = ySampleSize;
    }

    @XmlTransient
    public int getYSampleSize() {
        return this.ySampleSize;
    }

    public void setSubsampleType(DataReadingTypes.SubsampleType subsampleType) {
        this.subsampleType = subsampleType;
    }

    @XmlTransient
    public DataReadingTypes.SubsampleType getSubsampleType() {
        return this.subsampleType;
    }

    protected abstract void drawIntoImage(BufferedImage var1, DataReader var2);

    private List<PlottingDatum> getDataFromFeatures(FeatureCollectionAndMemberName featureAndMemberName, GlobalPlottingParams params) {
        FeatureCollection<? extends Feature> featureCollection = featureAndMemberName.getFeatureCollection();
        String member = featureAndMemberName.getMemberName();
        BoundingBox biggerBbox = new BorderedGrid(params.getBbox(), params.getWidth(), params.getHeight()).getCoordinateExtent();
        Collection features = featureCollection.findFeatures(biggerBbox, params.getZExtent(), params.getTExtent(), CollectionUtils.setOf((Object[])new String[]{member}));
        ArrayList<PlottingDatum> data = new ArrayList<PlottingDatum>();
        for (Feature feature : features) {
            if (feature instanceof GridSeriesFeature) {
                data.addAll(this.getDataFromGridSeriesFeature((GridSeriesFeature)feature, member, params));
                continue;
            }
            if (feature instanceof GridFeature) {
                data.addAll(this.getDataFromGridCoverage2D(((GridFeature)feature).getCoverage(), member, params));
                continue;
            }
            if (feature instanceof PointSeriesFeature) {
                data.addAll(this.getDataFromPointSeriesFeature((PointSeriesFeature)feature, member, params));
                continue;
            }
            if (feature instanceof ProfileFeature) {
                data.addAll(this.getDataFromProfileFeature((ProfileFeature)feature, member, params));
                continue;
            }
            if (feature instanceof TrajectoryFeature) {
                data.addAll(this.getDataFromTrajectoryFeature((TrajectoryFeature)feature, member, params));
                continue;
            }
            throw new UnsupportedOperationException("Plotting of features of the type " + feature.getClass() + " on a map is not yet supported");
        }
        return data;
    }

    private List<PlottingDatum> getDataFromGridSeriesFeature(GridSeriesFeature gridSeriesFeature, String member, GlobalPlottingParams params) {
        VerticalPositionImpl vPos = null;
        if (gridSeriesFeature.getCoverage().getDomain().getVerticalAxis() != null && params.getTargetZ() != null) {
            vPos = new VerticalPositionImpl(params.getTargetZ().doubleValue(), gridSeriesFeature.getCoverage().getDomain().getVerticalCrs());
        }
        if (this.getPlotType() == DataReadingTypes.PlotType.SMOOTHED) {
            return this.getDataFromGridCoverage2D(gridSeriesFeature.getCoverage().extractGridCoverage(gridSeriesFeature.getCoverage().getDomain().getHorizontalGrid(), (VerticalPosition)vPos, params.getTargetT(), CollectionUtils.setOf((Object[])new String[]{member})), member, params);
        }
        return this.getDataFromGridCoverage2D((GridCoverage2D)new GridCoverage2DWrappedGridSeriesCoverage(gridSeriesFeature.getCoverage(), vPos, params.getTargetT()), member, params);
    }

    private List<PlottingDatum> getDataFromGridCoverage2D(GridCoverage2D coverage, String member, GlobalPlottingParams params) {
        ArrayList<PlottingDatum> plottingData = new ArrayList<PlottingDatum>();
        Set members = CollectionUtils.setOf((Object[])new String[]{member});
        switch (this.getPlotType()) {
            case RASTER: {
                RegularGridImpl targetDomain = new RegularGridImpl(params.getBbox(), params.getWidth(), params.getHeight());
                if (!coverage.getDomain().equals(targetDomain)) {
                    coverage = coverage.extractGridCoverage((HorizontalGrid)targetDomain, members);
                }
                List list = coverage.list();
                for (DomainObjectValuePair entry : list) {
                    GridCoordinates2D gridCoordinates = ((GridCell2D)entry.getDomainObject()).getGridCoordinates();
                    GridCoordinates2DImpl coords = new GridCoordinates2DImpl(gridCoordinates.getXIndex(), params.getHeight() - gridCoordinates.getYIndex() - 1);
                    plottingData.add(new PlottingDatum((GridCoordinates2D)coords, (Number)entry.getValue().getValue(member)));
                }
                break;
            }
            case SUBSAMPLE: {
                RegularGridImpl targetDomain = new RegularGridImpl(params.getBbox(), params.getWidth(), params.getHeight());
                if (!coverage.getDomain().equals(targetDomain)) {
                    coverage = coverage.extractGridCoverage((HorizontalGrid)targetDomain, members);
                }
                int xss = this.getXSampleSize();
                int yss = this.getYSampleSize();
                for (int i = xss / 2; i <= params.getWidth(); i += xss) {
                    for (int j = yss / 2; j <= params.getHeight(); j += yss) {
                        GridCell2D gridCell = coverage.getDomain().getGridCell(i, j);
                        Object value = coverage.evaluate((Object)gridCell.getCentre(), member);
                        GridCoordinates2DImpl coords = new GridCoordinates2DImpl(i, params.getHeight() - j + 1);
                        plottingData.add(new PlottingDatum((GridCoordinates2D)coords, (Number)value));
                    }
                }
                break;
            }
            case GLYPH: {
                BorderedGrid borderedTargetDomain = new BorderedGrid(params.getBbox(), params.getWidth(), params.getHeight());
                RegularAxis xAxis = borderedTargetDomain.getXAxis();
                RegularAxis yAxis = borderedTargetDomain.getYAxis();
                CoordinateReferenceSystem crs = params.getBbox().getCoordinateReferenceSystem();
                HorizontalGrid featureGrid = coverage.getDomain();
                LinkedHashSet<Long> neededIndices = new LinkedHashSet<Long>();
                Iterator i$ = xAxis.getCoordinateValues().iterator();
                while (i$.hasNext()) {
                    double x = (Double)i$.next();
                    Iterator i$2 = yAxis.getCoordinateValues().iterator();
                    while (i$2.hasNext()) {
                        double y = (Double)i$2.next();
                        long index = featureGrid.findIndexOf((Object)new HorizontalPositionImpl(x, y, crs));
                        if (index <= 0L) continue;
                        neededIndices.add(index);
                    }
                }
                i$ = neededIndices.iterator();
                while (i$.hasNext()) {
                    long index = (Long)i$.next();
                    GridCoordinates2D gridCoords = featureGrid.getCoords(index);
                    HorizontalPosition hPos = featureGrid.getGridCell(gridCoords).getCentre();
                    List containingCells = borderedTargetDomain.findAllContainingCells(hPos);
                    for (GridCell2D containingCell : containingCells) {
                        Number val;
                        if (containingCell == null || (val = (Number)coverage.evaluate((Object)hPos, member)) == null || Float.isNaN(val.floatValue())) continue;
                        GridCoordinates2D gridCoordinates = containingCell.getGridCoordinates();
                        GridCoordinates2DImpl coords = new GridCoordinates2DImpl(gridCoordinates.getXIndex(), params.getHeight() - gridCoordinates.getYIndex() - 1);
                        plottingData.add(new PlottingDatum((GridCoordinates2D)coords, val));
                    }
                }
                break;
            }
            case SMOOTHED: {
                HorizontalGrid featureHorizGrid = coverage.getDomain();
                if (featureHorizGrid instanceof RegularGrid) {
                    int i;
                    RegularGrid featureGrid = (RegularGrid)featureHorizGrid;
                    RegularAxis xAxis = featureGrid.getXAxis();
                    RegularAxis yAxis = featureGrid.getYAxis();
                    double[][] dataToInterpolate = new double[xAxis.size()][yAxis.size()];
                    coverage.evaluate((Object)new HorizontalPositionImpl(0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
                    GridValuesMatrix gridValues = coverage.getGridValues(member);
                    BigList values = gridValues.getValues();
                    for (i = 0; i < xAxis.size(); ++i) {
                        for (int j = 0; j < yAxis.size(); ++j) {
                            dataToInterpolate[i][j] = ((Number)values.get(gridValues.getIndex(new int[]{i, j}))).doubleValue();
                        }
                    }
                    BilinearInterpolator interpolator = new BilinearInterpolator(xAxis.getCoordinateValues(), yAxis.getCoordinateValues(), dataToInterpolate);
                    RegularGridImpl targetDomain = new RegularGridImpl(params.getBbox(), params.getWidth(), params.getHeight());
                    for (i = 0; i < params.getWidth(); ++i) {
                        double x = (Double)targetDomain.getXAxis().getCoordinateValue(i);
                        for (int j = 0; j < params.getHeight(); ++j) {
                            double y = (Double)targetDomain.getYAxis().getCoordinateValue(j);
                            double val = interpolator.getValue(x, y);
                            GridCoordinates2DImpl coords = new GridCoordinates2DImpl(i, params.getHeight() - j - 1);
                            plottingData.add(new PlottingDatum((GridCoordinates2D)coords, val));
                        }
                    }
                    break;
                }
                throw new IllegalArgumentException("Only regular grids can be smoothed at present");
            }
            default: {
                throw new IllegalArgumentException("GridFeatures are incompatible with this plotting type: " + (Object)((Object)this.getPlotType()));
            }
        }
        return plottingData;
    }

    private List<PlottingDatum> getDataFromPointSeriesFeature(PointSeriesFeature feature, String member, GlobalPlottingParams params) {
        BorderedGrid targetDomain = new BorderedGrid(params.getBbox(), params.getWidth(), params.getHeight());
        GridCell2D containingCell = targetDomain.findContainingCell(feature.getHorizontalPosition());
        if (containingCell != null) {
            GridCoordinates2D gridCoordinates = containingCell.getGridCoordinates();
            Number value = (Number)feature.getCoverage().evaluate((Object)GISUtils.getClosestTimeTo((TimePosition)params.getTargetT(), (List)feature.getCoverage().getDomain().getTimes()), member);
            return Arrays.asList(new PlottingDatum(gridCoordinates, value));
        }
        return Collections.emptyList();
    }

    private List<PlottingDatum> getDataFromProfileFeature(ProfileFeature feature, String member, GlobalPlottingParams params) {
        BorderedGrid targetDomain = new BorderedGrid(params.getBbox(), params.getWidth(), params.getHeight());
        GridCell2D containingCell = targetDomain.findContainingCell(feature.getHorizontalPosition());
        if (containingCell != null) {
            GridCoordinates2D gridCoordinates = containingCell.getGridCoordinates();
            Number value = (Number)feature.getCoverage().evaluate((Object)GISUtils.getClosestElevationTo((Double)params.getTargetZ(), (VerticalAxis)GISUtils.getVerticalAxis((Feature)feature)), member);
            return Arrays.asList(new PlottingDatum(gridCoordinates, value));
        }
        return Collections.emptyList();
    }

    private List<PlottingDatum> getDataFromTrajectoryFeature(TrajectoryFeature feature, String member, GlobalPlottingParams params) {
        if (this.getPlotType() != DataReadingTypes.PlotType.TRAJECTORY) {
            return Collections.emptyList();
        }
        RegularGridImpl targetDomain = new RegularGridImpl(params.getBbox(), params.getWidth(), params.getHeight());
        TrajectoryCoverage coverage = feature.getCoverage();
        List positions = coverage.getDomain().getDomainObjects();
        ArrayList<PlottingDatum> data = new ArrayList<PlottingDatum>();
        for (GeoPosition geoPos : positions) {
            HorizontalPosition pos = geoPos.getHorizontalPosition();
            if (pos.getCoordinateReferenceSystem() != targetDomain.getCoordinateReferenceSystem()) {
                pos = GISUtils.transformPosition((HorizontalPosition)pos, (CoordinateReferenceSystem)targetDomain.getCoordinateReferenceSystem());
            }
            double fracAlongX = (pos.getX() - (Double)targetDomain.getXAxis().getCoordinateExtent().getLow()) / ((Double)targetDomain.getXAxis().getCoordinateExtent().getHigh() - (Double)targetDomain.getXAxis().getCoordinateExtent().getLow());
            int xIndex = (int)(fracAlongX * (double)params.getWidth());
            double fracAlongY = (pos.getY() - (Double)targetDomain.getYAxis().getCoordinateExtent().getLow()) / ((Double)targetDomain.getYAxis().getCoordinateExtent().getHigh() - (Double)targetDomain.getYAxis().getCoordinateExtent().getLow());
            int yIndex = params.getHeight() - 1 - (int)(fracAlongY * (double)params.getHeight());
            data.add(new PlottingDatum((GridCoordinates2D)new GridCoordinates2DImpl(xIndex, yIndex), (Number)coverage.evaluate((Object)geoPos, member)));
        }
        return data;
    }

    protected static interface DataReader {
        public List<PlottingDatum> getDataForLayerName(String var1);
    }
}

