/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import uk.ac.rdg.resc.edal.graphics.style.GlobalPlottingParams;
import uk.ac.rdg.resc.edal.graphics.style.Id2FeatureAndMember;
import uk.ac.rdg.resc.edal.graphics.style.LegendDataGenerator;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ArrowLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.BasicGlyphLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourMap;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScale;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ConfidenceIntervalLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ContourLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.LinearOpacity;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.OpacityTransform;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.PaletteColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.PatternScale;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.RasterLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.StippleLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.SubsampledGlyphLayer;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="ImageType")
@XmlRootElement(namespace="http://www.resc.reading.ac.uk", name="Image")
public class Image
extends Drawable {
    public static final String NAMESPACE = "http://www.resc.reading.ac.uk";
    @XmlElements(value={@XmlElement(name="Image", type=Image.class), @XmlElement(name="ArrowLayer", type=ArrowLayer.class), @XmlElement(name="RasterLayer", type=RasterLayer.class), @XmlElement(name="StippleLayer", type=StippleLayer.class), @XmlElement(name="ContourLayer", type=ContourLayer.class), @XmlElement(name="BasicGlyphLayer", type=BasicGlyphLayer.class), @XmlElement(name="SubsampledGlyphLayer", type=SubsampledGlyphLayer.class), @XmlElement(name="ConfidenceIntervalLayer", type=ConfidenceIntervalLayer.class)})
    private List<Drawable> layers = new ArrayList<Drawable>();
    private static final int COLOURBAR_WIDTH = 50;

    public List<Drawable> getLayers() {
        return this.layers;
    }

    @Override
    public BufferedImage drawImage(GlobalPlottingParams params, Id2FeatureAndMember id2Feature) {
        BufferedImage finalImage = new BufferedImage(params.getWidth(), params.getHeight(), 2);
        Graphics2D graphics = finalImage.createGraphics();
        for (Drawable drawable : this.layers) {
            if (drawable == null) continue;
            BufferedImage drawnImage = drawable.drawImage(params, id2Feature);
            OpacityTransform opacityTransform = drawable.getOpacityTransform();
            if (opacityTransform != null) {
                opacityTransform.drawIntoImage(drawnImage, params, id2Feature);
            }
            graphics.drawImage((java.awt.Image)drawnImage, 0, 0, null);
        }
        if (this.getOpacityTransform() != null) {
            this.getOpacityTransform().drawIntoImage(finalImage, params, id2Feature);
        }
        return finalImage;
    }

    public BufferedImage getLegend(int componentSize) {
        BufferedImage finalImage;
        Set<Drawable.NameAndRange> fieldsWithScales = this.getFieldsWithScales();
        int noOfIndependentFields = fieldsWithScales.size();
        Color bgColour = Color.black;
        Color fgColour = Color.white;
        float extraAmountOutOfRange = 0.1f;
        if (noOfIndependentFields == 0) {
            return null;
        }
        if (noOfIndependentFields == 1) {
            Drawable.NameAndRange nameAndRange = fieldsWithScales.iterator().next();
            LegendDataGenerator dataGenerator = new LegendDataGenerator(fieldsWithScales, 50, componentSize, null, extraAmountOutOfRange);
            BufferedImage colourbar = this.drawImage(dataGenerator.getGlobalParams(), dataGenerator.getId2FeatureAndMember(null, nameAndRange.getFieldLabel()));
            Graphics2D graphics = colourbar.createGraphics();
            graphics.setColor(fgColour);
            graphics.drawRect(0, 0, colourbar.getWidth() - 1, colourbar.getHeight() - 1);
            graphics.dispose();
            BufferedImage labels = Image.getLabels(nameAndRange, extraAmountOutOfRange, componentSize, fgColour);
            finalImage = new BufferedImage(50 + labels.getWidth(), componentSize, 2);
            graphics = finalImage.createGraphics();
            graphics.setColor(bgColour);
            graphics.fill(new Rectangle(finalImage.getWidth(), finalImage.getHeight()));
            graphics.drawImage((java.awt.Image)colourbar, 0, 0, null);
            graphics.drawImage((java.awt.Image)labels, 50, 0, null);
        } else {
            int numberOfImagesInOneDirection = noOfIndependentFields - 1;
            ArrayList<Drawable.NameAndRange> fields = new ArrayList<Drawable.NameAndRange>(fieldsWithScales);
            BufferedImage[] labels = new BufferedImage[fields.size()];
            int borderSize = 0;
            for (int i = 0; i < fields.size(); ++i) {
                labels[i] = Image.getLabels((Drawable.NameAndRange)fields.get(i), extraAmountOutOfRange, componentSize, fgColour);
                if (labels[i].getWidth() <= borderSize) continue;
                borderSize = labels[i].getWidth() + 8;
            }
            int totalImageSize = (componentSize + borderSize) * numberOfImagesInOneDirection;
            finalImage = new BufferedImage(totalImageSize, totalImageSize, 2);
            Graphics2D graphics = finalImage.createGraphics();
            graphics.setColor(bgColour);
            graphics.fillRect(0, 0, totalImageSize, totalImageSize);
            BufferedImage bg = null;
            BufferedImage bgMask = null;
            try {
                bg = ImageIO.read(Image.class.getResource("/img/map_bg_200.png"));
                bgMask = ImageIO.read(Image.class.getResource("/img/map_bg_200_mask.png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < fields.size(); ++i) {
                String yName = ((Drawable.NameAndRange)fields.get(i)).getFieldLabel();
                int yStart = 2 + i * (componentSize + borderSize);
                for (int j = i + 1; j < fields.size(); ++j) {
                    int xStart = 2 + (j - i - 1) * (componentSize + borderSize);
                    String xName = ((Drawable.NameAndRange)fields.get(j)).getFieldLabel();
                    LegendDataGenerator dataGenerator = new LegendDataGenerator(fieldsWithScales, componentSize, componentSize, bgMask, 0.1f);
                    BufferedImage colourbar2d = this.drawImage(dataGenerator.getGlobalParams(), dataGenerator.getId2FeatureAndMember(xName, yName));
                    if (bg != null) {
                        graphics.drawImage(bg, xStart, yStart, componentSize, componentSize, null);
                    }
                    graphics.drawImage((java.awt.Image)colourbar2d, xStart, yStart, null);
                    graphics.setColor(fgColour);
                    graphics.drawRect(xStart, yStart, colourbar2d.getWidth() - 1, colourbar2d.getHeight() - 1);
                    graphics.drawRect(xStart - 2, yStart - 2, borderSize + colourbar2d.getWidth() - 2, borderSize + colourbar2d.getHeight() - 2);
                    graphics.drawRect(xStart - 1, yStart - 1, borderSize + colourbar2d.getWidth() - 2, borderSize + colourbar2d.getHeight() - 2);
                    AffineTransform at = new AffineTransform();
                    at.translate(xStart + componentSize, yStart + componentSize);
                    at.rotate(1.5707963267948966);
                    graphics.drawImage(labels[j], at, null);
                    graphics.drawImage((java.awt.Image)labels[i], xStart + componentSize, yStart, null);
                }
            }
        }
        return finalImage;
    }

    private static BufferedImage getLabels(Drawable.NameAndRange nameAndRange, float extraAmountOutOfRange, int componentSize, Color textColor) {
        String fieldName = nameAndRange.getFieldLabel();
        Font textFont = new Font("SansSerif", 0, 12);
        AffineTransform at = new AffineTransform();
        at.rotate(-1.5707963267948966);
        Font sidewaysFont = textFont.deriveFont(at);
        DecimalFormat formatter = new DecimalFormat("0.###E0");
        int textBorder = 4;
        Float lowVal = (Float)nameAndRange.getScaleRange().getLow();
        Float highVal = (Float)nameAndRange.getScaleRange().getHigh();
        String lowStr = formatter.format(lowVal);
        String medLowStr = formatter.format((double)lowVal.floatValue() + (double)(highVal.floatValue() - lowVal.floatValue()) / 3.0);
        String medHighStr = formatter.format((double)lowVal.floatValue() + 2.0 * (double)(highVal.floatValue() - lowVal.floatValue()) / 3.0);
        String highStr = formatter.format(highVal);
        BufferedImage tempImage = new BufferedImage(1, 1, 12);
        Graphics2D graphics = tempImage.createGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(textFont);
        int lineHeight = fontMetrics.getHeight();
        int textHeightOffset = lineHeight / 3;
        int outOfRangeOffset = (int)((float)componentSize * extraAmountOutOfRange / (1.0f + 2.0f * extraAmountOutOfRange));
        int lowYPos = componentSize - outOfRangeOffset + textHeightOffset;
        int highYPos = outOfRangeOffset + textHeightOffset;
        int medLowYPos = (int)((double)highYPos + 2.0 * (double)(lowYPos - highYPos) / 3.0);
        int medHighYPos = (int)((double)highYPos + 1.0 * (double)(lowYPos - highYPos) / 3.0);
        int fieldLength = fontMetrics.stringWidth(fieldName);
        int nLines = (int)Math.ceil((double)(fieldLength + 20) / (double)componentSize);
        if (nLines > 1) {
            int charsPerLine = 1 + fieldName.length() / nLines;
            StringBuilder newFieldName = new StringBuilder();
            for (int i = 0; i < nLines; ++i) {
                if (i == nLines - 1) {
                    newFieldName.append(fieldName.substring(i * charsPerLine));
                    continue;
                }
                newFieldName.append(fieldName.substring(i * charsPerLine, (i + 1) * charsPerLine) + "-\n-");
            }
            fieldName = newFieldName.toString();
        }
        int numberSpace = fontMetrics.stringWidth(lowStr);
        if (fontMetrics.stringWidth(medLowStr) > numberSpace) {
            numberSpace = fontMetrics.stringWidth(medLowStr);
        }
        if (fontMetrics.stringWidth(medHighStr) > numberSpace) {
            numberSpace = fontMetrics.stringWidth(medHighStr);
        }
        if (fontMetrics.stringWidth(highStr) > numberSpace) {
            numberSpace = fontMetrics.stringWidth(highStr);
        }
        int sideSpace = numberSpace + lineHeight * nLines + 2 * textBorder;
        graphics.dispose();
        BufferedImage ret = new BufferedImage(sideSpace, componentSize, 2);
        graphics = ret.createGraphics();
        graphics.setColor(textColor);
        graphics.setFont(textFont);
        graphics.drawString(highStr, textBorder, highYPos);
        graphics.drawString(medHighStr, textBorder, medHighYPos);
        graphics.drawString(medLowStr, textBorder, medLowYPos);
        graphics.drawString(lowStr, textBorder, lowYPos);
        graphics.setFont(sidewaysFont);
        int offset = 0;
        for (String line : fieldName.split("\n")) {
            graphics.drawString(line, textBorder + numberSpace + lineHeight + offset, componentSize - textBorder);
            offset += lineHeight;
        }
        return ret;
    }

    @Override
    protected Set<Drawable.NameAndRange> getFieldsWithScales() {
        LinkedHashSet<Drawable.NameAndRange> ret = new LinkedHashSet<Drawable.NameAndRange>();
        for (Drawable drawable : this.layers) {
            if (drawable == null) continue;
            Set<Drawable.NameAndRange> fieldsWithScales = drawable.getFieldsWithScales();
            if (drawable.getOpacityTransform() != null) {
                fieldsWithScales.addAll(drawable.getOpacityTransform().getFieldsWithScales());
            }
            if (fieldsWithScales == null) continue;
            ret.addAll(fieldsWithScales);
        }
        if (this.getOpacityTransform() != null) {
            ret.addAll(this.getOpacityTransform().getFieldsWithScales());
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
        Image image = new Image();
        RasterLayer layer = new RasterLayer("colouredness", new PaletteColourScheme(new ColourScale(Float.valueOf(-5.0E-9f), Float.valueOf(5.0f), false), new ColourMap(Color.black, Color.black, new Color(0, true), "default", 250)));
        ArrowLayer layer2 = new ArrowLayer("pointiness", 10, Color.BLACK);
        StippleLayer layer3 = new StippleLayer("stippliness", new PatternScale(8, Float.valueOf(0.0f), Float.valueOf(1.0f), false));
        image.getLayers().add(layer);
        image.getLayers().add(layer2);
        image.getLayers().add(layer3);
        image.setOpacityTransform(new LinearOpacity("seethoughness", Float.valueOf(0.0f), Float.valueOf(1.0f)));
        ImageIO.write((RenderedImage)image.getLegend(200), "png", new File("/home/guy/legendtest.png"));
    }
}

