/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.graphics.ColourableIcon;
import uk.ac.rdg.resc.edal.graphics.style.DataReadingTypes;
import uk.ac.rdg.resc.edal.graphics.style.PlottingDatum;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ImageLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.PaletteColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ThresholdColourScheme;
import uk.ac.rdg.resc.edal.util.Extents;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="GlyphLayerType")
public abstract class GlyphLayer
extends ImageLayer {
    @XmlElement(name="DataFieldName", required=true)
    protected String dataFieldName;
    @XmlElement(name="GlyphIconName")
    protected String glyphIconName = "circle";
    @XmlElements(value={@XmlElement(name="PaletteColourScheme", type=PaletteColourScheme.class), @XmlElement(name="ThresholdColourScheme", type=ThresholdColourScheme.class)})
    protected ColourScheme colourScheme = new PaletteColourScheme();
    protected Map<String, ColourableIcon> icons;
    protected ColourableIcon icon;

    private GlyphLayer() throws InstantiationException {
        super(DataReadingTypes.PlotType.SUBSAMPLE);
        this.readInIcons();
    }

    public GlyphLayer(DataReadingTypes.PlotType plotType) throws InstantiationException {
        super(plotType);
        this.readInIcons();
    }

    public String getGlyphIconName() {
        return this.glyphIconName;
    }

    protected void readInIcons() throws InstantiationException {
        this.icons = new HashMap<String, ColourableIcon>();
        try {
            URL iconUrl = this.getClass().getResource("/img/circle.png");
            BufferedImage iconImage = ImageIO.read(iconUrl);
            this.icons.put("circle", new ColourableIcon(iconImage));
            iconUrl = this.getClass().getResource("/img/square.png");
            iconImage = ImageIO.read(iconUrl);
            this.icons.put("square", new ColourableIcon(iconImage));
        }
        catch (IOException e) {
            throw new InstantiationException("Cannot read required icons.  Ensure that JAR is packaged correctly, or that your project is set up correctly in your IDE");
        }
    }

    protected ColourableIcon getIcon(String name) {
        ColourableIcon ret = null;
        ret = name == null ? this.icons.get("circle") : this.icons.get(name.toLowerCase());
        if (ret != null) {
            return ret;
        }
        return this.icons.get("circle");
    }

    @Override
    protected void drawIntoImage(BufferedImage image, ImageLayer.DataReader dataReader) {
        List<PlottingDatum> plotData = dataReader.getDataForLayerName(this.dataFieldName);
        Graphics2D g = image.createGraphics();
        for (PlottingDatum datum : plotData) {
            Number value = datum.getValue();
            int i = datum.getGridCoords().getXIndex();
            int j = datum.getGridCoords().getYIndex();
            if (value == null || Float.isNaN(value.floatValue())) continue;
            Color color = this.colourScheme.getColor(value);
            g.drawImage((Image)this.icon.getColouredIcon(color), i - this.icon.getWidth() / 2, j - this.icon.getHeight() / 2, null);
        }
    }

    @Override
    protected Set<Drawable.NameAndRange> getFieldsWithScales() {
        HashSet<Drawable.NameAndRange> ret = new HashSet<Drawable.NameAndRange>();
        ret.add(new Drawable.NameAndRange(this, this.dataFieldName, (Extent<Float>)Extents.newExtent((Object)this.colourScheme.getScaleMin(), (Object)this.colourScheme.getScaleMax())));
        return ret;
    }
}

