/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import uk.ac.rdg.resc.edal.graphics.style.StyleXMLParser;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ImageLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.OpacityTransform;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="FlatOpacityType")
@XmlJavaTypeAdapter(value=StyleXMLParser.FlatOpacityAdapter.class)
public class FlatOpacity
extends OpacityTransform {
    @XmlElement(name="Opacity", required=true)
    private Float opacity = Float.valueOf(1.0f);

    private FlatOpacity() {
    }

    public FlatOpacity(Float opacity) {
        this.opacity = opacity;
    }

    @Override
    protected void applyOpacityToImage(BufferedImage image, ImageLayer.DataReader dataReader) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] imagePixels = image.getRGB(0, 0, width, height, null, 0, width);
        int alpha = (int)(this.opacity.floatValue() * 255.0f);
        for (int i = 0; i < imagePixels.length; ++i) {
            imagePixels[i] = this.blendPixel(imagePixels[i], alpha);
        }
        image.setRGB(0, 0, width, height, imagePixels, 0, width);
    }

    @Override
    protected Set<Drawable.NameAndRange> getFieldsWithScales() {
        return Collections.emptySet();
    }

    public Float getOpacity() {
        return this.opacity;
    }
}

