/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.graphics.style.DataReadingTypes;
import uk.ac.rdg.resc.edal.graphics.style.PlottingDatum;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ImageLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.PaletteColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ThresholdColourScheme;
import uk.ac.rdg.resc.edal.util.Extents;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="ConfidenceIntervalLayerType")
public class ConfidenceIntervalLayer
extends ImageLayer {
    @XmlElement(name="LowerFieldName", required=true)
    protected String lowerFieldName;
    @XmlElement(name="UpperFieldName", required=true)
    protected String upperFieldName;
    @XmlElement(name="GlyphSize")
    private Integer glyphSize = 9;
    @XmlElements(value={@XmlElement(name="PaletteColourScheme", type=PaletteColourScheme.class), @XmlElement(name="ThresholdColourScheme", type=ThresholdColourScheme.class)})
    protected ColourScheme colourScheme = new PaletteColourScheme();

    void afterUnmarshal(Unmarshaller u, Object parent) {
        this.setSampleSize();
    }

    public ConfidenceIntervalLayer() {
        super(DataReadingTypes.PlotType.SUBSAMPLE);
        this.setSampleSize();
    }

    public ConfidenceIntervalLayer(String lowerFieldName, String upperFieldName, int glyphSize, ColourScheme colourSceme) {
        super(DataReadingTypes.PlotType.SUBSAMPLE);
        this.lowerFieldName = lowerFieldName;
        this.upperFieldName = upperFieldName;
        this.glyphSize = glyphSize;
        this.colourScheme = colourSceme;
        this.setSampleSize();
    }

    private void setSampleSize() {
        if (this.glyphSize < 1 || this.glyphSize == null) {
            throw new IllegalArgumentException("Glyph size must be non-null and > 0");
        }
        this.setXSampleSize(this.glyphSize);
        this.setYSampleSize(this.glyphSize);
    }

    @Override
    protected void drawIntoImage(BufferedImage image, ImageLayer.DataReader dataReader) {
        Graphics2D g = image.createGraphics();
        List<PlottingDatum> lowerData = dataReader.getDataForLayerName(this.lowerFieldName);
        for (PlottingDatum datum : lowerData) {
            Number value = datum.getValue();
            int i = datum.getGridCoords().getXIndex();
            int j = datum.getGridCoords().getYIndex();
            if (value == null || Float.isNaN(value.floatValue())) continue;
            Color color = this.colourScheme.getColor(value);
            int[] xPoints = new int[]{i - this.glyphSize / 2, i + this.glyphSize / 2 - 1, i + this.glyphSize / 2 - 1};
            int[] yPoints = new int[]{j + this.glyphSize / 2 - 1, j + this.glyphSize / 2 - 1, j - this.glyphSize / 2};
            g.setColor(color);
            g.fillPolygon(xPoints, yPoints, 3);
        }
        List<PlottingDatum> upperData = dataReader.getDataForLayerName(this.upperFieldName);
        for (PlottingDatum datum : upperData) {
            Number value = datum.getValue();
            int i = datum.getGridCoords().getXIndex();
            int j = datum.getGridCoords().getYIndex();
            if (value == null || Float.isNaN(value.floatValue())) continue;
            Color color = this.colourScheme.getColor(value);
            int[] xPoints = new int[]{i - this.glyphSize / 2, i - this.glyphSize / 2, i + this.glyphSize / 2 - 1};
            int[] yPoints = new int[]{j + this.glyphSize / 2 - 1, j - this.glyphSize / 2, j - this.glyphSize / 2};
            g.setColor(color);
            g.fillPolygon(xPoints, yPoints, 3);
        }
    }

    @Override
    protected Set<Drawable.NameAndRange> getFieldsWithScales() {
        HashSet<Drawable.NameAndRange> ret = new HashSet<Drawable.NameAndRange>();
        ret.add(new Drawable.NameAndRange(this, this.lowerFieldName, (Extent<Float>)Extents.newExtent((Object)this.colourScheme.getScaleMin(), (Object)this.colourScheme.getScaleMax())));
        ret.add(new Drawable.NameAndRange(this, this.upperFieldName, (Extent<Float>)Extents.newExtent((Object)this.colourScheme.getScaleMin(), (Object)this.colourScheme.getScaleMax())));
        return ret;
    }
}

