/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(namespace="http://www.resc.reading.ac.uk", propOrder={}, name="ColourScaleType")
public class ColourScale {
    @XmlElement(required=true, name="ScaleMin")
    private Float scaleMin = Float.valueOf(-50.0f);
    @XmlElement(required=true, name="ScaleMax")
    private Float scaleMax = Float.valueOf(50.0f);
    @XmlElement(name="Logarithmic")
    private Boolean logarithmic = false;

    ColourScale() {
    }

    public ColourScale(Float scaleMin, Float scaleMax, Boolean logarithmic) {
        this.scaleMin = scaleMin;
        this.scaleMax = scaleMax;
        this.logarithmic = logarithmic;
    }

    public Float getScaleMin() {
        return this.scaleMin;
    }

    public Float getScaleMax() {
        return this.scaleMax;
    }

    public Boolean isLogarithmic() {
        return this.logarithmic;
    }

    public Float scaleZeroToOne(Number input) {
        if (input == null || Float.isNaN(input.floatValue())) {
            return null;
        }
        if (this.logarithmic.booleanValue()) {
            if ((double)this.scaleMin.floatValue() <= 0.0 || (double)this.scaleMax.floatValue() <= 0.0) {
                throw new IllegalArgumentException("Cannot log-scale zero/negative numbers");
            }
            if (input.floatValue() <= 0.0f) {
                return Float.valueOf(-1.0f);
            }
            return Float.valueOf((float)((Math.log(input.doubleValue()) - Math.log(this.scaleMin.floatValue())) / (Math.log(this.scaleMax.floatValue()) - Math.log(this.scaleMin.floatValue()))));
        }
        return Float.valueOf((input.floatValue() - this.scaleMin.floatValue()) / (this.scaleMax.floatValue() - this.scaleMin.floatValue()));
    }
}

