/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.Color;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import uk.ac.rdg.resc.edal.graphics.style.ColourPalette;
import uk.ac.rdg.resc.edal.graphics.style.StyleXMLParser;

@XmlType(namespace="http://www.resc.reading.ac.uk", name="ColourPaletteType")
public class ColourMap {
    @XmlElement(name="BelowMinColour")
    @XmlJavaTypeAdapter(value=StyleXMLParser.ColorAdapter.class)
    private Color belowMinColour = null;
    @XmlElement(name="AboveMaxColour")
    @XmlJavaTypeAdapter(value=StyleXMLParser.ColorAdapter.class)
    private Color aboveMaxColour = null;
    @XmlElement(name="MissingDataColour")
    @XmlJavaTypeAdapter(value=StyleXMLParser.ColorAdapter.class)
    private Color noDataColour = new Color(0, 0, 0, 0);
    @XmlElement(name="NumberOfColourBands")
    private Integer nColourBands = 254;
    @XmlElement(name="Palette")
    private String paletteString = "default";
    private ColourPalette palette = null;

    ColourMap() {
    }

    public ColourMap(Color belowMinColour, Color aboveMaxColour, Color noDataColour, String palette, Integer nColourBands) {
        this.belowMinColour = belowMinColour;
        this.aboveMaxColour = aboveMaxColour;
        this.noDataColour = noDataColour;
        this.nColourBands = nColourBands;
        this.paletteString = palette;
    }

    public Color getColor(Number value) {
        if (this.palette == null) {
            this.palette = ColourPalette.fromString(this.paletteString, this.nColourBands);
        }
        if (value == null || Float.isNaN(value.floatValue())) {
            return this.noDataColour;
        }
        float val = value.floatValue();
        if ((double)val < 0.0) {
            if (this.belowMinColour == null) {
                return this.palette.getColor(0.0f);
            }
            return this.belowMinColour;
        }
        if ((double)val > 1.0) {
            if (this.aboveMaxColour == null) {
                return this.palette.getColor(1.0f);
            }
            return this.aboveMaxColour;
        }
        return this.palette.getColor(val);
    }
}

