/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style.datamodel.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.graphics.style.DataReadingTypes;
import uk.ac.rdg.resc.edal.graphics.style.PlottingDatum;
import uk.ac.rdg.resc.edal.graphics.style.StyleXMLParser;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ImageLayer;
import uk.ac.rdg.resc.edal.util.Extents;

@XmlType(namespace="http://www.resc.reading.ac.uk", propOrder={"directionFieldName", "arrowSize", "arrowColour"}, name="ArrowLayerType")
public class ArrowLayer
extends ImageLayer {
    @XmlElement(name="DirectionFieldName", required=true)
    private String directionFieldName;
    @XmlElement(name="ArrowColour")
    @XmlJavaTypeAdapter(value=StyleXMLParser.ColorAdapter.class)
    private Color arrowColour = Color.black;
    private Integer arrowSize = 8;

    @XmlElement(name="ArrowSize")
    public void setArrowSize(Integer arrowSize) {
        this.arrowSize = arrowSize;
        if (arrowSize < 1 || arrowSize == null) {
            throw new IllegalArgumentException("Arrow size must be non-null and > 0");
        }
        this.setXSampleSize((int)((double)arrowSize.intValue() * 1.5));
        this.setYSampleSize((int)((double)arrowSize.intValue() * 1.5));
    }

    private ArrowLayer() {
        super(DataReadingTypes.PlotType.SUBSAMPLE);
    }

    public ArrowLayer(String directionFieldName, Integer arrowSize, Color arrowColour) {
        super(DataReadingTypes.PlotType.SUBSAMPLE);
        this.directionFieldName = directionFieldName;
        this.arrowColour = arrowColour;
        this.setArrowSize(arrowSize);
    }

    public String getDirectionFieldName() {
        return this.directionFieldName;
    }

    public Integer getArrowSize() {
        return this.arrowSize;
    }

    public Color getArrowColour() {
        return this.arrowColour;
    }

    @Override
    protected void drawIntoImage(BufferedImage image, ImageLayer.DataReader dataReader) {
        List<PlottingDatum> plotData = dataReader.getDataForLayerName(this.directionFieldName);
        Graphics2D g = image.createGraphics();
        g.setColor(this.arrowColour);
        for (PlottingDatum datum : plotData) {
            Number angle = datum.getValue();
            int i = datum.getGridCoords().getXIndex();
            int j = datum.getGridCoords().getYIndex();
            if (angle == null || Float.isNaN(angle.floatValue())) continue;
            double iEnd = (double)i + (double)this.arrowSize.intValue() * Math.cos(angle.doubleValue());
            double jEnd = (double)j - (double)this.arrowSize.intValue() * Math.sin(angle.doubleValue());
            g.fillOval(i - 2, j - 2, 4, 4);
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(i, j, (int)Math.round(iEnd), (int)Math.round(jEnd));
        }
    }

    @Override
    protected Set<Drawable.NameAndRange> getFieldsWithScales() {
        HashSet<Drawable.NameAndRange> ret = new HashSet<Drawable.NameAndRange>();
        ret.add(new Drawable.NameAndRange(this, this.directionFieldName, (Extent<Float>)Extents.newExtent((Object)Float.valueOf(0.0f), (Object)new Float(Math.PI * 2))));
        return ret;
    }
}

