/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourMap;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScale;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.FlatOpacity;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Image;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.PaletteColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.RasterLayer;

public class StyleXMLParser {
    public static String serialise(Image image) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Image.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)image, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static Image deserialise(String xmlString) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Image.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Image image = (Image)unmarshaller.unmarshal((Reader)new StringReader(xmlString));
        return image;
    }

    public static void generateSchema(final String path) throws IOException, JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Image.class});
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                System.out.println(namespaceUri + ", " + suggestedFileName);
                return new StreamResult(new File(path, suggestedFileName));
            }
        });
    }

    public static void main(String[] args) throws JAXBException, IOException {
        Image image = new Image();
        ColourScale scaleRange = new ColourScale(Float.valueOf(270.0f), Float.valueOf(302.0f), false);
        ColourMap colourPalette = new ColourMap(Color.green, Color.cyan, new Color(0, 0, 0, 0), "rainbow", 20);
        PaletteColourScheme colourScheme = new PaletteColourScheme(scaleRange, colourPalette);
        RasterLayer rasterLayer = new RasterLayer("TMP", colourScheme);
        rasterLayer.setOpacityTransform(new FlatOpacity(Float.valueOf(0.5f)));
        image.getLayers().add(rasterLayer);
        System.out.println(StyleXMLParser.serialise(image));
    }

    public static class FlatOpacityAdapter
    extends XmlAdapter<String, FlatOpacity> {
        public FlatOpacity unmarshal(String v) throws Exception {
            return new FlatOpacity(Float.valueOf(Float.parseFloat(v)));
        }

        public String marshal(FlatOpacity v) throws Exception {
            return v.getOpacity().toString();
        }
    }

    public static class ColorAdapter
    extends XmlAdapter<String, Color> {
        public Color unmarshal(String s) {
            if (s.length() == 7) {
                return Color.decode(s);
            }
            if (s.length() == 9) {
                Color color = Color.decode("#" + s.substring(3));
                int alpha = Integer.parseInt(s.substring(1, 3), 16);
                return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
            }
            return null;
        }

        public String marshal(Color c) {
            return "#" + String.format("%08X", c.getRGB());
        }
    }
}

