/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.coverage.GridCoverage2D;
import uk.ac.rdg.resc.edal.coverage.domain.GridDomain;
import uk.ac.rdg.resc.edal.coverage.grid.GridAxis;
import uk.ac.rdg.resc.edal.coverage.grid.GridValuesMatrix;
import uk.ac.rdg.resc.edal.coverage.grid.HorizontalGrid;
import uk.ac.rdg.resc.edal.coverage.grid.RegularAxis;
import uk.ac.rdg.resc.edal.coverage.grid.impl.InMemoryGridValuesMatrix;
import uk.ac.rdg.resc.edal.coverage.grid.impl.RegularAxisImpl;
import uk.ac.rdg.resc.edal.coverage.grid.impl.RegularGridImpl;
import uk.ac.rdg.resc.edal.coverage.impl.DataReadingStrategy;
import uk.ac.rdg.resc.edal.coverage.impl.GridCoverage2DImpl;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.FeatureCollection;
import uk.ac.rdg.resc.edal.feature.GridFeature;
import uk.ac.rdg.resc.edal.feature.impl.FeatureCollectionImpl;
import uk.ac.rdg.resc.edal.feature.impl.GridFeatureImpl;
import uk.ac.rdg.resc.edal.graphics.style.FeatureCollectionAndMemberName;
import uk.ac.rdg.resc.edal.graphics.style.GlobalPlottingParams;
import uk.ac.rdg.resc.edal.graphics.style.Id2FeatureAndMember;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Drawable;
import uk.ac.rdg.resc.edal.util.Extents;

public class LegendDataGenerator
extends FeatureCollectionImpl<GridFeature> {
    private RegularAxisImpl xAxis;
    private RegularAxisImpl yAxis;
    private RegularGridImpl domain;
    private Set<Drawable.NameAndRange> dataFields;
    private boolean[][] missingBits;
    private float fractionExtra;

    public LegendDataGenerator(Set<Drawable.NameAndRange> dataFields, int width, int height, BufferedImage backgroundMask, float fractionExtra) {
        super("", "");
        this.xAxis = new RegularAxisImpl("", 0.0, 0.001, width, false);
        this.yAxis = new RegularAxisImpl("", 0.0, 0.001, height, false);
        this.domain = new RegularGridImpl((RegularAxis)this.xAxis, (RegularAxis)this.yAxis, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.dataFields = dataFields;
        this.fractionExtra = fractionExtra;
        this.missingBits = new boolean[width][height];
        if (backgroundMask != null) {
            Image scaledInstance = backgroundMask.getScaledInstance(width, height, 2);
            BufferedImage bufferedImage = new BufferedImage(width, height, 10);
            bufferedImage.createGraphics().drawImage(scaledInstance, 0, 0, null);
            byte[] data = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    this.missingBits[i][j] = data[i + width * (height - 1 - j)] == 0;
                }
            }
        }
    }

    public GlobalPlottingParams getGlobalParams() {
        return new GlobalPlottingParams(this.xAxis.size(), this.yAxis.size(), this.domain.getCoordinateExtent(), null, null, null, null);
    }

    public Id2FeatureAndMember getId2FeatureAndMember(String xFieldName, String yFieldName) {
        final FeatureCollection<GridFeature> featureCollection = this.getFeatureCollection(xFieldName, yFieldName);
        return new Id2FeatureAndMember(){

            @Override
            public FeatureCollectionAndMemberName getFeatureAndMemberName(String id) {
                return new FeatureCollectionAndMemberName((FeatureCollection<? extends Feature>)featureCollection, id);
            }
        };
    }

    private FeatureCollection<GridFeature> getFeatureCollection(String xFieldName, String yFieldName) {
        ArrayList<Drawable.NameAndRange> dataRangesList = new ArrayList<Drawable.NameAndRange>(this.dataFields);
        HashMap<String, XYOrNullGridValuesMatrix> gvms = new HashMap<String, XYOrNullGridValuesMatrix>();
        for (Drawable.NameAndRange nameAndRange : dataRangesList) {
            if (nameAndRange == null) continue;
            XYOrNullGridValuesMatrix gridValuesMatrix = nameAndRange.getFieldLabel().equals(xFieldName) ? new XYOrNullGridValuesMatrix(MatrixType.X, nameAndRange.getScaleRange()) : (nameAndRange.getFieldLabel().equals(yFieldName) ? new XYOrNullGridValuesMatrix(MatrixType.Y, nameAndRange.getScaleRange()) : new XYOrNullGridValuesMatrix(MatrixType.NAN, null));
            gvms.put(nameAndRange.getFieldLabel(), gridValuesMatrix);
        }
        LegendFeatureCollection legendFeatureCollection = new LegendFeatureCollection(gvms);
        return legendFeatureCollection;
    }

    private class XYOrNullGridValuesMatrix
    extends InMemoryGridValuesMatrix<Float> {
        private MatrixType type;
        private Extent<Float> scaleRange = null;

        public XYOrNullGridValuesMatrix(MatrixType type, Extent<Float> scaleRange) {
            this.type = type;
            if (scaleRange != null) {
                Float width = Float.valueOf(((Float)scaleRange.getHigh()).floatValue() - ((Float)scaleRange.getLow()).floatValue());
                this.scaleRange = Extents.newExtent((Object)Float.valueOf(((Float)scaleRange.getLow()).floatValue() - width.floatValue() * LegendDataGenerator.this.fractionExtra), (Object)Float.valueOf(((Float)scaleRange.getHigh()).floatValue() + width.floatValue() * LegendDataGenerator.this.fractionExtra));
            }
        }

        public Class<Float> getValueType() {
            return Float.class;
        }

        public int getNDim() {
            return 2;
        }

        protected GridAxis doGetAxis(int n) {
            if (n == 0) {
                return LegendDataGenerator.this.xAxis;
            }
            if (n == 1) {
                return LegendDataGenerator.this.yAxis;
            }
            throw new IllegalArgumentException("Only 2 dimensions in this GridValuesMatrix");
        }

        protected Float doReadPoint(int[] coords) {
            if (LegendDataGenerator.this.missingBits[coords[0]][coords[1]]) {
                return Float.valueOf(Float.NaN);
            }
            switch (this.type) {
                case X: {
                    return Float.valueOf(((Float)this.scaleRange.getLow()).floatValue() + (float)coords[0] * (((Float)this.scaleRange.getHigh()).floatValue() - ((Float)this.scaleRange.getLow()).floatValue()) / (float)LegendDataGenerator.this.xAxis.size());
                }
                case Y: {
                    return Float.valueOf(((Float)this.scaleRange.getLow()).floatValue() + (float)coords[1] * (((Float)this.scaleRange.getHigh()).floatValue() - ((Float)this.scaleRange.getLow()).floatValue()) / (float)LegendDataGenerator.this.yAxis.size());
                }
            }
            return Float.valueOf(Float.NaN);
        }
    }

    private static enum MatrixType {
        X,
        Y,
        NAN;

    }

    private class LegendFeatureCollection
    extends FeatureCollectionImpl<GridFeature> {
        private LegendFeatureCollection(Map<String, GridValuesMatrix<Float>> members) {
            super("", "");
            GridCoverage2DImpl coverage = new GridCoverage2DImpl("", (HorizontalGrid)LegendDataGenerator.this.domain, DataReadingStrategy.PIXEL_BY_PIXEL);
            for (Map.Entry<String, GridValuesMatrix<Float>> entry : members.entrySet()) {
                coverage.addMember(entry.getKey(), (GridDomain)LegendDataGenerator.this.domain, "", null, null, entry.getValue());
                GridFeatureImpl f = new GridFeatureImpl(entry.getKey(), entry.getKey(), null, (GridCoverage2D)coverage);
                this.addFeature((Feature)f);
            }
        }
    }
}

