/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import uk.ac.rdg.resc.edal.graphics.ColorPalette;
import uk.ac.rdg.resc.edal.graphics.style.StyleXMLParser;

public class ColourPalette {
    public static final String DEFAULT_PALETTE_NAME = "rainbow";
    public static final int MAX_NUM_COLOURS = 254;
    private static final Color[] DEFAULT_COLOURS = new Color[]{new Color(0, 0, 143), new Color(0, 0, 159), new Color(0, 0, 175), new Color(0, 0, 191), new Color(0, 0, 207), new Color(0, 0, 223), new Color(0, 0, 239), new Color(0, 0, 255), new Color(0, 11, 255), new Color(0, 27, 255), new Color(0, 43, 255), new Color(0, 59, 255), new Color(0, 75, 255), new Color(0, 91, 255), new Color(0, 107, 255), new Color(0, 123, 255), new Color(0, 139, 255), new Color(0, 155, 255), new Color(0, 171, 255), new Color(0, 187, 255), new Color(0, 203, 255), new Color(0, 219, 255), new Color(0, 235, 255), new Color(0, 251, 255), new Color(7, 255, 247), new Color(23, 255, 231), new Color(39, 255, 215), new Color(55, 255, 199), new Color(71, 255, 183), new Color(87, 255, 167), new Color(103, 255, 151), new Color(119, 255, 135), new Color(135, 255, 119), new Color(151, 255, 103), new Color(167, 255, 87), new Color(183, 255, 71), new Color(199, 255, 55), new Color(215, 255, 39), new Color(231, 255, 23), new Color(247, 255, 7), new Color(255, 247, 0), new Color(255, 231, 0), new Color(255, 215, 0), new Color(255, 199, 0), new Color(255, 183, 0), new Color(255, 167, 0), new Color(255, 151, 0), new Color(255, 135, 0), new Color(255, 119, 0), new Color(255, 103, 0), new Color(255, 87, 0), new Color(255, 71, 0), new Color(255, 55, 0), new Color(255, 39, 0), new Color(255, 23, 0), new Color(255, 7, 0), new Color(246, 0, 0), new Color(228, 0, 0), new Color(211, 0, 0), new Color(193, 0, 0), new Color(175, 0, 0), new Color(158, 0, 0), new Color(140, 0, 0)};
    private static Map<String, Color[]> loadedColourSets = new HashMap<String, Color[]>();
    private static StyleXMLParser.ColorAdapter cParser;
    private final Color[] colours;

    private ColourPalette(Color[] palette, int numColorBands) {
        this.colours = ColourPalette.generateColourSet(palette, numColorBands);
    }

    private static Color[] generateColourSet(Color[] palette, int numColorBands) {
        Color[] targetPalette;
        if (numColorBands < 1 || numColorBands > 254) {
            throw new IllegalArgumentException("numColorBands must be greater than 1 and less than 254");
        }
        if (numColorBands == palette.length) {
            targetPalette = palette;
        } else {
            targetPalette = new Color[numColorBands];
            targetPalette[0] = palette[0];
            targetPalette[targetPalette.length - 1] = palette[palette.length - 1];
            if (targetPalette.length < palette.length) {
                for (int i = 1; i < targetPalette.length - 1; ++i) {
                    int nearestIndex = Math.round((float)(palette.length * i) * 1.0f / (float)(targetPalette.length - 1));
                    targetPalette[i] = palette[nearestIndex];
                }
            } else {
                int lastIndex = 0;
                for (int i = 1; i < palette.length - 1; ++i) {
                    int nearestIndex = Math.round((float)(targetPalette.length * i) * 1.0f / (float)(palette.length - 1));
                    targetPalette[nearestIndex] = palette[i];
                    for (int j = lastIndex + 1; j < nearestIndex; ++j) {
                        float fracFromThis = (1.0f * (float)j - (float)lastIndex) / (float)(nearestIndex - lastIndex);
                        targetPalette[j] = ColourPalette.interpolate(targetPalette[nearestIndex], targetPalette[lastIndex], fracFromThis);
                    }
                    lastIndex = nearestIndex;
                }
                for (int j = lastIndex + 1; j < targetPalette.length - 1; ++j) {
                    float fracFromThis = (1.0f * (float)j - (float)lastIndex) / (float)(targetPalette.length - lastIndex);
                    targetPalette[j] = ColourPalette.interpolate(targetPalette[targetPalette.length - 1], targetPalette[lastIndex], fracFromThis);
                }
            }
        }
        return targetPalette;
    }

    private static Color interpolate(Color c1, Color c2, float fracFromC1) {
        float fracFromC2 = 1.0f - fracFromC1;
        return new Color(Math.round(fracFromC1 * (float)c1.getRed() + fracFromC2 * (float)c2.getRed()), Math.round(fracFromC1 * (float)c1.getGreen() + fracFromC2 * (float)c2.getGreen()), Math.round(fracFromC1 * (float)c1.getBlue() + fracFromC2 * (float)c2.getBlue()), Math.round(fracFromC1 * (float)c1.getAlpha() + fracFromC2 * (float)c2.getAlpha()));
    }

    public Color getColor(float value) {
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("value must be between 0 and 1");
        }
        int i = (int)(value * (float)this.colours.length);
        if (i == this.colours.length) {
            --i;
        }
        return this.colours[i];
    }

    public static ColourPalette fromString(String paletteString, int nColourBands) {
        if (loadedColourSets.containsKey(paletteString.toLowerCase())) {
            return new ColourPalette(loadedColourSets.get(paletteString), nColourBands);
        }
        try {
            Color[] colours = ColourPalette.colourSetFromString(paletteString);
            return new ColourPalette(colours, nColourBands);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(paletteString + " is not an exisiting palette name or a palette definition");
        }
    }

    private static Color[] colourSetFromString(String paletteString) {
        String[] colourStrings = paletteString.split("[,\n]");
        Color[] colours = new Color[colourStrings.length];
        for (int i = 0; i < colourStrings.length; ++i) {
            try {
                colours[i] = cParser.unmarshal(colourStrings[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return colours;
    }

    private static String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                String entry = name.substring(path.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    static {
        loadedColourSets = new HashMap<String, Color[]>();
        cParser = new StyleXMLParser.ColorAdapter();
        loadedColourSets.put(DEFAULT_PALETTE_NAME.toLowerCase(), DEFAULT_COLOURS);
        loadedColourSets.put("default", DEFAULT_COLOURS);
        try {
            String[] paletteFileNames;
            for (String paletteFileName : paletteFileNames = ColourPalette.getResourceListing(ColorPalette.class, "palettes/")) {
                if (!paletteFileName.endsWith(".pal")) continue;
                try {
                    String paletteName = paletteFileName.substring(0, paletteFileName.lastIndexOf("."));
                    StringBuilder paletteString = new StringBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(ColorPalette.class.getResource("/palettes/" + paletteFileName).openStream()));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("%")) continue;
                        paletteString.append(line);
                        paletteString.append(",");
                    }
                    paletteString.deleteCharAt(paletteString.length() - 1);
                    Color[] colourSet = ColourPalette.colourSetFromString(paletteString.toString());
                    loadedColourSets.put(paletteName, colourSet);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

