/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.style;

import java.util.List;

public class BilinearInterpolator {
    private List<Double> xVals;
    private List<Double> yVals;
    private double[][] data;
    private double[] xRanges;
    private double[] yRanges;

    public BilinearInterpolator(List<Double> xVals, List<Double> yVals, double[][] data) {
        int i;
        this.xVals = xVals;
        this.yVals = yVals;
        this.data = data;
        this.xRanges = new double[xVals.size()];
        this.yRanges = new double[yVals.size()];
        for (i = 1; i < xVals.size(); ++i) {
            this.xRanges[i] = xVals.get(i) - xVals.get(i - 1);
        }
        for (i = 1; i < yVals.size(); ++i) {
            this.yRanges[i] = yVals.get(i) - yVals.get(i - 1);
        }
    }

    public double getValue(double x, double y) {
        double yFAlong;
        double xFAlong;
        int xIndex;
        int yIndex = 0;
        for (xIndex = 0; this.xVals.get(xIndex) <= x && xIndex < this.xVals.size() - 1; ++xIndex) {
        }
        while (this.yVals.get(yIndex) <= y && yIndex < this.yVals.size() - 1) {
            ++yIndex;
        }
        if (xIndex == 0) {
            ++xIndex;
            xFAlong = 1.0;
        } else {
            xFAlong = (x - this.xVals.get(xIndex - 1)) / this.xRanges[xIndex];
        }
        if (yIndex == 0) {
            ++yIndex;
            yFAlong = 1.0;
        } else {
            yFAlong = (y - this.yVals.get(yIndex - 1)) / this.yRanges[yIndex];
        }
        return xFAlong * yFAlong * this.data[xIndex][yIndex] + xFAlong * (1.0 - yFAlong) * this.data[xIndex][yIndex - 1] + (1.0 - xFAlong) * yFAlong * this.data[xIndex - 1][yIndex] + (1.0 - xFAlong) * (1.0 - yFAlong) * this.data[xIndex - 1][yIndex - 1];
    }
}

