/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.formats;

import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import uk.ac.rdg.resc.edal.graphics.formats.PngFormat;

public class Png32Format
extends PngFormat {
    protected Png32Format() {
    }

    @Override
    public String getMimeType() {
        return "image/png;mode=32bit";
    }

    @Override
    public void writeImage(List<BufferedImage> frames, OutputStream out, Integer frameRate) throws IOException {
        ArrayList<BufferedImage> frames32bit = new ArrayList<BufferedImage>(frames.size());
        for (BufferedImage source : frames) {
            frames32bit.add(Png32Format.convertARGB(source));
        }
        super.writeImage(frames32bit, out, frameRate);
    }

    private static BufferedImage convertARGB(BufferedImage source) {
        BufferedImage dest = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        ColorConvertOp convertOp = new ColorConvertOp(source.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        convertOp.filter(source, dest);
        return dest;
    }
}

