/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import uk.ac.rdg.resc.edal.graphics.exceptions.InvalidFormatException;
import uk.ac.rdg.resc.edal.graphics.formats.GifFormat;
import uk.ac.rdg.resc.edal.graphics.formats.JpegFormat;
import uk.ac.rdg.resc.edal.graphics.formats.KmzFormat;
import uk.ac.rdg.resc.edal.graphics.formats.Png32Format;
import uk.ac.rdg.resc.edal.graphics.formats.PngFormat;

public abstract class ImageFormat {
    private static final Map<String, ImageFormat> formats = new LinkedHashMap<String, ImageFormat>();

    public static Set<String> getSupportedMimeTypes() {
        return formats.keySet();
    }

    public static ImageFormat get(String mimeType) throws InvalidFormatException {
        ImageFormat format = formats.get(mimeType);
        if (format == null) {
            throw new InvalidFormatException("The image format " + mimeType + " is not supported by this server");
        }
        return format;
    }

    public abstract String getMimeType();

    public abstract boolean supportsMultipleFrames();

    public abstract boolean supportsFullyTransparentPixels();

    public abstract boolean supportsPartiallyTransparentPixels();

    public abstract boolean requiresLegend();

    public abstract void writeImage(List<BufferedImage> var1, OutputStream var2, String var3, String var4, double[] var5, List<String> var6, String var7, BufferedImage var8, Integer var9) throws IOException;

    static {
        ImageIO.setUseCache(false);
        for (ImageFormat format : new ImageFormat[]{new PngFormat(), new Png32Format(), new GifFormat(), new JpegFormat(), new KmzFormat()}) {
            formats.put(format.getMimeType(), format);
        }
    }
}

