/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.formats;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import uk.ac.rdg.resc.edal.graphics.formats.AnimatedGifEncoder;
import uk.ac.rdg.resc.edal.graphics.formats.SimpleFormat;

public class GifFormat
extends SimpleFormat {
    protected GifFormat() {
    }

    @Override
    public void writeImage(List<BufferedImage> frames, OutputStream out, Integer frameRate) throws IOException {
        AnimatedGifEncoder e = new AnimatedGifEncoder();
        e.start(out);
        if (frames.size() > 1) {
            e.setRepeat(0);
            if (frameRate != null) {
                e.setDelay(1000 / frameRate);
            } else {
                e.setDelay(150);
            }
        }
        boolean sizeSet = false;
        IndexColorModel icm = GifFormat.getGeneralIndexedColorModelWithTransparency();
        byte[] rgbPalette = GifFormat.getRGBPalette(icm);
        for (BufferedImage frame : frames) {
            BufferedImage gifFrame = new BufferedImage(frame.getWidth(), frame.getHeight(), 13, icm);
            gifFrame.createGraphics().drawImage((Image)frame, 0, 0, null);
            if (!sizeSet) {
                e.setSize(frame.getWidth(), frame.getHeight());
                sizeSet = true;
            }
            byte[] indices = ((DataBufferByte)gifFrame.getRaster().getDataBuffer()).getData();
            e.addFrame(rgbPalette, indices, icm.getTransparentPixel());
        }
        e.finish();
    }

    private static IndexColorModel getGeneralIndexedColorModelWithTransparency() {
        int[] cmap = new int[256];
        int i = 0;
        cmap[i++] = 0xFFFFFF;
        for (int r = 0; r < 256; r += 51) {
            for (int g = 0; g < 256; g += 51) {
                for (int b = 0; b < 256; b += 51) {
                    cmap[i++] = r << 16 | g << 8 | b;
                }
            }
        }
        int grayIncr = 256 / (256 - i);
        int gray = grayIncr * 3;
        while (i < 255) {
            cmap[i] = gray << 16 | gray << 8 | gray;
            gray += grayIncr;
            ++i;
        }
        IndexColorModel colorModel = new IndexColorModel(8, 256, cmap, 0, true, 0, 0);
        return colorModel;
    }

    private static byte[] getRGBPalette(IndexColorModel icm) {
        byte[] reds = new byte[icm.getMapSize()];
        byte[] greens = new byte[icm.getMapSize()];
        byte[] blues = new byte[icm.getMapSize()];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        byte[] palette = new byte[768];
        for (int i = 0; i < icm.getMapSize(); ++i) {
            palette[i * 3] = reds[i];
            palette[i * 3 + 1] = greens[i];
            palette[i * 3 + 2] = blues[i];
        }
        return palette;
    }

    @Override
    public String getMimeType() {
        return "image/gif";
    }

    @Override
    public boolean supportsMultipleFrames() {
        return true;
    }

    @Override
    public boolean supportsFullyTransparentPixels() {
        return true;
    }

    @Override
    public boolean supportsPartiallyTransparentPixels() {
        return false;
    }
}

