/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.avi.AVIWriter;
import org.monte.media.math.Rational;
import uk.ac.rdg.resc.edal.graphics.formats.SimpleFormat;

public class AviFormat
extends SimpleFormat {
    @Override
    public void writeImage(List<BufferedImage> frames, OutputStream out, Integer frameRate) throws IOException {
        if (frames == null || frames.size() == 0) {
            throw new IllegalArgumentException("Cannot create an animation with no images");
        }
        try {
            int width = frames.get(0).getWidth();
            int height = frames.get(0).getHeight();
            Format format = new Format(new Object[]{VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.FrameRateKey, new Rational((long)frameRate.intValue()), VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height});
            AVIWriter writer = new AVIWriter((ImageOutputStream)new MemoryCacheImageOutputStream(out));
            writer.addTrack(format);
            writer.setPalette(0, frames.get(0).getColorModel());
            for (BufferedImage frame : frames) {
                writer.write(0, frame, 1L);
            }
            writer.write(0, frames.get(frames.size() - 1), 1L);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMimeType() {
        return "video/avi";
    }

    @Override
    public boolean supportsMultipleFrames() {
        return true;
    }

    @Override
    public boolean supportsFullyTransparentPixels() {
        return true;
    }

    @Override
    public boolean supportsPartiallyTransparentPixels() {
        return true;
    }
}

