/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics;

import java.util.ArrayList;
import java.util.List;
import uk.ac.rdg.resc.edal.coverage.metadata.ScalarMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.VectorComponent;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.GridFeature;
import uk.ac.rdg.resc.edal.feature.GridSeriesFeature;
import uk.ac.rdg.resc.edal.feature.PointSeriesFeature;
import uk.ac.rdg.resc.edal.feature.ProfileFeature;
import uk.ac.rdg.resc.edal.feature.TrajectoryFeature;

public enum PlotStyle {
    BOXFILL{

        @Override
        public boolean usesPalette() {
            return true;
        }
    }
    ,
    VECTOR{

        @Override
        public boolean usesPalette() {
            return false;
        }
    }
    ,
    POINT{

        @Override
        public boolean usesPalette() {
            return true;
        }
    }
    ,
    TRAJECTORY{

        @Override
        public boolean usesPalette() {
            return true;
        }
    }
    ,
    CONTOUR{

        @Override
        public boolean usesPalette() {
            return false;
        }
    }
    ,
    STIPPLE{

        @Override
        public boolean usesPalette() {
            return false;
        }
    }
    ,
    GRIDPOINT{

        @Override
        public boolean usesPalette() {
            return false;
        }
    }
    ,
    DEFAULT_CONTOUR{

        @Override
        public boolean usesPalette() {
            return true;
        }
    }
    ,
    DEFAULT_CONTOUR_SMOOTH{

        @Override
        public boolean usesPalette() {
            return true;
        }
    }
    ,
    DEFAULT_STIPPLE{

        @Override
        public boolean usesPalette() {
            return true;
        }
    }
    ,
    DEFAULT_CONFIDENCE{

        @Override
        public boolean usesPalette() {
            return true;
        }
    }
    ,
    DEFAULT_FADE_BLACK{

        @Override
        public boolean usesPalette() {
            return true;
        }
    }
    ,
    DEFAULT_FADE_WHITE{

        @Override
        public boolean usesPalette() {
            return true;
        }
    }
    ,
    DEFAULT{

        @Override
        public boolean usesPalette() {
            return true;
        }
    };


    public abstract boolean usesPalette();

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static List<PlotStyle> getAllowedPlotStyles(Feature feature, ScalarMetadata metadata) {
        ArrayList<PlotStyle> allowedPlotStyles = new ArrayList<PlotStyle>();
        boolean numerical = Number.class.isAssignableFrom(metadata.getValueType());
        if (numerical) {
            if (metadata instanceof VectorComponent && ((VectorComponent)metadata).getComponentType() == VectorComponent.VectorComponentType.DIRECTION) {
                allowedPlotStyles.add(VECTOR);
            } else if (feature instanceof GridSeriesFeature || feature instanceof GridFeature) {
                allowedPlotStyles.add(BOXFILL);
                allowedPlotStyles.add(CONTOUR);
                allowedPlotStyles.add(STIPPLE);
            } else if (feature instanceof TrajectoryFeature) {
                allowedPlotStyles.add(TRAJECTORY);
            }
        }
        return allowedPlotStyles;
    }

    public static PlotStyle getDefaultPlotStyle(Feature feature, ScalarMetadata metadata) {
        if (feature instanceof PointSeriesFeature || feature instanceof ProfileFeature) {
            return POINT;
        }
        if (feature instanceof TrajectoryFeature) {
            return TRAJECTORY;
        }
        if (!Number.class.isAssignableFrom(metadata.getValueType())) {
            return GRIDPOINT;
        }
        if (metadata instanceof VectorComponent && ((VectorComponent)metadata).getComponentType() == VectorComponent.VectorComponentType.DIRECTION) {
            return VECTOR;
        }
        if (feature instanceof GridFeature || feature instanceof GridSeriesFeature) {
            return BOXFILL;
        }
        return GRIDPOINT;
    }
}

