/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics;

import java.util.List;
import uk.ac.rdg.resc.edal.coverage.grid.GridCoordinates2D;
import uk.ac.rdg.resc.edal.graphics.FrameData;
import uk.ac.rdg.resc.edal.graphics.PlotStyle;
import uk.ac.rdg.resc.edal.graphics.PointFrameData;

public class MultiPointFrameData
extends FrameData {
    private List<GridCoordinates2D> coords;
    private List<Number> values;
    private int size;

    public MultiPointFrameData(PlotStyle plotStyle, List<GridCoordinates2D> coords, List<Number> values) {
        super(plotStyle);
        if (values.size() != coords.size()) {
            throw new IllegalArgumentException("Values and coords must be the same size");
        }
        this.coords = coords;
        this.values = values;
        this.size = values.size();
    }

    public int size() {
        return this.size;
    }

    public PointFrameData getPointData(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Number n = this.values.get(i);
        return new PointFrameData(this.getPlotStyle(), this.coords.get(i).getXIndex(), this.coords.get(i).getYIndex(), n != null ? (Number)n : (Number)Float.valueOf(Float.NaN));
    }
}

