/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.graphics.ColorPalette;
import uk.ac.rdg.resc.edal.graphics.ColourableIcon;
import uk.ac.rdg.resc.edal.util.Extents;

public class MapStyleDescriptor {
    private ColorPalette colorPalette = ColorPalette.get(null);
    private Extent<Float> scaleRange = Extents.emptyExtent(Float.class);
    private boolean transparent = true;
    private int opacity = 100;
    private int numColourBands = 254;
    private boolean logarithmic = false;
    private Color bgColor = Color.black;
    private Map<String, ColourableIcon> icons = new HashMap<String, ColourableIcon>();
    private float arrowLength = 6.0f;
    private int numberOfContours = 10;
    private IndexColorModel indexColorModel = null;

    public MapStyleDescriptor() throws InstantiationException {
        try {
            URL iconUrl = this.getClass().getResource("/img/circle.png");
            BufferedImage iconImage = ImageIO.read(iconUrl);
            this.icons.put("circle", new ColourableIcon(iconImage));
            iconUrl = this.getClass().getResource("/img/square.png");
            iconImage = ImageIO.read(iconUrl);
            this.icons.put("square", new ColourableIcon(iconImage));
        }
        catch (IOException e) {
            throw new InstantiationException("Cannot read required icons.  Ensure that JAR is packaged correctly, or that your project is set up correctly in your IDE");
        }
    }

    public void setColorPalette(String colorPaletteName) {
        ColorPalette pal = ColorPalette.get(colorPaletteName);
        if (pal == null) {
            throw new IllegalArgumentException("The palette " + colorPaletteName + " does not exist");
        }
        this.colorPalette = pal;
    }

    public void setScaleRange(Extent<Float> scaleRange) {
        this.scaleRange = scaleRange;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public void setNumColourBands(int numColourBands) {
        this.numColourBands = numColourBands;
    }

    public void setLogarithmic(boolean logarithmic) {
        this.logarithmic = logarithmic;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setArrowLength(float arrowLength) {
        this.arrowLength = arrowLength;
    }

    public void setNumberOfContour(int numberOfContours) {
        this.numberOfContours = numberOfContours;
    }

    public void addIcon(String name, ColourableIcon pointIcon) {
        this.icons.put(name, pointIcon);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public float getArrowLength() {
        return this.arrowLength;
    }

    public Color getColorForValue(Number value) {
        if (value == null) {
            return Color.white;
        }
        return new Color(this.getColorModel().getRGB(this.getColourIndex(value)));
    }

    public ColourableIcon getIcon() {
        return this.getIcon("circle");
    }

    public ColourableIcon getIcon(String name) {
        ColourableIcon ret = null;
        ret = name == null ? this.icons.get("circle") : this.icons.get(name.toLowerCase());
        if (ret != null) {
            return ret;
        }
        return this.icons.get("circle");
    }

    public int getColourIndex(Number value) {
        double max;
        double min;
        if (value == null || Float.isNaN(value.floatValue())) {
            return this.numColourBands;
        }
        if (!this.scaleRange.contains((Object)Float.valueOf(value.floatValue()))) {
            return this.numColourBands + 1;
        }
        float scaleMin = ((Float)this.scaleRange.getLow()).floatValue();
        float scaleMax = ((Float)this.scaleRange.getHigh()).floatValue();
        double val = this.logarithmic ? Math.log(value.doubleValue()) : value.doubleValue();
        double frac = (val - (min = this.logarithmic ? Math.log(scaleMin) : (double)scaleMin)) / ((max = this.logarithmic ? Math.log(scaleMax) : (double)scaleMax) - min);
        int index = (int)(frac * (double)this.numColourBands);
        if (index == this.numColourBands) {
            --index;
        }
        return index;
    }

    public Extent<Float> getScaleRange() {
        return this.scaleRange;
    }

    public boolean isAutoScale() {
        return this.scaleRange == null || this.scaleRange.isEmpty();
    }

    public IndexColorModel getColorModel() {
        if (this.indexColorModel == null) {
            this.indexColorModel = this.colorPalette.getColorModel(this.numColourBands, this.opacity);
        }
        return this.indexColorModel;
    }

    public BufferedImage getLegend(String title, String units) {
        return this.colorPalette.createLegend(this.numColourBands, title, units, this.logarithmic, this.scaleRange);
    }

    public int getNumberOfContours() {
        return this.numberOfContours;
    }
}

