/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.Phenomenon;
import uk.ac.rdg.resc.edal.Unit;
import uk.ac.rdg.resc.edal.coverage.GridCoverage2D;
import uk.ac.rdg.resc.edal.coverage.GridSeriesCoverage;
import uk.ac.rdg.resc.edal.coverage.TrajectoryCoverage;
import uk.ac.rdg.resc.edal.coverage.domain.DiscreteDomain;
import uk.ac.rdg.resc.edal.coverage.domain.TrajectoryDomain;
import uk.ac.rdg.resc.edal.coverage.domain.impl.TrajectoryDomainImpl;
import uk.ac.rdg.resc.edal.coverage.grid.GridCell2D;
import uk.ac.rdg.resc.edal.coverage.grid.GridCoordinates2D;
import uk.ac.rdg.resc.edal.coverage.grid.GridValuesMatrix;
import uk.ac.rdg.resc.edal.coverage.grid.HorizontalGrid;
import uk.ac.rdg.resc.edal.coverage.grid.RegularAxis;
import uk.ac.rdg.resc.edal.coverage.grid.impl.BorderedGrid;
import uk.ac.rdg.resc.edal.coverage.grid.impl.GridCoordinates2DImpl;
import uk.ac.rdg.resc.edal.coverage.grid.impl.RegularGridImpl;
import uk.ac.rdg.resc.edal.coverage.impl.TrajectoryCoverageImpl;
import uk.ac.rdg.resc.edal.coverage.metadata.RangeMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.ScalarMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.MetadataUtils;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.ScalarMetadataImpl;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.GridFeature;
import uk.ac.rdg.resc.edal.feature.GridSeriesFeature;
import uk.ac.rdg.resc.edal.feature.PointSeriesFeature;
import uk.ac.rdg.resc.edal.feature.ProfileFeature;
import uk.ac.rdg.resc.edal.feature.TrajectoryFeature;
import uk.ac.rdg.resc.edal.feature.impl.TrajectoryFeatureImpl;
import uk.ac.rdg.resc.edal.geometry.BoundingBox;
import uk.ac.rdg.resc.edal.geometry.impl.BoundingBoxImpl;
import uk.ac.rdg.resc.edal.graphics.Frame;
import uk.ac.rdg.resc.edal.graphics.MapStyleDescriptor;
import uk.ac.rdg.resc.edal.graphics.PlotStyle;
import uk.ac.rdg.resc.edal.position.GeoPosition;
import uk.ac.rdg.resc.edal.position.HorizontalPosition;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.edal.position.VerticalCrs;
import uk.ac.rdg.resc.edal.position.VerticalPosition;
import uk.ac.rdg.resc.edal.position.impl.GeoPositionImpl;
import uk.ac.rdg.resc.edal.position.impl.HorizontalPositionImpl;
import uk.ac.rdg.resc.edal.position.impl.TimePositionJoda;
import uk.ac.rdg.resc.edal.position.impl.VerticalCrsImpl;
import uk.ac.rdg.resc.edal.util.AbstractBigList;
import uk.ac.rdg.resc.edal.util.BigList;
import uk.ac.rdg.resc.edal.util.Extents;
import uk.ac.rdg.resc.edal.util.GISUtils;

public class MapPlotter {
    private int width;
    private int height;
    private BoundingBox bbox;
    private MapStyleDescriptor style;
    private Map<TimePosition, Frame> frameData;
    private boolean animation;

    public MapPlotter(MapStyleDescriptor style, int width, int height, BoundingBox bbox, boolean animation) {
        this.style = style;
        this.width = width;
        this.height = height;
        this.bbox = bbox;
        this.animation = animation;
        this.frameData = new HashMap<TimePosition, Frame>();
    }

    public MapPlotter(MapStyleDescriptor style, HorizontalGrid targetDomain, boolean animation) {
        this.style = style;
        this.width = targetDomain.getXAxis().size();
        this.height = targetDomain.getYAxis().size();
        this.bbox = targetDomain.getCoordinateExtent();
        this.animation = animation;
        this.frameData = new HashMap<TimePosition, Frame>();
    }

    public void addToFrame(Feature feature, String memberName, VerticalPosition vPos, TimePosition tPos, String label, PlotStyle plotStyle) {
        RangeMetadata metadata;
        Frame frame;
        TimePosition timeKey = null;
        if (this.animation) {
            timeKey = tPos;
        }
        if ((frame = this.frameData.get(timeKey)) == null) {
            frame = new Frame(this.width, this.height, label);
        }
        if ((metadata = MetadataUtils.getMetadataForFeatureMember((Feature)feature, (String)memberName)) == null) {
            throw new IllegalArgumentException("Member " + memberName + " does not exist.  Cannot plot.");
        }
        if (metadata instanceof ScalarMetadata) {
            this.addScalarMemberToFrame(frame, feature, vPos, tPos, label, plotStyle, (ScalarMetadata)metadata, this.style.getScaleRange());
        } else {
            List representativeChildren = metadata.getRepresentativeChildren();
            if (representativeChildren != null) {
                boolean plottedBoxfill = false;
                for (ScalarMetadata representativeChildMetadata : representativeChildren) {
                    PlotStyle defaultPlotStyle = PlotStyle.getDefaultPlotStyle(feature, representativeChildMetadata);
                    if (defaultPlotStyle == PlotStyle.BOXFILL) {
                        if (plottedBoxfill) {
                            plotStyle = PlotStyle.CONTOUR;
                        } else {
                            plottedBoxfill = true;
                        }
                    }
                    Extent contourScaleRange = this.style.getScaleRange();
                    if (plotStyle == PlotStyle.CONTOUR) {
                        contourScaleRange = GISUtils.estimateValueRange((Feature)feature, (String)representativeChildMetadata.getName());
                    }
                    this.addScalarMemberToFrame(frame, feature, vPos, tPos, label, plotStyle, representativeChildMetadata, (Extent<Float>)contourScaleRange);
                }
            } else {
                this.addScalarMemberToFrame(frame, feature, vPos, tPos, label, plotStyle, (ScalarMetadata)new ScalarMetadataImpl("*", "all features", null, null, Object.class), this.style.getScaleRange());
            }
        }
        if (!this.frameData.containsKey(timeKey)) {
            this.frameData.put(timeKey, frame);
        }
    }

    private void addScalarMemberToFrame(Frame frame, Feature feature, VerticalPosition vPos, TimePosition tPos, String label, PlotStyle plotStyle, ScalarMetadata metadata, Extent<Float> contourScaleRange) {
        String memberName = metadata.getName();
        if (plotStyle == PlotStyle.DEFAULT) {
            plotStyle = PlotStyle.getDefaultPlotStyle(feature, metadata);
        }
        if (feature instanceof GridSeriesFeature) {
            this.addGridSeriesFeatureToFrame((GridSeriesFeature)feature, memberName, vPos, tPos, label, plotStyle, frame, contourScaleRange);
        } else if (feature instanceof GridFeature) {
            this.addGridFeatureToFrame((GridFeature)feature, memberName, label, plotStyle, frame, contourScaleRange, false);
        } else if (feature instanceof PointSeriesFeature) {
            this.addPointSeriesFeatureToFrame((PointSeriesFeature)feature, metadata, tPos, label, plotStyle, frame);
        } else if (feature instanceof ProfileFeature) {
            this.addProfileFeatureToFrame((ProfileFeature)feature, metadata, vPos, label, plotStyle, frame);
        } else if (feature instanceof TrajectoryFeature) {
            this.addTrajectoryFeatureToFrame((TrajectoryFeature)feature, metadata, label, plotStyle, frame);
        } else {
            throw new UnsupportedOperationException("Plotting of features of the type " + feature.getClass() + " on a map is not yet supported");
        }
    }

    private void addGridSeriesFeatureToFrame(GridSeriesFeature feature, final String memberName, final VerticalPosition vPos, final TimePosition tPos, String label, PlotStyle plotStyle, Frame frame, Extent<Float> contourScaleRange) {
        RangeMetadata memberMetadata = MetadataUtils.getDescendantMetadata((RangeMetadata)feature.getCoverage().getRangeMetadata(), (String)memberName);
        Set<String> memberNamesToExtract = this.getAllScalarChildrenOf(memberMetadata);
        if (plotStyle == PlotStyle.TRAJECTORY) {
            throw new UnsupportedOperationException("Cannot plot this type of feature as a trajectory");
        }
        if (plotStyle == PlotStyle.GRIDPOINT) {
            final GridSeriesCoverage coverage = feature.getCoverage();
            this.addGridpoints(frame, feature.getCoverage().getDomain().getHorizontalGrid(), new Evaluator(){

                @Override
                public Object evaluate(HorizontalPosition hPos) {
                    return coverage.evaluate((Object)new GeoPositionImpl(hPos, vPos, tPos), memberName);
                }
            });
        } else if (plotStyle == PlotStyle.POINT) {
            if (!Number.class.isAssignableFrom(feature.getCoverage().getScalarMetadata(memberName).getValueType())) {
                throw new UnsupportedOperationException("Cannot plot non-numerical data as coloured points");
            }
            final GridSeriesCoverage coverage = feature.getCoverage();
            this.addColouredPoints(frame, feature.getCoverage().getDomain().getHorizontalGrid(), new Evaluator(){

                @Override
                public Object evaluate(HorizontalPosition hPos) {
                    return coverage.evaluate((Object)new GeoPositionImpl(hPos, vPos, tPos), memberName);
                }
            }, plotStyle);
        } else {
            GridFeature gridFeature = feature.extractGridFeature((HorizontalGrid)new RegularGridImpl(this.bbox, this.width, this.height), vPos, tPos, memberNamesToExtract);
            this.addGridFeatureToFrame(gridFeature, memberName, label, plotStyle, frame, contourScaleRange, true);
        }
    }

    private void addGridFeatureToFrame(GridFeature feature, final String memberName, String label, PlotStyle plotStyle, Frame frame, Extent<Float> contourScaleRange, boolean alreadyExtracted) {
        if (plotStyle == PlotStyle.TRAJECTORY) {
            throw new UnsupportedOperationException("Cannot plot this type of feature as a trajectory");
        }
        if (plotStyle == PlotStyle.GRIDPOINT) {
            final GridCoverage2D coverage = feature.getCoverage();
            this.addGridpoints(frame, feature.getCoverage().getDomain(), new Evaluator(){

                @Override
                public Object evaluate(HorizontalPosition hPos) {
                    return coverage.evaluate((Object)hPos, memberName);
                }
            });
        } else if (plotStyle == PlotStyle.POINT) {
            if (!Number.class.isAssignableFrom(feature.getCoverage().getScalarMetadata(memberName).getValueType())) {
                throw new UnsupportedOperationException("Cannot plot non-numerical data as coloured points");
            }
            final GridCoverage2D coverage = feature.getCoverage();
            this.addColouredPoints(frame, feature.getCoverage().getDomain(), new Evaluator(){

                @Override
                public Object evaluate(HorizontalPosition hPos) {
                    return coverage.evaluate((Object)hPos, memberName);
                }
            }, plotStyle);
        } else {
            BoundingBox coordinateExtent = feature.getCoverage().getDomain().getCoordinateExtent();
            int fWidth = feature.getCoverage().getDomain().getXAxis().size();
            int fHeight = feature.getCoverage().getDomain().getYAxis().size();
            if (fWidth != this.width || fHeight != this.height || !coordinateExtent.equals(this.bbox)) {
                RangeMetadata memberMetadata = MetadataUtils.getDescendantMetadata((RangeMetadata)feature.getCoverage().getRangeMetadata(), (String)memberName);
                Set<String> memberNamesToExtract = this.getAllScalarChildrenOf(memberMetadata);
                feature = feature.extractGridFeature((HorizontalGrid)new RegularGridImpl(this.bbox, this.width, this.height), memberNamesToExtract);
            }
            Number[][] data = this.getDataFromGridFeature(feature, memberName);
            frame.addGriddedData(data, plotStyle, contourScaleRange);
        }
    }

    private void addGridpoints(Frame frame, HorizontalGrid featureGrid, Evaluator evaluator) {
        RegularGridImpl targetDomain = new RegularGridImpl(this.bbox, this.width, this.height);
        RegularAxis xAxis = targetDomain.getXAxis();
        RegularAxis yAxis = targetDomain.getYAxis();
        CoordinateReferenceSystem crs = this.bbox.getCoordinateReferenceSystem();
        HashSet<Long> neededIndices = new HashSet<Long>();
        Iterator i$ = xAxis.getCoordinateValues().iterator();
        while (i$.hasNext()) {
            double x = (Double)i$.next();
            Iterator i$2 = yAxis.getCoordinateValues().iterator();
            while (i$2.hasNext()) {
                double y = (Double)i$2.next();
                long index = featureGrid.findIndexOf((Object)new HorizontalPositionImpl(x, y, crs));
                if (index <= 0L) continue;
                neededIndices.add(index);
            }
        }
        HashSet<GridCoordinates2D> coords = new HashSet<GridCoordinates2D>();
        Iterator i$3 = neededIndices.iterator();
        while (i$3.hasNext()) {
            Object val;
            long index = (Long)i$3.next();
            GridCoordinates2D gridCoords = featureGrid.getCoords(index);
            HorizontalPosition hPos = featureGrid.getGridCell(gridCoords).getCentre();
            GridCell2D containingCell = targetDomain.findContainingCell(hPos);
            if (containingCell == null || (val = evaluator.evaluate(hPos)) == null || Float.class.isAssignableFrom(val.getClass()) && Float.isNaN(((Float)val).floatValue())) continue;
            coords.add(containingCell.getGridCoordinates());
        }
        frame.addGridPoints(coords);
    }

    private void addColouredPoints(Frame frame, HorizontalGrid featureGrid, Evaluator evaluator, PlotStyle plotStyle) {
        BorderedGrid targetDomain = new BorderedGrid(this.bbox, this.width, this.height);
        RegularAxis xAxis = targetDomain.getXAxis();
        RegularAxis yAxis = targetDomain.getYAxis();
        CoordinateReferenceSystem crs = this.bbox.getCoordinateReferenceSystem();
        LinkedHashSet<Long> neededIndices = new LinkedHashSet<Long>();
        Iterator i$ = xAxis.getCoordinateValues().iterator();
        while (i$.hasNext()) {
            double x = (Double)i$.next();
            Iterator i$2 = yAxis.getCoordinateValues().iterator();
            while (i$2.hasNext()) {
                double y = (Double)i$2.next();
                long index = featureGrid.findIndexOf((Object)new HorizontalPositionImpl(x, y, crs));
                if (index <= 0L) continue;
                neededIndices.add(index);
            }
        }
        ArrayList<GridCoordinates2D> coords = new ArrayList<GridCoordinates2D>();
        ArrayList<Number> values = new ArrayList<Number>();
        Iterator i$3 = neededIndices.iterator();
        while (i$3.hasNext()) {
            Number valueObject;
            long index = (Long)i$3.next();
            GridCoordinates2D gridCoords = featureGrid.getCoords(index);
            HorizontalPosition hPos = featureGrid.getGridCell(gridCoords).getCentre();
            GridCell2D containingCell = targetDomain.findContainingCell(hPos);
            if (containingCell == null || (valueObject = (Number)evaluator.evaluate(hPos)) == null || Float.isNaN(valueObject.floatValue())) continue;
            coords.add(containingCell.getGridCoordinates());
            values.add(valueObject);
        }
        frame.addMultipointData(values, coords, plotStyle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addPointSeriesFeatureToFrame(PointSeriesFeature feature, ScalarMetadata metadata, TimePosition tPos, String label, PlotStyle plotStyle, Frame frame) {
        BorderedGrid targetDomain = new BorderedGrid(this.bbox, this.width, this.height);
        GridCell2D containingCell = targetDomain.findContainingCell(feature.getHorizontalPosition());
        if (containingCell == null) return;
        GridCoordinates2D gridCoordinates = containingCell.getGridCoordinates();
        if (plotStyle == PlotStyle.POINT) {
            if (metadata == null) throw new UnsupportedOperationException("Plotting of non-scalar members of PointSeriesFeatures is not yet supported");
            Class clazz = metadata.getValueType();
            Number value = null;
            if (Number.class.isAssignableFrom(clazz)) {
                value = (Number)feature.getCoverage().evaluate((Object)tPos, metadata.getName());
            }
            frame.addPointData(value, gridCoordinates, plotStyle);
            return;
        } else {
            if (plotStyle != PlotStyle.GRIDPOINT) throw new IllegalArgumentException("Cannot plot a PointSeriesFeature in the style " + (Object)((Object)plotStyle));
            ArrayList<GridCoordinates2D> coord = new ArrayList<GridCoordinates2D>();
            frame.addGridPoints(coord);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addProfileFeatureToFrame(ProfileFeature feature, ScalarMetadata metadata, VerticalPosition vPos, String label, PlotStyle plotStyle, Frame frame) {
        BorderedGrid targetDomain = new BorderedGrid(this.bbox, this.width, this.height);
        GridCell2D containingCell = targetDomain.findContainingCell(feature.getHorizontalPosition());
        if (containingCell == null) return;
        GridCoordinates2D gridCoordinates = containingCell.getGridCoordinates();
        if (plotStyle == PlotStyle.POINT) {
            if (metadata == null) throw new UnsupportedOperationException("Plotting of non-scalar members of ProfileFeatures is not yet supported");
            Class clazz = metadata.getValueType();
            Number value = null;
            if (Number.class.isAssignableFrom(clazz)) {
                value = (Number)feature.getCoverage().evaluate((Object)vPos, metadata.getName());
            }
            frame.addPointData(value, gridCoordinates, plotStyle);
            return;
        } else {
            if (plotStyle != PlotStyle.GRIDPOINT) throw new IllegalArgumentException("Cannot plot a ProfileFeature in the style " + (Object)((Object)plotStyle));
            ArrayList<GridCoordinates2D> coord = new ArrayList<GridCoordinates2D>();
            coord.add(gridCoordinates);
            frame.addGridPoints(coord);
        }
    }

    private void addTrajectoryFeatureToFrame(TrajectoryFeature feature, ScalarMetadata metadata, String label, PlotStyle plotStyle, Frame frame) {
        if (plotStyle != PlotStyle.TRAJECTORY && plotStyle != PlotStyle.GRIDPOINT && plotStyle != PlotStyle.POINT) {
            throw new IllegalArgumentException("Cannot plot a TrajectoryFeature in the style " + (Object)((Object)plotStyle));
        }
        RegularGridImpl targetDomain = new RegularGridImpl(this.bbox, this.width, this.height);
        TrajectoryCoverage coverage = feature.getCoverage();
        List positions = coverage.getDomain().getDomainObjects();
        ArrayList<GridCoordinates2D> coords = new ArrayList<GridCoordinates2D>();
        ArrayList<Number> values = new ArrayList<Number>();
        boolean numberField = false;
        if (metadata != null) {
            Class clazz = metadata.getValueType();
            if (Number.class.isAssignableFrom(clazz)) {
                numberField = true;
            }
        } else {
            throw new UnsupportedOperationException("Plotting of non-scalar members of TrajectoryFeatures is not yet supported");
        }
        for (GeoPosition geoPos : positions) {
            HorizontalPosition pos = geoPos.getHorizontalPosition();
            if (pos.getCoordinateReferenceSystem() != targetDomain.getCoordinateReferenceSystem()) {
                pos = GISUtils.transformPosition((HorizontalPosition)pos, (CoordinateReferenceSystem)targetDomain.getCoordinateReferenceSystem());
            }
            double fracAlongX = (pos.getX() - (Double)targetDomain.getXAxis().getCoordinateExtent().getLow()) / ((Double)targetDomain.getXAxis().getCoordinateExtent().getHigh() - (Double)targetDomain.getXAxis().getCoordinateExtent().getLow());
            int xIndex = (int)(fracAlongX * (double)this.width);
            double fracAlongY = (pos.getY() - (Double)targetDomain.getYAxis().getCoordinateExtent().getLow()) / ((Double)targetDomain.getYAxis().getCoordinateExtent().getHigh() - (Double)targetDomain.getYAxis().getCoordinateExtent().getLow());
            int yIndex = this.height - 1 - (int)(fracAlongY * (double)this.height);
            coords.add((GridCoordinates2D)new GridCoordinates2DImpl(xIndex, yIndex));
            if (numberField) {
                values.add((Number)coverage.evaluate((Object)geoPos, metadata.getName()));
                continue;
            }
            values.add(null);
        }
        frame.addMultipointData(values, coords, plotStyle);
    }

    private Set<String> getAllScalarChildrenOf(RangeMetadata rangeMetadata) {
        HashSet<String> returnSet = new HashSet<String>();
        if (rangeMetadata instanceof ScalarMetadata) {
            returnSet.add(rangeMetadata.getName());
        } else {
            for (String subMember : rangeMetadata.getMemberNames()) {
                RangeMetadata memberMetadata = rangeMetadata.getMemberMetadata(subMember);
                if (memberMetadata instanceof ScalarMetadata) {
                    returnSet.add(subMember);
                    continue;
                }
                returnSet.addAll(this.getAllScalarChildrenOf(memberMetadata));
            }
        }
        return returnSet;
    }

    public List<BufferedImage> getRenderedFrames() {
        if (this.style.isAutoScale() && this.frameData.size() > 1) {
            ArrayList<Comparable> mins = new ArrayList<Comparable>();
            ArrayList<Comparable> maxes = new ArrayList<Comparable>();
            Extent<Float> frameRange = this.frameData.get(0).getAutoRange();
            mins.add(frameRange.getLow());
            maxes.add(frameRange.getHigh());
            this.style.setScaleRange((Extent<Float>)Extents.newExtent(Collections.min(mins), Collections.max(maxes)));
        }
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        ArrayList<TimePosition> times = new ArrayList<TimePosition>(this.frameData.keySet());
        Collections.sort(times);
        for (TimePosition time : times) {
            images.add(this.frameData.get(time).renderLayers(this.style));
        }
        if (images.size() == 0) {
            images.add(new BufferedImage(this.width, this.height, 2));
        }
        return images;
    }

    private Number[][] getDataFromGridFeature(GridFeature feature, String memberName) {
        GridValuesMatrix gridVals = feature.getCoverage().getGridValues(memberName);
        Class clazz = gridVals.getValueType();
        if (!Number.class.isAssignableFrom(clazz)) {
            throw new UnsupportedOperationException("Can only add frames from GridValuesMatrix objects which contain numbers");
        }
        int width = feature.getCoverage().getDomain().getXAxis().size();
        int height = feature.getCoverage().getDomain().getYAxis().size();
        Number[][] data = new Number[width][height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                Number num;
                int dataIndex = MapPlotter.getDataIndex(i, j, width, height);
                data[i][j] = num = (Number)gridVals.getValues().get(dataIndex);
            }
        }
        return data;
    }

    static int getDataIndex(int imageI, int imageJ, int width, int height) {
        int dataJ = height - imageJ - 1;
        int dataIndex = dataJ * width + imageI;
        return dataIndex;
    }

    public static void main(String[] args) throws InstantiationException, IOException {
        int i;
        ArrayList<GeoPositionImpl> positions = new ArrayList<GeoPositionImpl>();
        final ArrayList<Float> values = new ArrayList<Float>();
        int SIZE = 100;
        double[] xs = new double[SIZE];
        double[] ys = new double[SIZE];
        for (i = 0; i < SIZE; ++i) {
            xs[i] = 5.1 * Math.cos((double)i * 2.0 * Math.PI / (double)(SIZE - 1));
            ys[i] = 4.9 * Math.sin((double)i * 2.0 * Math.PI / (double)(SIZE - 1));
        }
        for (i = 0; i < xs.length; ++i) {
            positions.add(new GeoPositionImpl((HorizontalPosition)new HorizontalPositionImpl(xs[i], ys[i], (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), Double.valueOf(0.0), (VerticalCrs)new VerticalCrsImpl(Unit.getUnit((String)"m"), VerticalCrs.PositiveDirection.DOWN, false), (TimePosition)new TimePositionJoda((long)i * 100000L)));
            values.add(Float.valueOf(i));
        }
        TrajectoryDomainImpl domain = new TrajectoryDomainImpl(positions);
        TrajectoryCoverageImpl coverage = new TrajectoryCoverageImpl("coverage for trajectory", (TrajectoryDomain)domain);
        coverage.addMember("test", (DiscreteDomain)domain, "desc", Phenomenon.getPhenomenon((String)"test"), Unit.getUnit((String)"testunit"), (BigList)new AbstractBigList<Float>(){

            public Float get(long index) {
                return (Float)values.get((int)index);
            }

            public long sizeAsLong() {
                return values.size();
            }
        }, Float.class);
        MapStyleDescriptor style = new MapStyleDescriptor();
        TrajectoryFeatureImpl feature = new TrajectoryFeatureImpl("Trajectory feature", "tfeature", "long winded description", (TrajectoryCoverage)coverage, null);
        MapPlotter plotter = new MapPlotter(style, 500, 500, (BoundingBox)new BoundingBoxImpl(new double[]{-5.0, -5.0, 5.0, 5.0}, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), false);
        plotter.addToFrame((Feature)feature, "test", null, null, null, PlotStyle.TRAJECTORY);
        ImageIO.write((RenderedImage)plotter.getRenderedFrames().get(0), "png", new File("/home/guy/00traj.png"));
    }

    private static interface Evaluator {
        public Object evaluate(HorizontalPosition var1);
    }
}

