/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SimpleGrid;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Range2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.coverage.grid.GridCoordinates2D;
import uk.ac.rdg.resc.edal.graphics.ColourableIcon;
import uk.ac.rdg.resc.edal.graphics.FrameData;
import uk.ac.rdg.resc.edal.graphics.GridPointsFrameData;
import uk.ac.rdg.resc.edal.graphics.GriddedFrameData;
import uk.ac.rdg.resc.edal.graphics.MapStyleDescriptor;
import uk.ac.rdg.resc.edal.graphics.MultiPointFrameData;
import uk.ac.rdg.resc.edal.graphics.PlotStyle;
import uk.ac.rdg.resc.edal.graphics.PointFrameData;
import uk.ac.rdg.resc.edal.util.Extents;

public class Frame {
    private List<FrameData> layers;
    private int width;
    private int height;
    private String label;

    public Frame(int width, int height, String label) {
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException("You can't make a frame with zero width or height");
        }
        this.width = width;
        this.height = height;
        this.label = label;
        this.layers = new ArrayList<FrameData>();
    }

    public void addGridPoints(Collection<GridCoordinates2D> coords) {
        this.layers.add(new GridPointsFrameData(coords));
    }

    public void addGriddedData(Number[][] data, PlotStyle style, Extent<Float> contourScaleRange) {
        if (data.length != this.width) {
            throw new IllegalArgumentException("Can only add data with width " + this.width);
        }
        if (data[0].length != this.height) {
            throw new IllegalArgumentException("Can only add data with height " + this.height);
        }
        this.layers.add(new GriddedFrameData(style, data, contourScaleRange));
    }

    public void addPointData(Number value, GridCoordinates2D coords, PlotStyle style) {
        this.layers.add(new PointFrameData(style, coords.getXIndex(), coords.getYIndex(), value));
    }

    public void addMultipointData(List<Number> values, List<GridCoordinates2D> coords, PlotStyle plotStyle) {
        this.layers.add(new MultiPointFrameData(plotStyle, coords, values));
    }

    public BufferedImage renderLayers(MapStyleDescriptor style) {
        if (style.isAutoScale()) {
            style.setScaleRange(this.getAutoRange());
        }
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        Graphics graphics = image.getGraphics();
        if (!style.isTransparent()) {
            graphics.setColor(style.getBgColor());
            graphics.fillRect(0, 0, this.width, this.height);
        }
        for (FrameData frameData : this.layers) {
            BufferedImage frameImage = null;
            switch (frameData.getPlotStyle()) {
                case BOXFILL: {
                    frameImage = this.drawGriddedImage(frameData, style);
                    break;
                }
                case VECTOR: {
                    frameImage = this.drawVectorArrows(frameData, style);
                    break;
                }
                case TRAJECTORY: {
                    frameImage = this.drawTrajectory(frameData, style);
                    break;
                }
                case POINT: {
                    frameImage = this.drawPointImage(frameData, style);
                    break;
                }
                case CONTOUR: {
                    frameImage = this.drawContourImage(frameData, style);
                    break;
                }
                case GRIDPOINT: {
                    frameImage = this.drawGridPoints(frameData);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognised plotting style");
                }
            }
            graphics.drawImage(frameImage, 0, 0, null);
        }
        if (this.label != null && !this.label.equals("")) {
            Graphics2D gfx = (Graphics2D)image.getGraphics();
            gfx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            gfx.setPaint(new Color(0, 0, 0));
            gfx.fillRect(1, image.getHeight() - 19, image.getWidth() - 2, 18);
            gfx.setPaint(new Color(255, 255, 255));
            gfx.drawRect(0, image.getHeight() - 20, image.getWidth() - 1, 19);
            gfx.drawString(this.label, 10, image.getHeight() - 5);
        }
        return image;
    }

    private BufferedImage drawGriddedImage(FrameData frameData, MapStyleDescriptor style) {
        byte[] pixels = new byte[this.width * this.height];
        if (frameData instanceof GriddedFrameData) {
            Number[][] data = ((GriddedFrameData)frameData).getData();
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    Number datum = data[i][j];
                    pixels[i + this.width * j] = (byte)style.getColourIndex(datum);
                }
            }
            IndexColorModel colorModel = style.getColorModel();
            DataBufferByte buf = new DataBufferByte(pixels, this.width * this.height);
            SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(this.width, this.height);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, buf, null);
            return new BufferedImage(colorModel, raster, false, null);
        }
        throw new UnsupportedOperationException("Can only plot gridded images with gridded data");
    }

    private BufferedImage drawVectorArrows(FrameData frameData, MapStyleDescriptor style) {
        if (frameData instanceof GriddedFrameData) {
            Number[][] data = ((GriddedFrameData)frameData).getData();
            BufferedImage image = new BufferedImage(this.width, this.height, 2);
            Graphics2D g = image.createGraphics();
            g.setColor(Color.BLACK);
            float arrowLength = style.getArrowLength();
            int minXMod = Integer.MAX_VALUE;
            int minYMod = Integer.MAX_VALUE;
            double spacingX = (int)Math.ceil((double)arrowLength * 1.5);
            double spacingY = (int)Math.ceil((double)arrowLength * 1.5);
            int s = (int)((double)arrowLength * 1.5);
            while ((double)s < (double)arrowLength * 2.5) {
                int modY;
                int modX = this.width % s;
                if (modX < minXMod) {
                    spacingX = s;
                    minXMod = modX;
                }
                if ((modY = this.height % s) < minYMod) {
                    spacingY = s;
                    minYMod = modY;
                }
                ++s;
            }
            if (minXMod != 0) {
                spacingX = (double)this.width / (double)((int)((double)this.width / spacingX));
            }
            if (minYMod != 0) {
                spacingY = (double)this.height / (double)((int)((double)this.height / spacingY));
            }
            for (double di = 0.5 * spacingX; di < (double)this.width; di += spacingX) {
                int i = (int)di;
                for (double dj = 0.5 * spacingY; dj < (double)this.height; dj += spacingY) {
                    int j = (int)dj;
                    Number angle = data[i][j];
                    if (angle == null || Float.isNaN(angle.floatValue())) continue;
                    double iEnd = (double)i + (double)arrowLength * Math.cos(angle.doubleValue());
                    double jEnd = (double)j - (double)arrowLength * Math.sin(angle.doubleValue());
                    g.fillOval(i - 2, j - 2, 4, 4);
                    g.setColor(Color.BLACK);
                    g.setStroke(new BasicStroke(1.0f));
                    g.drawLine(i, j, (int)Math.round(iEnd), (int)Math.round(jEnd));
                }
            }
            return image;
        }
        throw new UnsupportedOperationException("Can only plot vector arrows for gridded data");
    }

    private BufferedImage drawTrajectory(FrameData frameData, MapStyleDescriptor style) {
        if (frameData instanceof MultiPointFrameData) {
            MultiPointFrameData multiPointFrameData = (MultiPointFrameData)frameData;
            BufferedImage image = new BufferedImage(this.width, this.height, 2);
            Graphics2D canvas = image.createGraphics();
            canvas.setStroke(new BasicStroke(2.0f, 1, 1));
            double r = 10.0;
            PointFrameData lastPointData = multiPointFrameData.getPointData(0);
            int lastArrowX = lastPointData.getX();
            int lastArrowY = lastPointData.getY();
            canvas.setPaint(style.getColorForValue(lastPointData.getValue()));
            for (int i = 1; i < multiPointFrameData.size(); ++i) {
                PointFrameData pointData = multiPointFrameData.getPointData(i);
                int midX = (lastPointData.getX() + pointData.getX()) / 2;
                int midY = (lastPointData.getY() + pointData.getY()) / 2;
                canvas.drawLine(lastPointData.getX(), lastPointData.getY(), midX, midY);
                canvas.setPaint(style.getColorForValue(pointData.getValue()));
                canvas.drawLine(midX, midY, pointData.getX(), pointData.getY());
                double distFromLastArrow = Math.sqrt((pointData.getX() - lastArrowX) * (pointData.getX() - lastArrowX) + (pointData.getY() - lastArrowY) * (pointData.getY() - lastArrowY));
                if (distFromLastArrow > 30.0) {
                    double lineAngle = Math.PI * 2 - Math.atan2(pointData.getY() - lastPointData.getY(), pointData.getX() - lastPointData.getX());
                    double headAngle1 = lineAngle + 0.3;
                    double headAngle2 = lineAngle - 0.3;
                    double xh1 = r * Math.cos(headAngle1);
                    double xh2 = r * Math.cos(headAngle2);
                    double yh1 = r * Math.sin(headAngle1);
                    double yh2 = r * Math.sin(headAngle2);
                    canvas.drawLine(-((int)xh1) + pointData.getX(), (int)yh1 + pointData.getY(), pointData.getX(), pointData.getY());
                    canvas.drawLine(-((int)xh2) + pointData.getX(), (int)yh2 + pointData.getY(), pointData.getX(), pointData.getY());
                    lastArrowX = pointData.getX();
                    lastArrowY = pointData.getY();
                }
                lastPointData = pointData;
            }
            return image;
        }
        throw new UnsupportedOperationException("Can only plot trajectories for data with more than one point");
    }

    private BufferedImage drawPointImage(FrameData frameData, MapStyleDescriptor style) {
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        Graphics2D canvas = image.createGraphics();
        if (frameData instanceof PointFrameData) {
            PointFrameData pointFrameData = (PointFrameData)frameData;
            this.doPointPlot(pointFrameData, canvas, style, "circle");
        } else if (frameData instanceof MultiPointFrameData) {
            MultiPointFrameData multiPointFrameData = (MultiPointFrameData)frameData;
            for (int i = 0; i < multiPointFrameData.size(); ++i) {
                this.doPointPlot(multiPointFrameData.getPointData(i), canvas, style, "square");
            }
        } else {
            throw new UnsupportedOperationException("Point images are currently only supported for non-gridded data");
        }
        return image;
    }

    private void doPointPlot(PointFrameData pointFrameData, Graphics2D canvas, MapStyleDescriptor style, String iconName) {
        Number value = pointFrameData.getValue();
        Color color = style.getColorForValue(value);
        ColourableIcon pointIcon = style.getIcon(iconName);
        canvas.drawImage((Image)pointIcon.getColouredIcon(color), pointFrameData.getX() - pointIcon.getWidth() / 2, this.height - (pointFrameData.getY() + pointIcon.getHeight() / 2) - 1, null);
    }

    private BufferedImage drawContourImage(FrameData frameData, MapStyleDescriptor style) {
        if (frameData instanceof GriddedFrameData) {
            GriddedFrameData griddedFrameData = (GriddedFrameData)frameData;
            Number[][] data = griddedFrameData.getData();
            int count = 0;
            double[] values = new double[this.width * this.height];
            double[] xAxis = new double[this.width];
            double[] yAxis = new double[this.height];
            Extent<Float> scaleRange = griddedFrameData.getContourScaleRange() != null ? griddedFrameData.getContourScaleRange() : style.getScaleRange();
            double minValue = ((Float)scaleRange.getLow()).floatValue();
            double maxValue = ((Float)scaleRange.getHigh()).floatValue();
            for (int i = 0; i < this.width; ++i) {
                xAxis[i] = i;
                for (int j = 0; j < this.height; ++j) {
                    yAxis[j] = this.height - j - 1;
                    values[count] = data[i][j] == null ? Double.NaN : data[i][j].doubleValue();
                    ++count;
                }
            }
            SimpleGrid sgtGrid = new SimpleGrid(values, xAxis, yAxis, null);
            CartesianGraph cg = this.getCartesianGraph((SGTData)sgtGrid);
            double contourSpacing = (maxValue - minValue) / (double)(style.getNumberOfContours() - 1);
            Range2D contourValues = new Range2D(minValue, maxValue, contourSpacing);
            ContourLevels clevels = ContourLevels.getDefault((Range2D)contourValues);
            DefaultContourLineAttribute defAttr = new DefaultContourLineAttribute();
            defAttr.setColor(Color.BLACK);
            defAttr.setStyle(1);
            defAttr.setLabelEnabled(true);
            clevels.setDefaultContourLineAttribute(defAttr);
            GridAttribute attr = new GridAttribute(clevels);
            attr.setStyle(2);
            CartesianRenderer renderer = CartesianRenderer.getRenderer((CartesianGraph)cg, (SGTData)sgtGrid, (Attribute)attr);
            BufferedImage im = new BufferedImage(this.width, this.height, 2);
            Graphics g = im.getGraphics();
            renderer.draw(g);
            return im;
        }
        throw new UnsupportedOperationException("Can only plot contour images with gridded data");
    }

    private CartesianGraph getCartesianGraph(SGTData data) {
        double factor = 96.0;
        double physWidth = (double)this.width / factor;
        double physHeight = (double)this.height / factor;
        Layer layer = new Layer("", new Dimension2D(physWidth, physHeight));
        JPane pane = new JPane("id", new Dimension(this.width, this.height));
        layer.setPane((AbstractPane)pane);
        layer.setBounds(0, 0, this.width, this.height);
        CartesianGraph graph = new CartesianGraph();
        Range2D physXRange = new Range2D(0.0, physWidth);
        Range2D physYRange = new Range2D(0.0, physHeight);
        LinearTransform xt = new LinearTransform(physXRange, data.getXRange());
        LinearTransform yt = new LinearTransform(physYRange, data.getYRange());
        graph.setXTransform((AxisTransform)xt);
        graph.setYTransform((AxisTransform)yt);
        layer.setGraph((Graph)graph);
        return graph;
    }

    private BufferedImage drawGridPoints(FrameData frameData) {
        if (!(frameData instanceof GridPointsFrameData)) {
            throw new IllegalArgumentException("We need grid point data to plot grid points");
        }
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        GridPointsFrameData gridPointsFrameData = (GridPointsFrameData)frameData;
        int black = Color.BLACK.getRGB();
        for (GridCoordinates2D gridCoord : gridPointsFrameData.getPointData()) {
            int x = gridCoord.getXIndex();
            int y = this.height - gridCoord.getYIndex() - 1;
            if (x < 0 || x >= this.width || y < 0 || y >= this.height) continue;
            image.setRGB(x, y, black);
        }
        return image;
    }

    public Extent<Float> getAutoRange() {
        Float min = Float.valueOf(Float.MAX_VALUE);
        Float max = Float.valueOf(Float.MIN_VALUE);
        for (FrameData layer : this.layers) {
            if (layer instanceof GriddedFrameData) {
                GriddedFrameData griddedFrameData = (GriddedFrameData)layer;
                Number[][] data = griddedFrameData.getData();
                if (layer.getPlotStyle() == PlotStyle.VECTOR) continue;
                for (int i = 0; i < data.length; ++i) {
                    for (int j = 0; j < data[i].length; ++j) {
                        Number value = data[i][j];
                        if (value == null || value.equals(Float.valueOf(Float.NaN)) || value.equals(Double.NaN)) continue;
                        if (value.floatValue() < min.floatValue()) {
                            min = Float.valueOf(value.floatValue());
                        }
                        if (!(value.floatValue() > max.floatValue())) continue;
                        max = Float.valueOf(value.floatValue());
                    }
                }
                continue;
            }
            if (layer instanceof PointFrameData) {
                PointFrameData pointFrameData = (PointFrameData)layer;
                Number value = pointFrameData.getValue();
                if (value == null || value.equals(Float.valueOf(Float.NaN)) || value.equals(Double.NaN)) continue;
                if (value.floatValue() < min.floatValue()) {
                    min = Float.valueOf(value.floatValue());
                }
                if (!(value.floatValue() > max.floatValue())) continue;
                max = Float.valueOf(value.floatValue());
                continue;
            }
            if (!(layer instanceof MultiPointFrameData)) continue;
            MultiPointFrameData multiPointFrameData = (MultiPointFrameData)layer;
            for (int i = 0; i < multiPointFrameData.size(); ++i) {
                PointFrameData pointFrameData = multiPointFrameData.getPointData(i);
                Number value = pointFrameData.getValue();
                if (value == null || value.equals(Float.valueOf(Float.NaN)) || value.equals(Double.NaN)) continue;
                if (value.floatValue() < min.floatValue()) {
                    min = Float.valueOf(value.floatValue());
                }
                if (!(value.floatValue() > max.floatValue())) continue;
                max = Float.valueOf(value.floatValue());
            }
        }
        if (min.equals(Float.valueOf(Float.MAX_VALUE)) || max.equals(Float.valueOf(Float.MIN_VALUE))) {
            return Extents.newExtent((Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f));
        }
        return Extents.newExtent((Object)min, (Object)max);
    }
}

