/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class ColourableIcon {
    private BufferedImage icon;
    private int height;
    private int width;

    public ColourableIcon(BufferedImage icon) {
        this.icon = icon;
        this.height = icon.getHeight();
        this.width = icon.getWidth();
    }

    public void drawOntoCanvas(int x, int y, Graphics graphics, Color col) {
        graphics.drawImage(this.getColouredIcon(col), x - this.width / 2, y - this.height / 2, null);
    }

    public BufferedImage getColouredIcon(Color colour) {
        return this.getColouredIcon(colour.getRed(), colour.getGreen(), colour.getBlue());
    }

    private BufferedImage getColouredIcon(int red, int green, int blue) {
        BufferedImage colouredIcon = this.cloneImage();
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int argb = this.icon.getRGB(i, j);
                int alpha = argb >>> 24;
                Color currentColour = new Color(argb);
                int r = currentColour.getRed();
                int g = currentColour.getGreen();
                int b = currentColour.getBlue();
                float y = 0.3f * (float)r + 0.59f * (float)g + 0.11f * (float)b;
                Color final_color = new Color((int)((float)(3 * red) + y) / 4, (int)((float)(3 * green) + y) / 4, (int)((float)(3 * blue) + y) / 4, alpha);
                colouredIcon.setRGB(i, j, final_color.getRGB());
            }
        }
        return colouredIcon;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    private BufferedImage cloneImage() {
        ColorModel cm = this.icon.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = this.icon.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }
}

