/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.graphics.style.StyleXMLParser;

public class ColorPalette {
    public static final int MAX_NUM_COLOURS = 254;
    private static final Map<String, ColorPalette> palettes = new HashMap<String, ColorPalette>();
    public static final String DEFAULT_PALETTE_NAME = "rainbow";
    public static final int LEGEND_WIDTH = 110;
    public static final int LEGEND_HEIGHT = 264;
    private static final ColorPalette DEFAULT_PALETTE = new ColorPalette("rainbow", new Color[]{new Color(0, 0, 143), new Color(0, 0, 159), new Color(0, 0, 175), new Color(0, 0, 191), new Color(0, 0, 207), new Color(0, 0, 223), new Color(0, 0, 239), new Color(0, 0, 255), new Color(0, 11, 255), new Color(0, 27, 255), new Color(0, 43, 255), new Color(0, 59, 255), new Color(0, 75, 255), new Color(0, 91, 255), new Color(0, 107, 255), new Color(0, 123, 255), new Color(0, 139, 255), new Color(0, 155, 255), new Color(0, 171, 255), new Color(0, 187, 255), new Color(0, 203, 255), new Color(0, 219, 255), new Color(0, 235, 255), new Color(0, 251, 255), new Color(7, 255, 247), new Color(23, 255, 231), new Color(39, 255, 215), new Color(55, 255, 199), new Color(71, 255, 183), new Color(87, 255, 167), new Color(103, 255, 151), new Color(119, 255, 135), new Color(135, 255, 119), new Color(151, 255, 103), new Color(167, 255, 87), new Color(183, 255, 71), new Color(199, 255, 55), new Color(215, 255, 39), new Color(231, 255, 23), new Color(247, 255, 7), new Color(255, 247, 0), new Color(255, 231, 0), new Color(255, 215, 0), new Color(255, 199, 0), new Color(255, 183, 0), new Color(255, 167, 0), new Color(255, 151, 0), new Color(255, 135, 0), new Color(255, 119, 0), new Color(255, 103, 0), new Color(255, 87, 0), new Color(255, 71, 0), new Color(255, 55, 0), new Color(255, 39, 0), new Color(255, 23, 0), new Color(255, 7, 0), new Color(246, 0, 0), new Color(228, 0, 0), new Color(211, 0, 0), new Color(193, 0, 0), new Color(175, 0, 0), new Color(158, 0, 0), new Color(140, 0, 0)});
    private final Color[] palette;
    private final String name;

    private ColorPalette(String name, Color[] palette) {
        this.name = name;
        this.palette = palette;
    }

    public int getSize() {
        return this.palette.length;
    }

    public static final Set<String> getAvailablePaletteNames() {
        return palettes.keySet();
    }

    public static final void loadPalettes(File paletteLocationDir) {
        for (File file : paletteLocationDir.listFiles()) {
            if (!file.getName().endsWith(".pal")) continue;
            try {
                String paletteName = file.getName().substring(0, file.getName().lastIndexOf("."));
                ColorPalette palette = new ColorPalette(paletteName, ColorPalette.readColorPalette(new FileReader(file)));
                palettes.put(palette.getName(), palette);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ColorPalette get(String name) {
        if (name == null || name.trim().equals("")) {
            return palettes.get(DEFAULT_PALETTE_NAME);
        }
        ColorPalette ret = palettes.get(name.trim().toLowerCase());
        if (ret != null) {
            return ret;
        }
        return palettes.get(DEFAULT_PALETTE_NAME);
    }

    public String getName() {
        return this.name;
    }

    public BufferedImage createColorBar(int width, int height, int numColorBands, boolean vertical) {
        Color[] newPalette = this.getPalette(numColorBands);
        BufferedImage colorBar = new BufferedImage(width, height, 1);
        Graphics2D gfx = colorBar.createGraphics();
        if (vertical) {
            double colorBandWidth = (double)height / (double)numColorBands;
            for (int i = 0; i < height; ++i) {
                int colorIndex = (int)((double)i / colorBandWidth);
                gfx.setColor(newPalette[numColorBands - colorIndex - 1]);
                gfx.drawLine(0, i, width - 1, i);
            }
        } else {
            double colorBandWidth = (double)width / (double)numColorBands;
            for (int i = 0; i < width; ++i) {
                int colorIndex = (int)((double)i / colorBandWidth);
                gfx.setColor(newPalette[colorIndex]);
                gfx.drawLine(i, 0, i, height - 1);
            }
        }
        return colorBar;
    }

    public BufferedImage createLegend(int numColorBands, String title, String units, boolean logarithmic, Extent<Float> colorScaleRange) {
        float colourScaleMin = ((Float)colorScaleRange.getLow()).floatValue();
        float colourScaleMax = ((Float)colorScaleRange.getHigh()).floatValue();
        BufferedImage colourScale = new BufferedImage(110, 264, 5);
        Graphics2D gfx = colourScale.createGraphics();
        BufferedImage colorBar = this.createColorBar(24, 254, numColorBands, true);
        gfx.drawImage(colorBar, null, 2, 5);
        gfx.setColor(Color.WHITE);
        double min = logarithmic ? Math.log(colourScaleMin) : (double)colourScaleMin;
        double max = logarithmic ? Math.log(colourScaleMax) : (double)colourScaleMax;
        double quarter = 0.25 * (max - min);
        double scaleQuarter = logarithmic ? Math.exp(min + quarter) : min + quarter;
        double scaleMid = logarithmic ? Math.exp(min + 2.0 * quarter) : min + 2.0 * quarter;
        double scaleThreeQuarter = logarithmic ? Math.exp(min + 3.0 * quarter) : min + 3.0 * quarter;
        gfx.drawString(ColorPalette.format(colourScaleMax), 27, 10);
        gfx.drawString(ColorPalette.format(scaleThreeQuarter), 27, 73);
        gfx.drawString(ColorPalette.format(scaleMid), 27, 137);
        gfx.drawString(ColorPalette.format(scaleQuarter), 27, 201);
        gfx.drawString(ColorPalette.format(colourScaleMin), 27, 264);
        if (units != null && !units.trim().equals("")) {
            title = title + " (" + units + ")";
        }
        AffineTransform trans = new AffineTransform();
        trans.setToTranslation(90.0, 0.0);
        AffineTransform rot = new AffineTransform();
        rot.setToRotation(1.5707963267948966);
        trans.concatenate(rot);
        gfx.setTransform(trans);
        gfx.drawString(title, 5, 0);
        return colourScale;
    }

    private static String format(double d) {
        if (d == 0.0) {
            return "0";
        }
        if (Math.abs(d) > 1000.0 || Math.abs(d) < 0.01) {
            return new DecimalFormat("0.###E0").format(d);
        }
        return new DecimalFormat("0.#####").format(d);
    }

    public IndexColorModel getColorModel(int numColorBands, int opacity) {
        Color[] newPalette = this.getPalette(numColorBands);
        int alpha = opacity >= 100 ? 255 : (opacity <= 0 ? 0 : (int)(2.55 * (double)opacity));
        byte[] r = new byte[numColorBands + 2];
        byte[] g = new byte[numColorBands + 2];
        byte[] b = new byte[numColorBands + 2];
        byte[] a = new byte[numColorBands + 2];
        for (int i = 0; i < numColorBands; ++i) {
            r[i] = (byte)newPalette[i].getRed();
            g[i] = (byte)newPalette[i].getGreen();
            b[i] = (byte)newPalette[i].getBlue();
            a[i] = (byte)alpha;
        }
        r[numColorBands] = 0;
        g[numColorBands] = 0;
        b[numColorBands] = 0;
        a[numColorBands] = 0;
        r[numColorBands + 1] = 0;
        g[numColorBands + 1] = 0;
        b[numColorBands + 1] = 0;
        a[numColorBands + 1] = (byte)alpha;
        return new IndexColorModel(8, r.length, r, g, b, a);
    }

    private Color[] getPalette(int numColorBands) {
        Color[] targetPalette;
        if (numColorBands < 1 || numColorBands > 254) {
            throw new IllegalArgumentException("numColorBands must be between 1 and 254");
        }
        if (numColorBands == this.palette.length) {
            targetPalette = this.palette;
        } else {
            targetPalette = new Color[numColorBands];
            targetPalette[0] = this.palette[0];
            targetPalette[targetPalette.length - 1] = this.palette[this.palette.length - 1];
            if (targetPalette.length < this.palette.length) {
                for (int i = 1; i < targetPalette.length - 1; ++i) {
                    int nearestIndex = Math.round((float)(this.palette.length * i) * 1.0f / (float)(targetPalette.length - 1));
                    targetPalette[i] = this.palette[nearestIndex];
                }
            } else {
                int lastIndex = 0;
                for (int i = 1; i < this.palette.length - 1; ++i) {
                    int nearestIndex = Math.round((float)(targetPalette.length * i) * 1.0f / (float)(this.palette.length - 1));
                    targetPalette[nearestIndex] = this.palette[i];
                    for (int j = lastIndex + 1; j < nearestIndex; ++j) {
                        float fracFromThis = (1.0f * (float)j - (float)lastIndex) / (float)(nearestIndex - lastIndex);
                        targetPalette[j] = ColorPalette.interpolate(targetPalette[nearestIndex], targetPalette[lastIndex], fracFromThis);
                    }
                    lastIndex = nearestIndex;
                }
                for (int j = lastIndex + 1; j < targetPalette.length - 1; ++j) {
                    float fracFromThis = (1.0f * (float)j - (float)lastIndex) / (float)(targetPalette.length - lastIndex);
                    targetPalette[j] = ColorPalette.interpolate(targetPalette[targetPalette.length - 1], targetPalette[lastIndex], fracFromThis);
                }
            }
        }
        return targetPalette;
    }

    private static Color interpolate(Color c1, Color c2, float fracFromC1) {
        float fracFromC2 = 1.0f - fracFromC1;
        return new Color(Math.round(fracFromC1 * (float)c1.getRed() + fracFromC2 * (float)c2.getRed()), Math.round(fracFromC1 * (float)c1.getGreen() + fracFromC2 * (float)c2.getGreen()), Math.round(fracFromC1 * (float)c1.getBlue() + fracFromC2 * (float)c2.getBlue()));
    }

    /*
     * Exception decompiling
     */
    private static Color[] readColorPalette(Reader paletteFileReader) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 6[WHILELOOP]], but top level block is 11[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                String entry = name.substring(path.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    public static void main(String[] args) throws IOException {
        StyleXMLParser.ColorAdapter ca = new StyleXMLParser.ColorAdapter();
        for (String paletteName : ColorPalette.getAvailablePaletteNames()) {
            File output = new File("/home/guy/Workspace/edal-java/graphics/src/main/resources/palettes/" + paletteName + ".pal");
            output.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(output));
            ColorPalette colorPalette = ColorPalette.get(paletteName);
            System.out.println(paletteName);
            writer.write("% " + paletteName);
            writer.newLine();
            for (Color c : colorPalette.palette) {
                writer.write(ca.marshal(c));
                writer.newLine();
                System.out.println(ca.marshal(c));
            }
            writer.close();
            System.out.println();
        }
    }

    static {
        palettes.put(DEFAULT_PALETTE_NAME, DEFAULT_PALETTE);
        try {
            String[] paletteFileNames;
            for (String paletteFileName : paletteFileNames = ColorPalette.getResourceListing(ColorPalette.class, "old_palettes/")) {
                if (!paletteFileName.endsWith(".pal")) continue;
                try {
                    String paletteName = paletteFileName.substring(0, paletteFileName.lastIndexOf("."));
                    ColorPalette palette = new ColorPalette(paletteName, ColorPalette.readColorPalette(new InputStreamReader(ColorPalette.class.getResource("/old_palettes/" + paletteFileName).openStream())));
                    palettes.put(palette.getName(), palette);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

