/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.IndexColorModel;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.AbstractXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.coverage.domain.impl.HorizontalDomain;
import uk.ac.rdg.resc.edal.coverage.grid.GridCell2D;
import uk.ac.rdg.resc.edal.coverage.grid.HorizontalGrid;
import uk.ac.rdg.resc.edal.coverage.grid.VerticalAxis;
import uk.ac.rdg.resc.edal.coverage.metadata.ScalarMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.MetadataUtils;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.GridFeature;
import uk.ac.rdg.resc.edal.feature.GridSeriesFeature;
import uk.ac.rdg.resc.edal.feature.PointSeriesFeature;
import uk.ac.rdg.resc.edal.feature.ProfileFeature;
import uk.ac.rdg.resc.edal.feature.TrajectoryFeature;
import uk.ac.rdg.resc.edal.geometry.impl.LineString;
import uk.ac.rdg.resc.edal.graphics.ColorPalette;
import uk.ac.rdg.resc.edal.position.GeoPosition;
import uk.ac.rdg.resc.edal.position.HorizontalPosition;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.edal.position.VerticalCrs;
import uk.ac.rdg.resc.edal.position.VerticalPosition;
import uk.ac.rdg.resc.edal.util.CollectionUtils;
import uk.ac.rdg.resc.edal.util.TimeUtils;

public final class Charting {
    private static final Locale US_LOCALE = new Locale("us", "US");
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final DecimalFormat NUMBER_3DP = new DecimalFormat("#0.000");

    public static JFreeChart createTimeseriesPlot(List<Feature> features, String baseMemberName) {
        String title;
        String yLabel = "";
        VerticalPosition vPos = null;
        ScalarMetadata metadata = null;
        ArrayList<TimeSeries> timeSeries = new ArrayList<TimeSeries>();
        for (Feature feature : features) {
            List values;
            List times;
            String featureKey;
            String memberName = MetadataUtils.getScalarMemberName((Feature)feature, (String)baseMemberName);
            if (feature instanceof PointSeriesFeature) {
                PointSeriesFeature pointSeriesFeature = (PointSeriesFeature)feature;
                featureKey = "(" + NUMBER_3DP.format(pointSeriesFeature.getHorizontalPosition().getX()) + "," + NUMBER_3DP.format(pointSeriesFeature.getHorizontalPosition().getY()) + ")";
                times = pointSeriesFeature.getCoverage().getDomain().getTimes();
                values = pointSeriesFeature.getCoverage().getValues(memberName);
                vPos = pointSeriesFeature.getVerticalPosition();
            } else {
                if (!(feature instanceof TrajectoryFeature)) continue;
                TrajectoryFeature trajectoryFeature = (TrajectoryFeature)feature;
                featureKey = trajectoryFeature.getName();
                List domainObjects = trajectoryFeature.getCoverage().getDomain().getDomainObjects();
                times = new ArrayList<TimePosition>();
                for (GeoPosition geoPos : domainObjects) {
                    times.add(geoPos.getTimePosition());
                }
                values = trajectoryFeature.getCoverage().getValues(memberName);
            }
            TimeSeries ts = new TimeSeries((Comparable)((Object)featureKey), Millisecond.class);
            metadata = MetadataUtils.getScalarMetadata((Feature)feature, (String)memberName);
            if (!Number.class.isAssignableFrom(feature.getCoverage().getScalarMetadata(memberName).getValueType()) || times.size() != values.size()) continue;
            for (int i = 0; i < times.size(); ++i) {
                ts.add((RegularTimePeriod)new Millisecond(new Date(((TimePosition)times.get(i)).getValue())), (Number)values.get(i));
            }
            timeSeries.add(ts);
            yLabel = Charting.getAxisLabel(feature, memberName);
        }
        if (metadata != null) {
            title = "Timeseries of " + metadata.getTitle();
            if (vPos != null) {
                VerticalCrs vCrs = vPos.getCoordinateReferenceSystem();
                String heightOrDepth = "";
                if (vCrs != null) {
                    heightOrDepth = vCrs.getPositiveDirection() == VerticalCrs.PositiveDirection.UP ? " high" : " deep";
                }
                title = title + " at " + vPos + heightOrDepth;
            }
        } else {
            title = "No data";
        }
        TimeSeriesCollection xydataset = new TimeSeriesCollection();
        for (TimeSeries ts : timeSeries) {
            xydataset.addSeries(ts);
        }
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)"Date / time", (String)yLabel, (XYDataset)xydataset, (timeSeries.size() > 1 ? 1 : 0) != 0, (boolean)false, (boolean)false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        for (int i = 0; i < timeSeries.size(); ++i) {
            renderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
            renderer.setSeriesShapesVisible(i, true);
        }
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        chart.getXYPlot().setNoDataMessage("There is no data for your choice");
        chart.getXYPlot().setNoDataMessageFont(new Font("sansserif", 1, 32));
        return chart;
    }

    public static JFreeChart createVerticalProfilePlot(List<ProfileFeature> features, String baseMemberName) {
        String title;
        XYSeriesCollection xySeriesColl = new XYSeriesCollection();
        String xAxisLabel = "";
        TimePosition dateTime = null;
        ScalarMetadata metadata = null;
        boolean invertYAxis = false;
        ZAxisAndValues zAxisAndValues = null;
        for (ProfileFeature feature : features) {
            String memberName = MetadataUtils.getScalarMemberName((Feature)feature, (String)baseMemberName);
            metadata = MetadataUtils.getScalarMetadata((Feature)feature, (String)memberName);
            if (!Number.class.isAssignableFrom(feature.getCoverage().getScalarMetadata(memberName).getValueType())) continue;
            List dataValues = feature.getCoverage().getValues(memberName);
            dateTime = feature.getTime();
            List elevationValues = feature.getCoverage().getDomain().getZValues();
            zAxisAndValues = Charting.getZAxisAndValues(elevationValues, feature.getCoverage().getDomain().getVerticalCrs());
            String location = "(" + NUMBER_3DP.format(feature.getHorizontalPosition().getX()) + "," + NUMBER_3DP.format(feature.getHorizontalPosition().getY()) + ")";
            XYSeries series = new XYSeries((Comparable)((Object)location), true);
            series.setDescription(memberName);
            for (int i = 0; i < elevationValues.size(); ++i) {
                Number val = (Number)dataValues.get(i);
                if (val.equals(Float.valueOf(Float.NaN)) || val.equals(Double.NaN)) continue;
                series.add((Number)elevationValues.get(i), (Number)dataValues.get(i));
            }
            xAxisLabel = Charting.getAxisLabel((Feature)feature, memberName);
            xySeriesColl.addSeries(series);
        }
        NumberAxis elevationAxis = null;
        if (zAxisAndValues != null) {
            elevationAxis = zAxisAndValues.zAxis;
        }
        elevationAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (invertYAxis) {
            elevationAxis.setInverted(true);
        }
        elevationAxis.setAutoRangeIncludesZero(false);
        NumberAxis valueAxis = new NumberAxis(xAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        for (int i = 0; i < features.size(); ++i) {
            renderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
            renderer.setSeriesShapesVisible(i, true);
        }
        XYPlot plot = new XYPlot((XYDataset)xySeriesColl, (ValueAxis)elevationAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        if (metadata != null) {
            title = "Profile of " + metadata.getTitle();
            if (dateTime != null) {
                title = title + " at " + TimeUtils.formatUTCHumanReadableDateTime((TimePosition)dateTime);
            }
        } else {
            title = "No data";
        }
        return new JFreeChart(title, null, (Plot)plot, true);
    }

    private static String getAxisLabel(Feature feature, String memberName) {
        ScalarMetadata metadata = MetadataUtils.getScalarMetadata((Feature)feature, (String)memberName);
        return metadata.getTitle() + " (" + metadata.getUnits().getUnitString() + ")";
    }

    public static JFreeChart createTransectPlot(GridFeature feature, String memberName, LineString transectDomain, String copyrightStatement, boolean hasVerticalAxis) {
        JFreeChart chart;
        XYPlot plot;
        if (!Number.class.isAssignableFrom(feature.getCoverage().getScalarMetadata(memberName).getValueType())) {
            throw new IllegalArgumentException("Cannot plot a transect for a non-numerical layer");
        }
        XYSeries series = new XYSeries((Comparable)((Object)"data"), true);
        HorizontalDomain optimalTransectDomain = Charting.getOptimalTransectDomain(feature.getCoverage().getDomain(), transectDomain);
        int k = 0;
        for (HorizontalPosition pos : optimalTransectDomain.getDomainObjects()) {
            series.add((double)k++, (Number)feature.getCoverage().evaluate((Object)pos, memberName));
        }
        XYSeriesCollection xySeriesColl = new XYSeriesCollection();
        xySeriesColl.addSeries(series);
        if (hasVerticalAxis) {
            StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
            NumberAxis rangeAxis1 = new NumberAxis(Charting.getAxisLabel((Feature)feature, memberName));
            plot = new XYPlot((XYDataset)xySeriesColl, (ValueAxis)new NumberAxis(), (ValueAxis)rangeAxis1, (XYItemRenderer)renderer1);
            plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
            plot.setBackgroundPaint((Paint)Color.lightGray);
            plot.setDomainGridlinesVisible(false);
            plot.setRangeGridlinePaint((Paint)Color.white);
            plot.getRenderer().setSeriesPaint(0, (Paint)Color.RED);
            plot.setOrientation(PlotOrientation.VERTICAL);
            chart = new JFreeChart((Plot)plot);
        } else {
            String yLabel = Charting.getAxisLabel((Feature)feature, memberName);
            chart = ChartFactory.createXYLineChart((String)MetadataUtils.getScalarMetadata((Feature)feature, (String)memberName).getTitle(), (String)"distance along transect (arbitrary units)", (String)yLabel, (XYDataset)xySeriesColl, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            plot = chart.getXYPlot();
        }
        if (copyrightStatement != null && !hasVerticalAxis) {
            TextTitle textTitle = new TextTitle(copyrightStatement);
            textTitle.setFont(new Font("SansSerif", 0, 10));
            textTitle.setPosition(RectangleEdge.BOTTOM);
            textTitle.setHorizontalAlignment(HorizontalAlignment.RIGHT);
            chart.addSubtitle((Title)textTitle);
        }
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        plot.setNoDataMessage("There is no data for what you have chosen.");
        Double prevCtrlPointDistance = null;
        for (int i = 0; i < transectDomain.getControlPoints().size(); ++i) {
            double ctrlPointDistance = transectDomain.getFractionalControlPointDistance(i);
            if (prevCtrlPointDistance != null) {
                int size = optimalTransectDomain.getDomainObjects().size();
                IntervalMarker target = new IntervalMarker((double)size * prevCtrlPointDistance, (double)size * ctrlPointDistance);
                target.setLabel("[" + Charting.printTwoDecimals(((HorizontalPosition)transectDomain.getControlPoints().get(i - 1)).getY()) + "," + Charting.printTwoDecimals(((HorizontalPosition)transectDomain.getControlPoints().get(i - 1)).getX()) + "]");
                target.setLabelFont(new Font("SansSerif", 2, 11));
                if (i % 2 == 0) {
                    target.setPaint((Paint)new Color(222, 222, 255, 128));
                    target.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                    target.setLabelTextAnchor(TextAnchor.TOP_LEFT);
                } else {
                    target.setPaint((Paint)new Color(233, 225, 146, 128));
                    target.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
                    target.setLabelTextAnchor(TextAnchor.BOTTOM_LEFT);
                }
                plot.addDomainMarker((Marker)target);
            }
            prevCtrlPointDistance = transectDomain.getFractionalControlPointDistance(i);
        }
        return chart;
    }

    public static HorizontalDomain getOptimalTransectDomain(HorizontalGrid hGrid, LineString transect) {
        int numTransectPoints = 500;
        int lastNumUniqueGridPointsSampled = -1;
        HorizontalDomain pointList = null;
        while (true) {
            List points = transect.getPointsOnPath(numTransectPoints);
            HorizontalDomain testPointList = new HorizontalDomain(points);
            HashSet<GridCell2D> gridCoords = new HashSet<GridCell2D>();
            for (HorizontalPosition pos : testPointList.getDomainObjects()) {
                GridCell2D gridCoord = hGrid.findContainingCell(pos);
                if (gridCoord == null) continue;
                gridCoords.add(hGrid.findContainingCell(pos));
            }
            int numUniqueGridPointsSampled = gridCoords.size();
            if (!((double)numUniqueGridPointsSampled > (double)lastNumUniqueGridPointsSampled * 1.1)) break;
            lastNumUniqueGridPointsSampled = numUniqueGridPointsSampled;
            numTransectPoints += 500;
            pointList = testPointList;
        }
        return pointList;
    }

    private static String printTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        DecimalFormatSymbols decSym = DecimalFormatSymbols.getInstance(US_LOCALE);
        twoDForm.setDecimalFormatSymbols(decSym);
        return twoDForm.format(d);
    }

    private static ZAxisAndValues getZAxisAndValues(List<Double> elevationValues, VerticalCrs vCrs) {
        boolean invertYAxis;
        String zAxisLabel;
        if (vCrs.getPositiveDirection() == VerticalCrs.PositiveDirection.UP) {
            zAxisLabel = "Height";
            invertYAxis = false;
        } else if (vCrs.isPressure()) {
            zAxisLabel = "Pressure";
            invertYAxis = true;
        } else {
            zAxisLabel = "Depth";
            invertYAxis = true;
        }
        NumberAxis zAxis = new NumberAxis(zAxisLabel + " (" + vCrs.getUnits().getUnitString() + ")");
        zAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        zAxis.setInverted(invertYAxis);
        return new ZAxisAndValues(zAxis, elevationValues);
    }

    public static JFreeChart createVerticalSectionChart(GridSeriesFeature feature, String memberName, LineString horizPath, Extent<Float> colourScaleRange, ColorPalette palette, int numColourBands, boolean logarithmic, VerticalPosition zValue, TimePosition time) {
        if (feature.getCoverage().getDomain().getVerticalAxis() == null) {
            throw new IllegalArgumentException("Cannot create a vertical section chart from a feature with no vertical axis");
        }
        if (!Number.class.isAssignableFrom(feature.getCoverage().getScalarMetadata(memberName).getValueType())) {
            throw new IllegalArgumentException("Cannot create a vertical section chart from a non-numeric field");
        }
        VerticalAxis vAxis = feature.getCoverage().getDomain().getVerticalAxis();
        ZAxisAndValues zAxisAndValues = Charting.getZAxisAndValues(vAxis.getCoordinateValues(), vAxis.getVerticalCrs());
        List elevationValues = zAxisAndValues.zValues;
        double minElValue = 0.0;
        double maxElValue = 1.0;
        ArrayList<List<Number>> sectionData = new ArrayList<List<Number>>();
        HorizontalDomain optimalTransectDomain = Charting.getOptimalTransectDomain(feature.getCoverage().getDomain().getHorizontalGrid(), horizPath);
        List controlPoints = optimalTransectDomain.getDomainObjects();
        for (HorizontalPosition pos : controlPoints) {
            List values = feature.extractProfileFeature(pos, time, CollectionUtils.setOf((Object[])new String[]{memberName})).getCoverage().getValues(memberName);
            sectionData.add(values);
        }
        if (elevationValues.size() > 0 && controlPoints.size() > 0) {
            minElValue = (Double)elevationValues.get(0);
            maxElValue = (Double)elevationValues.get(elevationValues.size() - 1);
        }
        if (minElValue > maxElValue) {
            double temp = minElValue;
            minElValue = maxElValue;
            maxElValue = temp;
        }
        int numElValues = 300;
        VerticalSectionDataset dataset = new VerticalSectionDataset(elevationValues, sectionData, minElValue, maxElValue, numElValues);
        NumberAxis xAxis = new NumberAxis("Distance along path (arbitrary units)");
        xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        PaintScale scale = Charting.createPaintScale(palette, colourScaleRange, numColourBands, logarithmic);
        NumberAxis colorScaleBar = new NumberAxis();
        Range colorBarRange = new Range((double)((Float)colourScaleRange.getLow()).floatValue(), (double)((Float)colourScaleRange.getHigh()).floatValue());
        colorScaleBar.setRange(colorBarRange);
        PaintScaleLegend paintScaleLegend = new PaintScaleLegend(scale, (ValueAxis)colorScaleBar);
        paintScaleLegend.setPosition(RectangleEdge.BOTTOM);
        XYBlockRenderer renderer = new XYBlockRenderer();
        double elevationResolution = (maxElValue - minElValue) / (double)numElValues;
        renderer.setBlockHeight(elevationResolution);
        renderer.setPaintScale(scale);
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)zAxisAndValues.zAxis, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinePaint((Paint)Color.white);
        Double prevCtrlPointDistance = null;
        int xAxisLength = 0;
        if (sectionData.size() > 0) {
            xAxisLength = sectionData.size();
        }
        for (int i = 0; i < horizPath.getControlPoints().size(); ++i) {
            double ctrlPointDistance = horizPath.getFractionalControlPointDistance(i);
            if (prevCtrlPointDistance != null) {
                IntervalMarker target = new IntervalMarker((double)xAxisLength * prevCtrlPointDistance, (double)xAxisLength * ctrlPointDistance);
                target.setPaint((Paint)TRANSPARENT);
                plot.addDomainMarker((Marker)target);
                ValueMarker verticalLevel = new ValueMarker(Math.abs(zValue.getZ()));
                verticalLevel.setPaint((Paint)Color.lightGray);
                verticalLevel.setLabel("at " + zValue + "  level ");
                verticalLevel.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
                verticalLevel.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
                plot.addRangeMarker((Marker)verticalLevel);
            }
            prevCtrlPointDistance = horizPath.getFractionalControlPointDistance(i);
        }
        JFreeChart chart = new JFreeChart(feature.getName() + " (" + feature.getCoverage().getScalarMetadata(memberName).getUnits().getUnitString() + ")", (Plot)plot);
        chart.removeLegend();
        chart.addSubtitle((Title)paintScaleLegend);
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    public static PaintScale createPaintScale(ColorPalette colorPalette, final Extent<Float> colourScaleRange, final int numColourBands, final boolean logarithmic) {
        final IndexColorModel cm = colorPalette.getColorModel(numColourBands, 100);
        return new PaintScale(){

            public double getLowerBound() {
                return ((Float)colourScaleRange.getLow()).floatValue();
            }

            public double getUpperBound() {
                return ((Float)colourScaleRange.getHigh()).floatValue();
            }

            public Color getPaint(double value) {
                int index = this.getColourIndex(value);
                return new Color(cm.getRGB(index));
            }

            private int getColourIndex(double value) {
                double max;
                double min;
                if (Double.isNaN(value)) {
                    return numColourBands;
                }
                if (value < this.getLowerBound() || value > this.getUpperBound()) {
                    return numColourBands + 1;
                }
                double val = logarithmic ? Math.log(value) : value;
                double frac = (val - (min = logarithmic ? Math.log(this.getLowerBound()) : this.getLowerBound())) / ((max = logarithmic ? Math.log(this.getUpperBound()) : this.getUpperBound()) - min);
                int index = (int)(frac * (double)numColourBands);
                if (index == numColourBands) {
                    --index;
                }
                return index;
            }
        };
    }

    private static class VerticalSectionDataset
    extends AbstractXYZDataset {
        private static final long serialVersionUID = 1L;
        private final int horizPathLength;
        private final List<List<Number>> sectionData;
        private final List<Double> elevationValues;
        private final double minElValue;
        private final double elevationResolution;
        private final int numElevations;

        public VerticalSectionDataset(List<Double> elevationValues, List<List<Number>> sectionData, double minElValue, double maxElValue, int numElevations) {
            this.horizPathLength = sectionData.size() > 0 ? sectionData.size() : 0;
            this.sectionData = sectionData;
            this.elevationValues = elevationValues;
            this.minElValue = minElValue;
            this.numElevations = numElevations;
            this.elevationResolution = (maxElValue - minElValue) / (double)numElevations;
        }

        public int getSeriesCount() {
            return 1;
        }

        public String getSeriesKey(int series) {
            VerticalSectionDataset.checkSeries(series);
            return "Vertical section";
        }

        public int getItemCount(int series) {
            VerticalSectionDataset.checkSeries(series);
            return this.horizPathLength * this.numElevations;
        }

        public Integer getX(int series, int item) {
            VerticalSectionDataset.checkSeries(series);
            return item % this.horizPathLength;
        }

        public Double getY(int series, int item) {
            VerticalSectionDataset.checkSeries(series);
            int yIndex = item / this.horizPathLength;
            return this.minElValue + (double)yIndex * this.elevationResolution;
        }

        public Float getZ(int series, int item) {
            VerticalSectionDataset.checkSeries(series);
            int xIndex = item % this.horizPathLength;
            double elevation = this.getY(series, item);
            int nearestElevationIndex = -1;
            double minDiff = Double.MAX_VALUE;
            for (int i = 0; i < this.elevationValues.size(); ++i) {
                double el = this.elevationValues.get(i);
                double diff = Math.abs(el - elevation);
                if (!(diff < minDiff)) continue;
                minDiff = diff;
                nearestElevationIndex = i;
            }
            return Float.valueOf(this.sectionData.get(xIndex).get(nearestElevationIndex).floatValue());
        }

        private static void checkSeries(int series) {
            if (series != 0) {
                throw new IllegalArgumentException("Series must be zero");
            }
        }
    }

    private static final class ZAxisAndValues {
        private final NumberAxis zAxis;
        private final List<Double> zValues;

        public ZAxisAndValues(NumberAxis zAxis, List<Double> zValues) {
            this.zAxis = zAxis;
            this.zValues = zValues;
        }
    }
}

