/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import top.ibase4j.core.support.fastdfs.FileManager;
import top.ibase4j.core.support.fastdfs.FileModel;
import top.ibase4j.core.support.ftp.SftpClient;
import top.ibase4j.core.util.ImageUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;
import top.ibase4j.model.FileInfo;

public final class UploadUtil {
    private static final Logger logger = LogManager.getLogger();
    private static int fileSizeThreshold = 0x100000;
    private static final String uploadFileDir = "/WEB-INF/upload/";

    private UploadUtil() {
    }

    public static final List<?> getFileItemList(HttpServletRequest request, File saveDir) throws FileUploadException {
        if (!saveDir.isDirectory()) {
            saveDir.mkdir();
        }
        List fileItems = null;
        ServletRequestContext requestContext = new ServletRequestContext(request);
        if (FileUpload.isMultipartContent((RequestContext)requestContext)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setRepository(saveDir);
            factory.setSizeThreshold(fileSizeThreshold);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            fileItems = upload.parseRequest(request);
        }
        return fileItems;
    }

    public static final FileItem[] getFileItem(HttpServletRequest request, File saveDir, String ... fieldName) throws FileUploadException {
        if (fieldName == null || saveDir == null) {
            return null;
        }
        List<FileItem> fileItemList = UploadUtil.getFileItemList(request, saveDir);
        FileItem fileItem22 = null;
        FileItem[] fileItems = new FileItem[fieldName.length];
        block0: for (int i = 0; i < fieldName.length; ++i) {
            for (FileItem fileItem22 : fileItemList) {
                if (fieldName[i] == null || !fieldName[i].equals(fileItem22.getFieldName())) continue;
                fileItems[i] = fileItem22;
                continue block0;
            }
        }
        return fileItems;
    }

    public static List<String> uploadFile(HttpServletRequest request) {
        ArrayList<String> fileNames = InstanceUtil.newArrayList();
        List<FileInfo> files = UploadUtil.uploadFiles(request);
        for (FileInfo fileInfo : files) {
            fileNames.add(fileInfo.getFileName());
        }
        return fileNames;
    }

    public static List<FileInfo> uploadFiles(HttpServletRequest request) {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<FileInfo> fileNames = InstanceUtil.newArrayList();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            String pathDir = UploadUtil.getUploadDir(request);
            File dirFile = new File(pathDir);
            if (!dirFile.isDirectory()) {
                dirFile.mkdirs();
            }
            Iterator iterator = multiRequest.getFileNames();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                MultipartFile multipartFile = multiRequest.getFile(key);
                if (multipartFile == null) continue;
                FileInfo fileInfo = new FileInfo();
                String name = multipartFile.getOriginalFilename();
                fileInfo.setOrgName(name);
                if (name.indexOf(".") == -1 && "blob".equals(name)) {
                    name = name + ".png";
                }
                String uuid = UUID.randomUUID().toString();
                String postFix = name.substring(name.lastIndexOf(".")).toLowerCase();
                String fileName = uuid + postFix;
                String filePath = pathDir + File.separator + fileName;
                File file = new File(filePath);
                file.setWritable(true, false);
                fileInfo.setFileSize(multipartFile.getSize());
                try {
                    multipartFile.transferTo(file);
                    fileInfo.setFileName(fileName);
                    fileNames.add(fileInfo);
                }
                catch (Exception e) {
                    logger.error(name + "\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return fileNames;
    }

    public static List<String> uploadImage(HttpServletRequest request, boolean lessen) {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> fileNames = InstanceUtil.newArrayList();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            String pathDir = UploadUtil.getUploadDir(request);
            File dirFile = new File(pathDir);
            if (!dirFile.isDirectory()) {
                dirFile.mkdirs();
            }
            Iterator iterator = multiRequest.getFileNames();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                MultipartFile multipartFile = multiRequest.getFile(key);
                if (multipartFile == null) continue;
                String name = multipartFile.getOriginalFilename();
                if (name.indexOf(".") == -1 && "blob".equals(name)) {
                    name = name + ".png";
                }
                String uuid = UUID.randomUUID().toString();
                String postFix = name.substring(name.lastIndexOf(".")).toLowerCase();
                String fileName = uuid + postFix;
                String filePath = pathDir + File.separator + fileName;
                File file = new File(filePath);
                file.setWritable(true, false);
                try {
                    multipartFile.transferTo(file);
                    fileNames.add(fileName);
                }
                catch (Exception e) {
                    logger.error(name + "\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                }
                if (!lessen) continue;
                try {
                    BufferedImage bufferedImg = ImageIO.read(file);
                    int orgwidth = bufferedImg.getWidth();
                    ImageUtil.scaleWidth(file, 100);
                    if (orgwidth > 300) {
                        ImageUtil.scaleWidth(file, 300);
                    }
                    if (orgwidth <= 500) continue;
                    ImageUtil.scaleWidth(file, 500);
                }
                catch (Exception e) {
                    logger.error(name + "\u7f29\u653e\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return fileNames;
    }

    public static List<String> uploadImageData(HttpServletRequest request) {
        ArrayList<String> fileNames = InstanceUtil.newArrayList();
        Enumeration params = request.getParameterNames();
        String pathDir = UploadUtil.getUploadDir(request);
        File dir = new File(pathDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        while (params.hasMoreElements()) {
            int index;
            String key = (String)params.nextElement();
            String fileStr = request.getParameter(key);
            if (fileStr == null || "".equals(fileStr) || (index = fileStr.indexOf("base64")) <= 0) continue;
            try {
                String fileName = UUID.randomUUID().toString();
                String preStr = fileStr.substring(0, index + 7);
                String prefix = preStr.substring(preStr.indexOf("/") + 1, preStr.indexOf(";")).toLowerCase();
                fileStr = fileStr.substring(fileStr.indexOf(",") + 1);
                byte[] bb = Base64.getDecoder().decode(fileStr);
                for (int j = 0; j < bb.length; ++j) {
                    if (bb[j] >= 0) continue;
                    int n = j;
                    bb[n] = (byte)(bb[n] + 256);
                }
                String distPath = pathDir + fileName + "." + prefix;
                FileOutputStream out = new FileOutputStream(distPath);
                ((OutputStream)out).write(bb);
                out.flush();
                ((OutputStream)out).close();
                fileNames.add(fileName + "." + prefix);
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return fileNames;
    }

    public static String getUploadDir(HttpServletRequest request) {
        return request.getServletContext().getRealPath(uploadFileDir) + File.separator;
    }

    public static FileModel remove2DFS(String namespace, String objectId, String fileName) {
        FileModel fastDFSFile = new FileModel(namespace, objectId, fileName);
        if (fastDFSFile.getKey() != null) {
            FileManager.getInstance().upload(fastDFSFile);
        }
        return fastDFSFile;
    }

    public static String remove2Sftp(String filePath, String namespace) {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new RuntimeException("\u6587\u4ef6" + filePath + "\u4e0d\u5b58\u5728");
        }
        SftpClient client = SftpClient.connect();
        String dir = PropertiesUtil.getString("sftp.baseDir");
        String fileName = namespace + File.separator + file.getName();
        client.put(filePath, dir + fileName);
        client.disconnect();
        return PropertiesUtil.getString("sftp.nginx.path") + fileName;
    }
}

