/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class IDCardUtil {
    public static final int MAX_MAINLAND_AREACODE = 659004;
    public static final int MIN_MAINLAND_AREACODE = 110000;
    public static final int HONGKONG_AREACODE = 810000;
    public static final int TAIWAN_AREACODE = 710000;
    public static final int MACAO_AREACODE = 820000;
    public static final String regexNum = "^[0-9]*$";
    public static final String regexBirthdayInLeapYear = "^((19[0-9]{2})|(200[0-9])|(201[0-5]))((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))$";
    public static final String regexBirthdayInCommonYear = "^((19[0-9]{2})|(200[0-9])|(201[0-5]))((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))$";
    private static final Set<String> BLACK_SET = new HashSet<String>(){
        {
            this.add("111111111111111");
        }
    };
    static final char[] code = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    static final int[] factor = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};

    private IDCardUtil() {
    }

    public static final boolean isIdentity(String idNumber) {
        if (StringUtils.isBlank((CharSequence)idNumber)) {
            return false;
        }
        if (BLACK_SET.contains(idNumber = idNumber.trim())) {
            return false;
        }
        if (!IDCardUtil.checkIdNumberRegex(idNumber)) {
            return false;
        }
        if (!IDCardUtil.checkIdNumberArea(idNumber.substring(0, 6))) {
            return false;
        }
        if (!IDCardUtil.checkBirthday((idNumber = IDCardUtil.convertFifteenToEighteen(idNumber)).substring(6, 14))) {
            return false;
        }
        return IDCardUtil.checkIdNumberVerifyCode(idNumber);
    }

    public static final Timestamp getBirthdayFromPersonIDCode(String identity) throws Throwable {
        String id = IDCardUtil.getIDCode(identity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            Timestamp birthday = new Timestamp(sdf.parse(id.substring(6, 14)).getTime());
            return birthday;
        }
        catch (ParseException e) {
            throw new RuntimeException("\u4e0d\u662f\u6709\u6548\u7684\u8eab\u4efd\u8bc1\u53f7\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    public static final String getIDCode(String idCode) throws Throwable {
        if (idCode == null) {
            throw new RuntimeException("\u8f93\u5165\u7684\u8eab\u4efd\u8bc1\u53f7\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5");
        }
        if (idCode.length() == 18) {
            if (IDCardUtil.isIdentity(idCode)) {
                return idCode;
            }
            throw new RuntimeException("\u8f93\u5165\u7684\u8eab\u4efd\u8bc1\u53f7\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5");
        }
        if (idCode.length() == 15) {
            return IDCardUtil.convertFifteenToEighteen(idCode);
        }
        throw new RuntimeException("\u8f93\u5165\u7684\u8eab\u4efd\u8bc1\u53f7\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5");
    }

    public static final Sex getGenderFromPersonIDCode(String identity) throws Throwable {
        String id = IDCardUtil.getIDCode(identity);
        char sex = id.charAt(16);
        return sex % 2 == 0 ? Sex.Female : Sex.Male;
    }

    private static boolean checkIdNumberRegex(String idNumber) {
        return Pattern.matches("^([0-9]{17}[0-9Xx])|([0-9]{15})$", idNumber);
    }

    private static boolean checkIdNumberArea(String idNumberArea) {
        int areaCode = Integer.parseInt(idNumberArea);
        if (areaCode == 810000 || areaCode == 820000 || areaCode == 710000) {
            return true;
        }
        return areaCode <= 659004 && areaCode >= 110000;
    }

    private static String convertFifteenToEighteen(String idNumber) {
        if (15 != idNumber.length()) {
            return idNumber;
        }
        idNumber = idNumber.substring(0, 6) + "19" + idNumber.substring(6, 15);
        idNumber = idNumber + IDCardUtil.getVerifyCode(idNumber);
        return idNumber;
    }

    private static String getVerifyCode(String idNumber) {
        if (!Pattern.matches(regexNum, idNumber.substring(0, 17))) {
            return null;
        }
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += Integer.parseInt(String.valueOf(idNumber.charAt(i))) * factor[i];
        }
        return String.valueOf(code[sum % 11]);
    }

    private static boolean checkBirthday(String idNumberBirthdayStr) {
        Integer year = null;
        try {
            year = Integer.valueOf(idNumberBirthdayStr.substring(0, 4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == year) {
            return false;
        }
        if (IDCardUtil.isLeapYear(year)) {
            return Pattern.matches(regexBirthdayInLeapYear, idNumberBirthdayStr);
        }
        return Pattern.matches(regexBirthdayInCommonYear, idNumberBirthdayStr);
    }

    private static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
    }

    private static boolean checkIdNumberVerifyCode(String idNumber) {
        return IDCardUtil.getVerifyCode(idNumber).equalsIgnoreCase(idNumber.substring(17));
    }

    public static void main(String[] args) throws Throwable {
        System.out.println((Object)IDCardUtil.getGenderFromPersonIDCode("11010519491231002X"));
        System.out.println(IDCardUtil.isIdentity("530626199109261396"));
    }

    public static enum Sex {
        Other("\u672a\u77e5", 0),
        Male("\u7537", 1),
        Female("\u5973", 2);

        private String name;
        private Integer value;

        private Sex(String name, Integer value) {
            this.name = name;
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }
}

