/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.support.pay.AliPayConfig;
import top.ibase4j.core.support.pay.vo.RefundResult;
import top.ibase4j.core.util.DateUtil;

public class AlipayUtil {
    private static final Logger logger = LogManager.getLogger(AlipayUtil.class);

    public static String getSign(String out_trade_no, String subject, String body, BigDecimal amount, String ip, String timeout, String callBack) {
        AlipayClient alipayClient = AliPayConfig.build().getAlipayClient();
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setSubject(subject);
        model.setBody(body);
        model.setOutTradeNo(out_trade_no);
        model.setTimeoutExpress(timeout);
        model.setTotalAmount(amount.toString());
        model.setProductCode("QUICK_MSECURITY_PAY");
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(callBack);
        try {
            AlipayTradeAppPayResponse response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
            logger.info(response.getBody());
            if (!response.isSuccess()) {
                throw new RuntimeException(response.getSubMsg());
            }
            return response.getBody();
        }
        catch (AlipayApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static RefundResult refund(String outTradeNo, String tradeNo, BigDecimal refundAmount, String refundReason) {
        AlipayClient alipayClient = AliPayConfig.build().getAlipayClient();
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setOutTradeNo(outTradeNo);
        model.setTradeNo(tradeNo);
        model.setRefundAmount(refundAmount.toString());
        model.setRefundReason(refundReason);
        request.setBizModel((AlipayObject)model);
        try {
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            logger.info(response.getBody());
            if (!response.isSuccess()) {
                throw new RuntimeException(response.getSubMsg());
            }
            Map body = (Map)JSON.parseObject((String)response.getBody(), Map.class);
            JSONObject result = JSON.parseObject((String)body.get("alipay_trade_refund_response").toString());
            return new RefundResult((String)result.get("trade_no"), outTradeNo, refundAmount.toString(), DateUtil.stringToDate((String)result.get("gmt_refund_pay")), "Y".equals(result.get("fund_change")) ? "1" : "2");
        }
        catch (AlipayApiException e) {
            throw new RuntimeException(e);
        }
    }
}

