/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.cache.shiro;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import top.ibase4j.core.support.cache.shiro.RedisCache;

public class RedisCacheManager
implements CacheManager {
    private final Logger logger = LogManager.getLogger();
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private String keyPrefix = "iBase4J:shiro_redis_cache:";

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        this.logger.debug("\u83b7\u53d6\u540d\u79f0\u4e3a: " + name + " \u7684RedisCache\u5b9e\u4f8b");
        Cache c = (Cache)this.caches.get(name);
        if (c == null) {
            RedisCache cache = new RedisCache(this.keyPrefix);
            this.caches.put(name, cache);
        }
        return c;
    }
}

