/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.listener;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class SessionListener
implements HttpSessionListener {
    private Logger logger = LogManager.getLogger();
    @Autowired
    RedisTemplate redisTemplate;

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        session.setAttribute("webTheme", (Object)"default");
        this.logger.info("\u521b\u5efa\u4e86\u4e00\u4e2aSession\u8fde\u63a5:[" + session.getId() + "]");
        this.redisTemplate.opsForSet().add((Object)"SYSTEM:iBase4J:ALLUSER_NUMBER", new Object[]{session.getId()});
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        if (this.getAllUserNumber() > 0) {
            this.logger.info("\u9500\u6bc1\u4e86\u4e00\u4e2aSession\u8fde\u63a5:[" + session.getId() + "]");
        }
        session.removeAttribute("CURRENT_USER");
        this.redisTemplate.opsForSet().remove((Object)"SYSTEM:iBase4J:ALLUSER_NUMBER", new Object[]{session.getId()});
    }

    public Integer getAllUserNumber() {
        return this.redisTemplate.opsForSet().size((Object)"SYSTEM:iBase4J:ALLUSER_NUMBER").intValue();
    }
}

