/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.util.FileUtil;

public class XssFilter
implements Filter {
    private Logger logger = LogManager.getLogger();
    private List<String> excludeUrls = new ArrayList<String>();
    private List<String> noticeUrls = new ArrayList<String>();

    public void init(FilterConfig filterconfig1) throws ServletException {
        String path = XssFilter.class.getResource("/").getFile();
        this.excludeUrls = FileUtil.readFile(path + "white/xssWhite.txt");
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain arg2) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)arg0;
        HttpServletResponse response = (HttpServletResponse)arg1;
        String pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        String url = req.getServletPath() + pathInfo;
        String uri = req.getRequestURI();
        boolean isNoticeUrl = false;
        for (String str : this.excludeUrls) {
            if (uri.indexOf(str) < 0) continue;
            this.logger.info("\u8be5URL\u4e0d\u4f5c\u6821\u9a8c\uff1a" + url);
            arg2.doFilter((ServletRequest)req, (ServletResponse)response);
            return;
        }
        for (String st : this.noticeUrls) {
            if (uri.indexOf(st) < 0) continue;
            isNoticeUrl = true;
            break;
        }
        Enumeration params = req.getParameterNames();
        String paramN = null;
        while (params.hasMoreElements()) {
            paramN = (String)params.nextElement();
            String paramVale = req.getParameter(paramN);
            if (!paramN.toLowerCase().contains("password")) {
                this.logger.info(paramN + "==" + paramVale);
            }
            if (isNoticeUrl) {
                paramVale = this.xssEncode(paramVale);
            }
            if (!this.checkSQLInject(paramVale, url)) continue;
            this.errorResponse(response, paramN);
            return;
        }
        arg2.doFilter((ServletRequest)req, (ServletResponse)response);
    }

    private void errorResponse(HttpServletResponse response, String paramNm) throws IOException {
        String warning = "\u8f93\u5165\u9879\u4e2d\u4e0d\u80fd\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002";
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("{\"code\":\"-9998\",\"msg\":\"" + warning + "\", \"fieldName\": \"" + paramNm + "\"}");
        out.flush();
        out.close();
    }

    public void destroy() {
    }

    private String xssEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block11: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    continue block11;
                }
                case '<': {
                    sb.append('\uff1c');
                    continue block11;
                }
                case '\'': {
                    sb.append('\u2018');
                    continue block11;
                }
                case '\"': {
                    sb.append('\u201c');
                    continue block11;
                }
                case '&': {
                    sb.append('\uff06');
                    continue block11;
                }
                case '\\': {
                    sb.append('\uff3c');
                    continue block11;
                }
                case '#': {
                    sb.append('\uff03');
                    continue block11;
                }
                case '(': {
                    sb.append('\uff08');
                    continue block11;
                }
                case ')': {
                    sb.append('\uff09');
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private boolean checkSQLInject(String str, String url) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        String[] inj_stra = new String[]{"script", "mid", "master", "truncate", "insert", "select", "delete", "update", "declare", "iframe", "'", "onreadystatechange", "alert", "atestu", "xss", ";", "'", "\"", "<", ">", "(", ")", ",", "\\", "svg", "confirm", "prompt", "onload", "onmouseover", "onfocus", "onerror"};
        str = str.toLowerCase();
        for (int i = 0; i < inj_stra.length; ++i) {
            if (str.indexOf(inj_stra[i]) < 0) continue;
            this.logger.info("xss\u9632\u653b\u51fb\u62e6\u622aurl:" + url + "\uff0c\u539f\u56e0\uff1a\u7279\u6b8a\u5b57\u7b26\uff0c\u4f20\u5165str=" + str + ",\u5305\u542b\u7279\u6b8a\u5b57\u7b26\uff1a" + inj_stra[i]);
            return true;
        }
        return false;
    }
}

