/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.config;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
public class RedisCacheConfig
extends CachingConfigurerSupport {
    String prefix = "iBase4J:M:";

    @Bean
    public KeyGenerator keyGenerator() {
        return new KeyGenerator(){

            public Object generate(Object o, Method method, Object ... objects) {
                Object[] cacheNames;
                StringBuilder sb = new StringBuilder(RedisCacheConfig.this.prefix);
                CacheConfig cacheConfig = o.getClass().getAnnotation(CacheConfig.class);
                Cacheable cacheable = method.getAnnotation(Cacheable.class);
                CachePut cachePut = method.getAnnotation(CachePut.class);
                CacheEvict cacheEvict = method.getAnnotation(CacheEvict.class);
                if (cacheable != null) {
                    cacheNames = cacheable.value();
                    if (ArrayUtils.isNotEmpty((Object[])cacheNames)) {
                        sb.append((String)cacheNames[0]);
                    }
                } else if (cachePut != null) {
                    cacheNames = cachePut.value();
                    if (ArrayUtils.isNotEmpty((Object[])cacheNames)) {
                        sb.append((String)cacheNames[0]);
                    }
                } else if (cacheEvict != null && ArrayUtils.isNotEmpty((Object[])(cacheNames = cacheEvict.value()))) {
                    sb.append((String)cacheNames[0]);
                }
                if (cacheConfig != null && sb.toString().equals(RedisCacheConfig.this.prefix) && ArrayUtils.isNotEmpty((Object[])(cacheNames = cacheConfig.cacheNames()))) {
                    sb.append((String)cacheNames[0]);
                }
                if (sb.toString().equals(RedisCacheConfig.this.prefix)) {
                    sb.append(o.getClass().getName()).append(".").append(method.getName());
                }
                sb.append(":");
                if (objects != null) {
                    for (Object object : objects) {
                        sb.append(JSON.toJSONString((Object)object));
                    }
                }
                return sb.toString();
            }
        };
    }
}

