/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.config;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;
import top.ibase4j.core.support.cache.RedisHelper;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;

@Configuration
public class JedisConfig {
    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMinIdle(PropertiesUtil.getInt("redis.minIdle").intValue());
        config.setMaxIdle(PropertiesUtil.getInt("redis.maxIdle").intValue());
        config.setMaxTotal(PropertiesUtil.getInt("redis.maxTotal").intValue());
        config.setMaxWaitMillis((long)PropertiesUtil.getInt("redis.maxWaitMillis").intValue());
        config.setTestOnBorrow(Boolean.valueOf(PropertiesUtil.getString("redis.testOnBorrow")).booleanValue());
        return config;
    }

    @Bean
    public JedisConnectionFactory jedisConnectionFactory(JedisPoolConfig jedisPoolConfig) {
        JedisConnectionFactory jedisConnectionFactory;
        String nodes = PropertiesUtil.getString("redis.cluster.nodes");
        if (StringUtils.isNotBlank((CharSequence)nodes)) {
            ArrayList<String> list = InstanceUtil.newArrayList(nodes.split(","));
            RedisClusterConfiguration configuration = new RedisClusterConfiguration(list);
            configuration.setMaxRedirects(PropertiesUtil.getInt("redis.cluster.max-redirects").intValue());
            jedisConnectionFactory = new JedisConnectionFactory(configuration, jedisPoolConfig);
            jedisConnectionFactory.setPassword(PropertiesUtil.getString("redis.password"));
        } else {
            jedisConnectionFactory = new JedisConnectionFactory(jedisPoolConfig);
            jedisConnectionFactory.setHostName(PropertiesUtil.getString("redis.host"));
            jedisConnectionFactory.setPort(PropertiesUtil.getInt("redis.port").intValue());
            jedisConnectionFactory.setPassword(PropertiesUtil.getString("redis.password"));
        }
        jedisConnectionFactory.setTimeout(PropertiesUtil.getInt("redis.timeout").intValue());
        return jedisConnectionFactory;
    }

    @Bean
    public RedisTemplate<?, ?> redisTemplate(JedisConnectionFactory jedisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        GenericJackson2JsonRedisSerializer valueSerializer = new GenericJackson2JsonRedisSerializer();
        redisTemplate.setEnableTransactionSupport(new Boolean(PropertiesUtil.getString("redis.enableTransaction")).booleanValue());
        redisTemplate.setConnectionFactory((RedisConnectionFactory)jedisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)keySerializer);
        redisTemplate.setValueSerializer((RedisSerializer)valueSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)keySerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)valueSerializer);
        return redisTemplate;
    }

    @Bean
    @Qualifier(value="redisTemplate")
    public RedisHelper redisHelper(RedisTemplate<Serializable, Serializable> redisTemplate) {
        RedisHelper redisHelper = new RedisHelper();
        redisHelper.setRedisTemplate(redisTemplate);
        return redisHelper;
    }

    @Bean
    @Qualifier(value="redisTemplate")
    public CacheManager redisCacheManager(RedisTemplate<Serializable, Serializable> redisTemplate) {
        RedisCacheManager cacheManager = new RedisCacheManager(redisTemplate);
        cacheManager.setTransactionAware(true);
        cacheManager.setDefaultExpiration((long)PropertiesUtil.getInt("redis.expiration", 10));
        return cacheManager;
    }
}

