/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;
import top.ibase4j.core.util.SecurityUtil;

@Configuration
public class Configs
implements EnvironmentPostProcessor,
Ordered {
    protected Logger logger = LogManager.getLogger();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        try {
            Properties props = this.getConfig(environment);
            for (Object key : props.keySet()) {
                String keyStr = key.toString();
                String value = props.getProperty(keyStr);
                if ("druid.writer.password,druid.reader.password".contains(keyStr)) {
                    value = SecurityUtil.decryptDes(value, props.getProperty("druid.key", "90139119").getBytes());
                    props.setProperty(keyStr, value);
                }
                PropertiesUtil.getProperties().put(keyStr, value);
            }
            propertySources.addLast((PropertySource)new PropertiesPropertySource("thirdEnv", props));
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    public int getOrder() {
        return -2147483637;
    }

    public Properties getConfig(ConfigurableEnvironment env) throws IOException {
        PropertiesFactoryBean config = new PropertiesFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> resouceList = InstanceUtil.newArrayList();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("classpath*:config/*.properties")) {
                resouceList.add(resource);
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        config.setLocations(resouceList.toArray(new Resource[0]));
        config.afterPropertiesSet();
        return config.getObject();
    }

    public static void main(String[] args) {
        String encrypt = SecurityUtil.encryptDes("buzhidao", "90139119".getBytes());
        System.out.println(encrypt);
        System.out.println(SecurityUtil.decryptDes(encrypt, "90139119".getBytes()));
    }
}

