/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdht;

import java.util.Arrays;
import java.util.Hashtable;
import org.csource.fastdht.ClientGlobal;
import org.csource.fastdht.FastDHTClient;
import org.csource.fastdht.ObjectInfo;

public class TestBatch {
    private TestBatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java org.csource.fastdht.TestBatch <config filename>");
            return;
        }
        System.out.println("java.version=" + System.getProperty("java.version"));
        String conf_filename = args[0];
        try {
            ClientGlobal.init(conf_filename);
            System.out.println("network_timeout=" + ClientGlobal.g_network_timeout + "ms");
            System.out.println("charset=" + ClientGlobal.g_charset);
            ClientGlobal.g_server_group.print();
            try (FastDHTClient client = new FastDHTClient(true);){
                ObjectInfo objInfo = new ObjectInfo("bbs", "test");
                Hashtable<String, String> keyValues = new Hashtable<String, String>();
                Hashtable failKeys = new Hashtable();
                keyValues.put("reg", "1236939402");
                keyValues.put("login", "happy_fish100");
                keyValues.put("intl", "CN");
                keyValues.put("co", "China");
                String[] keys = new String[]{"reg", "co", "login", "intl"};
                System.out.println("batch set: " + client.batchSet(objInfo, keyValues, failKeys, (int)(System.currentTimeMillis() / 1000L) + 300) + failKeys);
                System.out.println("batch get: " + client.batchGet(objInfo, keys, failKeys, (int)(System.currentTimeMillis() / 1000L) + 30) + failKeys);
                System.out.println("batch delete: " + client.batchDelete(objInfo, keys, failKeys) + failKeys);
                System.out.println("stat: " + client.stat(1));
                System.out.println("after batch delete, sub keys: " + Arrays.toString(client.getSubKeys(objInfo)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

