/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.io.IOException;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.StatsOperation;
import net.spy.memcached.protocol.binary.OperationImpl;

public class StatsOperationImpl
extends OperationImpl
implements StatsOperation {
    private static final byte CMD = 16;
    private final String key;

    public StatsOperationImpl(String arg, StatsOperation.Callback c) {
        super((byte)16, StatsOperationImpl.generateOpaque(), c);
        this.key = arg == null ? "" : arg;
    }

    @Override
    public void initialize() {
        this.prepareBuffer(this.key, 0L, EMPTY_BYTES, new Object[0]);
    }

    @Override
    protected void finishedPayload(byte[] pl) throws IOException {
        if (this.keyLen > 0) {
            byte[] keyBytes = new byte[this.keyLen];
            byte[] data = new byte[pl.length - this.keyLen];
            System.arraycopy(pl, 0, keyBytes, 0, this.keyLen);
            System.arraycopy(pl, this.keyLen, data, 0, pl.length - this.keyLen);
            StatsOperation.Callback cb = (StatsOperation.Callback)this.getCallback();
            cb.gotStat(new String(keyBytes, "UTF-8"), new String(data, "UTF-8"));
        } else {
            this.getCallback().receivedStatus(STATUS_OK);
            this.transitionState(OperationState.COMPLETE);
        }
        this.resetInput();
    }
}

