
function (out) {
	var p = this.parent,
		cnt = this.domContent_();
	out.push('<div', this.domAttrs_(), '>',
		'<div id="', this.uuid, '-cave" class="', this.$s('content'), 
		'">', (cnt ? cnt : this._getBlank()), '</div>'); 
	for (var w = this.firstChild; w; w = w.nextSibling)
		w.redraw(out);
	
	if (p._isDefault && p._isDefault()) {
		out.push('</div>');
		return; 
	}
	
	var puuid = p.uuid,
		picon = p.$s('icon'),
		getIcon = function(iconClass) {
			return '<i class="z-' + iconClass + '"></i>';
		};
	
	if (this._isCloseVisible())
		out.push('<div id="', puuid, '-close" class="', picon, ' ', p.$s('close'),
				'">', getIcon('icon-remove'), '</div>');
	if (this._isMaximizeVisible()) {
		out.push('<div id="', puuid, '-max" class="', picon, ' ', p.$s('maximize'));
		if (p.isMaximized())
			out.push(' ', p.$s('maximized'));
		out.push('">', this._maximized ? 
				getIcon('icon-resize-small') : getIcon('icon-fullscreen'), '</div>');
	}
	if (this._isMinimizeVisible())
		out.push('<div id="', puuid, '-min" class="', picon, ' ', p.$s('minimize'),
				'">', getIcon('icon-minus'), '</div>');
	if (this._isCollapsibleVisible())
		out.push('<div id="', puuid , '-exp" class="', picon, ' ', p.$s('expand'),
				'" >', p._open ? getIcon('icon-caret-up') : getIcon('icon-caret-down'), '</div>');
	
	out.push('</div>');
}