/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.impl.XulElement;

public class Tabbox
extends XulElement {
    private transient Tabs _tabs;
    private transient Toolbar _toolbar;
    private transient Tabpanels _tabpanels;
    private transient Tab _seltab;
    private String _panelSpacing;
    private String _orient = "horizontal";
    private boolean _tabscroll = true;
    transient EventListener<Event> _listener;

    public Tabbox() {
        this.init();
    }

    private void init() {
        this._listener = new Listener();
    }

    boolean inAccordionMold() {
        return this.getMold().startsWith("accordion");
    }

    public Tabs getTabs() {
        return this._tabs;
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public Tabpanels getTabpanels() {
        return this._tabpanels;
    }

    public boolean isTabscroll() {
        return this._tabscroll;
    }

    public void setTabscroll(boolean tabscroll) {
        if (this._tabscroll != tabscroll) {
            this._tabscroll = tabscroll;
            this.smartUpdate("tabscroll", this._tabscroll);
        }
    }

    public String getPanelSpacing() {
        return this._panelSpacing;
    }

    public void setPanelSpacing(String panelSpacing) {
        if (panelSpacing != null && panelSpacing.length() == 0) {
            panelSpacing = null;
        }
        if (!Objects.equals((Object)this._panelSpacing, (Object)panelSpacing)) {
            this._panelSpacing = panelSpacing;
            this.smartUpdate("panelSpacing", this._panelSpacing);
        }
    }

    public int getSelectedIndex() {
        return this._seltab != null ? this._seltab.getIndex() : -1;
    }

    public void setSelectedIndex(int j) {
        Tabs tabs = this.getTabs();
        if (tabs == null) {
            throw new IllegalStateException("No tab at all");
        }
        this.setSelectedTab((Tab)((Object)tabs.getChildren().get(j)));
    }

    public Tabpanel getSelectedPanel() {
        return this._seltab != null ? this._seltab.getLinkedPanel() : null;
    }

    public void setSelectedPanel(Tabpanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException("null tabpanel");
        }
        if (panel.getTabbox() != this) {
            throw new UiException("Not a child: " + (Object)((Object)panel));
        }
        Tab tab = panel.getLinkedTab();
        if (tab != null) {
            this.setSelectedTab(tab);
        }
    }

    public Tab getSelectedTab() {
        return this._seltab;
    }

    public void setSelectedTab(Tab tab) {
        this.selectTabDirectly(tab, false);
    }

    void selectTabDirectly(Tab tab, boolean byClient) {
        if (tab == null) {
            throw new IllegalArgumentException("null tab");
        }
        if (tab.getTabbox() != this) {
            throw new UiException("Not my child: " + (Object)((Object)tab));
        }
        if (tab != this._seltab) {
            if (this._seltab != null) {
                this._seltab.setSelectedDirectly(false);
            }
            this._seltab = tab;
            this._seltab.setSelectedDirectly(true);
            if (!byClient) {
                this.smartUpdate("selectedTab", (Object)this._seltab);
            }
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setMold(String mold) {
        if (this.isVertical()) {
            if (mold.startsWith("accordion")) {
                throw new WrongValueException("Unsupported vertical orient in mold : " + mold);
            }
            super.setMold(mold);
        } else {
            super.setMold(mold);
        }
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!("horizontal".equals(orient) || "vertical".equals(orient) || "vertical-right".equals(orient) || "horizontal-bottom".equals(orient))) {
            throw new WrongValueException("Unknow orient : " + orient);
        }
        if (this.inAccordionMold()) {
            throw new WrongValueException("Unsupported vertical orient in mold : " + this.getMold());
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isHorizontal() {
        return this.getOrient().contains("horizontal");
    }

    public boolean isHorizontalTop() {
        return "horizontal".equals(this.getOrient());
    }

    public boolean isHorizontalBottom() {
        return "horizontal-bottom".equals(this.getOrient());
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public boolean isVerticalLeft() {
        return "vertical".equals(this.getOrient());
    }

    public boolean isVerticalRight() {
        return "vertical-right".equals(this.getOrient());
    }

    public String getZclass() {
        String cls = this._zclass == null ? "z-tabbox" : this._zclass;
        String orientCls = this.isHorizontalTop() ? "" : " " + cls + "-" + this._orient;
        cls = cls + (this.inAccordionMold() ? " " + cls + "-" + this.getMold() : orientCls);
        return cls;
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (child instanceof Toolbar) {
            if (this._toolbar != null && this._toolbar != child) {
                throw new UiException("Only one Toolbar is allowed: " + (Object)((Object)this));
            }
        } else if (child instanceof Tabs) {
            if (this._tabs != null && this._tabs != child) {
                throw new UiException("Only one tabs is allowed: " + (Object)((Object)this));
            }
        } else if (child instanceof Tabpanels) {
            if (this._tabpanels != null && this._tabpanels != child) {
                throw new UiException("Only one tabpanels is allowed: " + (Object)((Object)this));
            }
        } else {
            throw new UiException("Unsupported child for tabbox: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof Tabs) {
            if (super.insertBefore(child, refChild)) {
                this._tabs = (Tabs)child;
                for (Tab tab : this._tabs.getChildren()) {
                    if (!tab.isSelected()) continue;
                    this._seltab = tab;
                    break;
                }
                this.addTabsListeners();
                return true;
            }
        } else if (child instanceof Tabpanels) {
            if (super.insertBefore(child, refChild)) {
                this._tabpanels = (Tabpanels)child;
                return true;
            }
        } else if (child instanceof Toolbar) {
            if (super.insertBefore(child, refChild)) {
                this._toolbar = (Toolbar)child;
                return true;
            }
        } else {
            return super.insertBefore(child, refChild);
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        if (this._tabs == child) {
            this.removeTabsListeners();
            this._tabs = null;
            this._seltab = null;
        } else if (this._tabpanels == child) {
            this._tabpanels = null;
        } else if (this._toolbar == child) {
            this._toolbar = null;
        }
        super.onChildRemoved(child);
    }

    private void removeTabsListeners() {
        if (this._tabs != null) {
            for (Tab tab : this._tabs.getChildren()) {
                tab.removeEventListener("onSelect", this._listener);
            }
        }
    }

    private void addTabsListeners() {
        if (this._tabs != null) {
            for (Tab tab : this._tabs.getChildren()) {
                tab.addEventListener("onSelect", this._listener);
            }
        }
    }

    protected void clearSelectedTab() {
        this._seltab = null;
    }

    public Object clone() {
        Tabbox clone = (Tabbox)((Object)super.clone());
        clone.removeTabsListeners();
        clone.init();
        int cnt = 0;
        if (clone._tabs != null) {
            ++cnt;
        }
        if (clone._toolbar != null) {
            ++cnt;
        }
        if (clone._tabpanels != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        for (Object child : this.getChildren()) {
            if (child instanceof Tabs) {
                this._tabs = (Tabs)((Object)child);
                for (Tab tab : this._tabs.getChildren()) {
                    if (!tab.isSelected()) continue;
                    this._seltab = tab;
                    break;
                }
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Toolbar) {
                this._toolbar = (Toolbar)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Tabpanels)) continue;
            this._tabpanels = (Tabpanels)((Object)child);
            if (--cnt != 0) continue;
            break;
        }
        this.addTabsListeners();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal(-1);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._panelSpacing != null) {
            this.render(renderer, "panelSpacing", this._panelSpacing);
        }
        if (!"horizontal".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
        if (!this._tabscroll) {
            renderer.render("tabscroll", this._tabscroll);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements EventListener<Event>,
    Deferrable {
        private Listener() {
        }

        public void onEvent(Event event) {
            Events.sendEvent((Component)Tabbox.this, (Event)event);
        }

        public boolean isDeferrable() {
            return !Events.isListened((Component)Tabbox.this, (String)"onSelect", (boolean)true);
        }
    }
}

