/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;
import org.zkoss.zul.AbstractChartModel;
import org.zkoss.zul.Chart;
import org.zkoss.zul.DialModelScale;

public class DialModel
extends AbstractChartModel {
    private static final long serialVersionUID = 20091008183229L;
    private List<DialModelScale> _series = new ArrayList<DialModelScale>(4);
    private String _bgColor = "#FFFFFF";
    private int[] _bgRGB = new int[]{255, 255, 255};
    private int _bgAlpha = 255;
    private String _bgColor1 = "#FFFFFF";
    private int[] _bgRGB1 = new int[]{255, 255, 255};
    private String _bgColor2 = "#AAAADC";
    private int[] _bgRGB2 = new int[]{170, 170, 220};
    private String _fgColor;
    private int[] _fgRGB = new int[]{128, 128, 128};
    private String _gdirection = "vertical";
    private double _capRadius = 0.07;

    public int size() {
        return this._series.size();
    }

    public DialModelScale newScale() {
        DialModelScale entry = new DialModelScale(this);
        this._series.add(entry);
        this.fireEvent(1, null, null);
        return entry;
    }

    public DialModelScale newScale(double lowerBound, double upperBound, double startAngle, double extent, double majorTickInterval, int minorTickCount) {
        DialModelScale entry = new DialModelScale(this);
        this._series.add(entry);
        entry.setScale(lowerBound, upperBound, startAngle, extent, majorTickInterval, minorTickCount);
        this.fireEvent(1, null, null);
        return entry;
    }

    public int indexOf(DialModelScale entry) {
        return this._series.indexOf(entry);
    }

    public DialModelScale getScale(int index) {
        return this._series.get(index);
    }

    public void removeScale(DialModelScale scale) {
        this._series.remove(scale);
        this.fireEvent(2, null, null);
    }

    public double getValue(int index) {
        return this.getScale(index).getValue();
    }

    public void setValue(int index, double value) {
        this.getScale(index).setValue(value);
    }

    public void clear() {
        if (!this._series.isEmpty()) {
            this._series.clear();
            this.fireEvent(2, null, null);
        }
    }

    public void setFrameBgAlpha(int alpha) {
        if (alpha == this._bgAlpha) {
            return;
        }
        if (alpha > 255 || alpha < 0) {
            alpha = 255;
        }
        this._bgAlpha = alpha;
        this.fireEvent(0, null, null);
    }

    public int getFrameBgAlpha() {
        return this._bgAlpha;
    }

    public void setFrameBgColor(String color) {
        if (Objects.equals((Object)color, (Object)this._bgColor)) {
            return;
        }
        this._bgColor = color;
        if (this._bgColor == null) {
            this._bgRGB = null;
        } else {
            this._bgRGB = new int[3];
            Chart.decode(this._bgColor, this._bgRGB);
        }
        this.fireEvent(0, null, null);
    }

    public String getFrameBgColor() {
        return this._bgColor;
    }

    public int[] getFrameBgRGB() {
        return this._bgRGB;
    }

    public void setFrameFgColor(String color) {
        if (Objects.equals((Object)color, (Object)this._fgColor)) {
            return;
        }
        this._fgColor = color;
        if (this._fgColor == null) {
            this._fgRGB = null;
        } else {
            this._fgRGB = new int[3];
            Chart.decode(this._fgColor, this._fgRGB);
        }
        this.fireEvent(0, null, null);
    }

    public String getFrameFgColor() {
        return this._fgColor;
    }

    public int[] getFrameFgRGB() {
        return this._fgRGB;
    }

    public void setFrameBgColor1(String color) {
        if (Objects.equals((Object)color, (Object)this._bgColor1)) {
            return;
        }
        this._bgColor1 = color;
        if (this._bgColor1 == null) {
            this._bgRGB1 = null;
        } else {
            this._bgRGB1 = new int[3];
            Chart.decode(this._bgColor1, this._bgRGB1);
        }
        this.fireEvent(0, null, null);
    }

    public String getFrameBgColor1() {
        return this._bgColor1;
    }

    public int[] getFrameBgRGB1() {
        return this._bgRGB1;
    }

    public void setFrameBgColor2(String color) {
        if (Objects.equals((Object)color, (Object)this._bgColor2)) {
            return;
        }
        this._bgColor2 = color;
        if (this._bgColor2 == null) {
            this._bgRGB2 = null;
        } else {
            this._bgRGB2 = new int[3];
            Chart.decode(this._bgColor2, this._bgRGB2);
        }
        this.fireEvent(0, null, null);
    }

    public String getFrameBgColor2() {
        return this._bgColor2;
    }

    public int[] getFrameBgRGB2() {
        return this._bgRGB2;
    }

    public void setGradientDirection(String direction) {
        this._gdirection = direction;
        this.fireEvent(0, null, null);
    }

    public String getGradientDirection() {
        return this._gdirection;
    }

    public void setCapRadius(double radius) {
        this._capRadius = radius;
    }

    public double getCapRadius() {
        return this._capRadius;
    }

    public Object clone() {
        DialModel clone = (DialModel)super.clone();
        if (this._bgRGB != null) {
            clone._bgRGB = (int[])ArraysX.duplicate((Object)this._bgRGB);
        }
        if (this._bgRGB1 != null) {
            clone._bgRGB1 = (int[])ArraysX.duplicate((Object)this._bgRGB1);
        }
        if (this._bgRGB2 != null) {
            clone._bgRGB2 = (int[])ArraysX.duplicate((Object)this._bgRGB2);
        }
        if (this._fgRGB != null) {
            clone._fgRGB = (int[])ArraysX.duplicate((Object)this._fgRGB);
        }
        return clone;
    }
}

