/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Include;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.impl.LabelImageElement;

public class Tab
extends LabelImageElement {
    private boolean _selected;
    private boolean _closable;
    private boolean _disabled;

    public Tab() {
    }

    public Tab(String label) {
        super(label);
    }

    public Tab(String label, String image) {
        super(label, image);
    }

    public void setWidth(String width) {
        Tabbox tb = this.getTabbox();
        if (tb != null && tb.isVertical()) {
            throw new UnsupportedOperationException("Set Tabs' width instead");
        }
        super.setWidth(width);
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("closable", this._closable);
        }
    }

    public void onClose() {
        this.close();
    }

    public void close() {
        Tab tab;
        if (this._selected && (tab = this.selectNextTab()) != null) {
            HashSet<Tab> selItems = new HashSet<Tab>(2);
            selItems.add(tab);
            Events.postEvent((Event)new SelectEvent("onSelect", (Component)tab, selItems));
        }
        Tabpanel panel = this.getLinkedPanel();
        this.detach();
        if (panel != null) {
            Component include = panel.getFirstChild();
            if (include instanceof Include) {
                include.detach();
            }
            panel.detach();
        }
    }

    private Tab selectNextTab() {
        Tab tab;
        for (tab = (Tab)this.getNextSibling(); tab != null; tab = (Tab)tab.getNextSibling()) {
            if (tab.isDisabled()) continue;
            tab.setSelected(true);
            return tab;
        }
        for (tab = (Tab)this.getPreviousSibling(); tab != null; tab = (Tab)tab.getPreviousSibling()) {
            if (tab.isDisabled()) continue;
            tab.setSelected(true);
            return tab;
        }
        return null;
    }

    public Tabbox getTabbox() {
        Tabs tabs = (Tabs)this.getParent();
        return tabs != null ? tabs.getTabbox() : null;
    }

    public Tabpanel getLinkedPanel() {
        Tabpanels tabpanels;
        Tabbox tabbox;
        int j = this.getIndex();
        if (j >= 0 && (tabbox = this.getTabbox()) != null && (tabpanels = tabbox.getTabpanels()) != null && tabpanels.getChildren().size() > j) {
            return (Tabpanel)((Object)tabpanels.getChildren().get(j));
        }
        return null;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            if (selected) {
                tabbox.setSelectedTab(this);
            } else if (tabbox.getSelectedTab() == this) {
                tabbox.clearSelectedTab();
                this._selected = false;
            }
        } else if (this._selected != selected) {
            this._selected = selected;
            this.smartUpdate("selected", this._selected);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public int getIndex() {
        Tabs tabs = (Tabs)this.getParent();
        if (tabs == null) {
            return -1;
        }
        int j = 0;
        Iterator it = tabs.getChildren().iterator();
        while (it.next() != this) {
            ++j;
        }
        return j;
    }

    public String getZclass() {
        if (this._zclass != null) {
            return this._zclass;
        }
        Tabbox tabbox = this.getTabbox();
        String added = tabbox != null ? (tabbox.inAccordionMold() ? "-" + tabbox.getMold() : (tabbox.isVertical() ? "-ver" : "")) : "";
        return "z-tab" + added;
    }

    protected boolean isChildable() {
        return false;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Tabs)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSelect")) {
            SelectEvent evt = SelectEvent.getSelectEvent((AuRequest)request);
            Set selItems = evt.getSelectedItems();
            if (selItems == null || selItems.size() != 1) {
                throw new UiException("Exactly one selected tab is required: " + selItems);
            }
            Tabbox tabbox = this.getTabbox();
            if (tabbox != null) {
                tabbox.selectTabDirectly((Tab)((Object)selItems.iterator().next()), true);
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._disabled) {
            this.render(renderer, "disabled", this._disabled);
        }
        if (this._selected) {
            this.render(renderer, "selected", this._selected);
        }
        if (this._closable) {
            this.render(renderer, "closable", this._closable);
        }
    }

    static {
        Tab.addClientEvent(Tab.class, (String)"onClose", (int)0);
        Tab.addClientEvent(Tab.class, (String)"onSelect", (int)1);
    }
}

