/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Openable;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.TreeOpenableModel;
import org.zkoss.zul.ext.TreeSelectableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeModel<E>
implements TreeModel<E>,
TreeSelectableModel,
TreeOpenableModel,
Selectable<E>,
Openable<E>,
Serializable {
    private E _root;
    private transient List<TreeDataListener> _listeners = new LinkedList<TreeDataListener>();
    protected Set<Path> _selection = new LinkedHashSet<Path>();
    protected Set<Path> _opens = new LinkedHashSet<Path>();
    private boolean _multiple;

    public AbstractTreeModel(E root) {
        this._root = root;
    }

    @Override
    public E getRoot() {
        return this._root;
    }

    void setRootDirectly(E root) {
        this._root = root;
    }

    public void fireEvent(E node, int indexFrom, int indexTo, int evtType) {
        this.fireEvent(evtType, this.getPath(node), indexFrom, indexTo);
    }

    public void fireEvent(int evtType, int[] path, int indexFrom, int indexTo) {
        TreeDataEvent evt = new TreeDataEvent(this, evtType, path, indexFrom, indexTo);
        for (TreeDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    protected void fireSelectionChanged(int[] path) {
        TreeDataEvent evt = new TreeDataEvent(this, 4, path, 0, 1);
        for (TreeDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    protected void fireOpenChanged(int[] path) {
        TreeDataEvent evt = new TreeDataEvent(this, 5, path, 0, 1);
        for (TreeDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    @Override
    public int getIndexOfChild(E parent, E child) {
        int cnt = this._childCount(parent);
        for (int j = 0; j < cnt; ++j) {
            if (!Objects.equals(child, this.getChild(parent, j))) continue;
            return j;
        }
        return -1;
    }

    @Override
    public E getChild(int[] path) {
        E parent = this.getRoot();
        if (path.length == 0) {
            return parent;
        }
        E node = null;
        int childCount = this._childCount(parent);
        for (int i = 0; i < path.length; ++i) {
            if (path[i] < 0 || path[i] > childCount) {
                return null;
            }
            node = this.getChild(parent, path[i]);
            if (node != null && (childCount = this._childCount(node)) > 0) {
                parent = node;
                continue;
            }
            if (i == path.length - 1) continue;
            return null;
        }
        return node;
    }

    private int _childCount(E parent) {
        return this.isLeaf(parent) ? 0 : this.getChildCount(parent);
    }

    @Override
    public int[] getPath(E child) {
        ArrayList<Integer> path = new ArrayList<Integer>();
        this.dfSearch(path, this.getRoot(), child);
        int[] ipath = new int[path.size()];
        for (int j = 0; j < ipath.length; ++j) {
            ipath[j] = (Integer)path.get(j);
        }
        return ipath;
    }

    private boolean dfSearch(List<Integer> path, E node, E target) {
        if (node.equals(target)) {
            return true;
        }
        int size = this._childCount(node);
        for (int i = 0; i < size; ++i) {
            if (!this.dfSearch(path, this.getChild(node, i), target)) continue;
            path.add(0, new Integer(i));
            return true;
        }
        return false;
    }

    @Override
    public void addTreeDataListener(TreeDataListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeTreeDataListener(TreeDataListener l) {
        this._listeners.remove(l);
    }

    @Override
    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            this.fireEvent(6, null, -1, -1);
            if (!multiple && this._selection.size() > 1) {
                LinkedList<Path> sels = new LinkedList<Path>();
                sels.addAll(this._selection);
                Path sel = (Path)sels.remove(0);
                this._selection.clear();
                this._selection.add(sel);
                for (Path path : sels) {
                    this.fireSelectionChanged(path.path);
                }
            }
        }
    }

    @Override
    public boolean isMultiple() {
        return this._multiple;
    }

    @Override
    public boolean addSelectionPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.addSelectionPaths(paths);
        }
        return false;
    }

    @Override
    public boolean addSelectionPaths(int[][] paths) {
        boolean added = false;
        int len = paths != null ? paths.length : 0;
        boolean multiple = this.isMultiple();
        for (int j = 0; j < len; ++j) {
            if (paths[j] == null) continue;
            Path path = new Path(paths[j]);
            if (multiple) {
                if (!this._selection.add(path)) continue;
                added = true;
                this.fireSelectionChanged(path.path);
                continue;
            }
            if (this._selection.contains(path)) break;
            added = true;
            this._selection.clear();
            this._selection.add(path);
            this.fireSelectionChanged(path.path);
            break;
        }
        return added;
    }

    @Override
    public boolean removeSelectionPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.removeSelectionPaths(paths);
        }
        return false;
    }

    @Override
    public boolean removeSelectionPaths(int[][] paths) {
        boolean found = false;
        int len = paths != null ? paths.length : 0;
        for (int j = 0; j < len && !this._selection.isEmpty(); ++j) {
            Path path = new Path(paths[j]);
            if (this._selection.remove(path)) {
                found = true;
                this.fireSelectionChanged(path.path);
            }
            if (!this.isMultiple()) break;
        }
        return found;
    }

    @Override
    public boolean isPathSelected(int[] path) {
        return path != null && this._selection.contains(new Path(path));
    }

    @Override
    public int[] getSelectionPath() {
        return this._selection.isEmpty() ? null : this._selection.iterator().next().path;
    }

    @Override
    public int[][] getSelectionPaths() {
        if (this._selection.isEmpty()) {
            return null;
        }
        int[][] paths = new int[this._selection.size()][];
        int j = 0;
        for (Path path : this._selection) {
            paths[j++] = path.path;
        }
        return paths;
    }

    @Override
    public int getSelectionCount() {
        return this._selection.size();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._selection.isEmpty();
    }

    @Override
    public void clearSelection() {
        int[][] paths;
        if (!this._selection.isEmpty() && (paths = this.getSelectionPaths()) != null) {
            this._selection.clear();
            for (int j = 0; j < paths.length; ++j) {
                this.fireSelectionChanged(paths[j]);
            }
        }
    }

    @Override
    public boolean addOpenPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.addOpenPaths(paths);
        }
        return false;
    }

    @Override
    public boolean addOpenPaths(int[][] paths) {
        boolean added = false;
        int len = paths != null ? paths.length : 0;
        for (int j = 0; j < len; ++j) {
            Path path;
            if (paths[j] == null || !this._opens.add(path = new Path(paths[j]))) continue;
            added = true;
            this.fireOpenChanged(path.path);
        }
        return added;
    }

    @Override
    public boolean removeOpenPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.removeOpenPaths(paths);
        }
        return false;
    }

    @Override
    public boolean removeOpenPaths(int[][] paths) {
        boolean found = false;
        int len = paths != null ? paths.length : 0;
        for (int j = 0; j < len && !this._opens.isEmpty(); ++j) {
            Path path = new Path(paths[j]);
            if (!this._opens.remove(path)) continue;
            found = true;
            this.fireOpenChanged(path.path);
        }
        return found;
    }

    @Override
    public boolean isPathOpened(int[] path) {
        return path != null && this._opens.contains(new Path(path));
    }

    @Override
    public int[] getOpenPath() {
        return this._opens.isEmpty() ? null : this._opens.iterator().next().path;
    }

    @Override
    public int[][] getOpenPaths() {
        if (this._opens.isEmpty()) {
            return null;
        }
        int[][] paths = new int[this._opens.size()][];
        int j = 0;
        for (Path path : this._opens) {
            paths[j++] = path.path;
        }
        return paths;
    }

    @Override
    public int getOpenCount() {
        return this._opens.size();
    }

    @Override
    public boolean isOpenEmpty() {
        return this._opens.isEmpty();
    }

    @Override
    public void clearOpen() {
        int[][] paths;
        if (!this._opens.isEmpty() && (paths = this.getOpenPaths()) != null) {
            this._opens.clear();
            for (int j = 0; j < paths.length; ++j) {
                this.fireOpenChanged(paths[j]);
            }
        }
    }

    protected Object beforeSort() {
        States states = new States();
        for (Path path : this._selection) {
            states.selection.add(this.getChild(path.path));
        }
        for (Path path : this._opens) {
            states.opens.add(this.getChild(path.path));
        }
        return states;
    }

    protected void afterSort(Object ctx) {
        if (ctx instanceof States) {
            States states = (States)ctx;
            this._selection.clear();
            for (Object node : states.selection) {
                this._selection.add(new Path(this.getPath(node)));
            }
            this._opens.clear();
            for (Object node : states.opens) {
                this._opens.add(new Path(this.getPath(node)));
            }
        }
    }

    @Override
    public Set<E> getSelection() {
        LinkedHashSet<E> selected = new LinkedHashSet<E>();
        int[][] paths = this.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                selected.add(this.getChild(paths[i]));
            }
        }
        return selected;
    }

    @Override
    public void setSelection(Collection<? extends E> selection) {
        if (this.isSelectionChanged(selection)) {
            this.clearSelection();
            for (E node : selection) {
                this.addToSelection(node);
            }
        }
    }

    private boolean isSelectionChanged(Collection<? extends E> selection) {
        if (this._selection.size() != selection.size()) {
            return true;
        }
        for (E e : selection) {
            if (this._selection.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelected(Object child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.isPathSelected(path);
        }
        return false;
    }

    @Override
    public boolean addToSelection(E child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.addSelectionPath(path);
        }
        return false;
    }

    @Override
    public boolean removeFromSelection(Object child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.removeSelectionPath(path);
        }
        return false;
    }

    @Override
    public Set<E> getOpenObjects() {
        LinkedHashSet<E> opened = new LinkedHashSet<E>();
        int[][] paths = this.getOpenPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                opened.add(this.getChild(paths[i]));
            }
        }
        return opened;
    }

    @Override
    public void setOpenObjects(Collection<? extends E> opened) {
        this.clearOpen();
        for (E node : opened) {
            this.addOpenObject(node);
        }
    }

    @Override
    public boolean isObjectOpened(Object child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.isPathOpened(path);
        }
        return false;
    }

    @Override
    public boolean addOpenObject(E child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.addOpenPath(path);
        }
        return false;
    }

    @Override
    public boolean removeOpenObject(Object child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.removeOpenPath(path);
        }
        return false;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList<TreeDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }

    public Object clone() {
        AbstractTreeModel clone;
        try {
            clone = (AbstractTreeModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._listeners = new LinkedList<TreeDataListener>();
        clone._opens = new LinkedHashSet<Path>(this._opens);
        clone._selection = new LinkedHashSet<Path>(this._selection);
        return clone;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class States<E> {
        private final Set<E> selection = new LinkedHashSet();
        private final Set<E> opens = new LinkedHashSet();

        private States() {
        }
    }

    protected static class Path
    implements Serializable {
        public final int[] path;

        protected Path(int[] path) {
            this.path = path;
        }

        public int hashCode() {
            return Objects.hashCode((int[])this.path);
        }

        public boolean equals(Object o) {
            return o instanceof Path && Objects.equals((Object)this.path, (Object)((Path)o).path);
        }
    }
}

