/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.event.GroupsDataEvent;
import org.zkoss.zul.event.GroupsDataListener;
import org.zkoss.zul.ext.Selectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroupsModel<D, H, F, E>
implements GroupsModel<D, H, F>,
Selectable<E>,
Serializable {
    private transient List<GroupsDataListener> _listeners = new LinkedList<GroupsDataListener>();
    protected transient Set<E> _selection = this.newEmptySelection();
    private boolean _multiple;

    protected AbstractGroupsModel() {
    }

    protected void fireEvent(int type, int groupIndex, int index0, int index1) {
        GroupsDataEvent evt = new GroupsDataEvent(this, type, groupIndex, index0, index1);
        for (GroupsDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    @Override
    public void addGroupsDataListener(GroupsDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    @Override
    public void removeGroupsDataListener(GroupsDataListener l) {
        this._listeners.remove(l);
    }

    @Override
    public Set<E> getSelection() {
        return Collections.unmodifiableSet(this._selection);
    }

    @Override
    public void setSelection(Collection<? extends E> selection) {
        if (!((Object)this._selection).equals(selection)) {
            if (!this._multiple && this._selection.size() > 1) {
                throw new IllegalArgumentException("Only one selection is allowed, not " + selection);
            }
            this._selection.clear();
            this._selection.addAll(selection);
            if (selection.isEmpty()) {
                this.fireSelectionEvent(null);
            } else {
                this.fireSelectionEvent(selection.iterator().next());
            }
        }
    }

    @Override
    public boolean isSelected(Object obj) {
        return this._selection.contains(obj);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._selection.isEmpty();
    }

    @Override
    public boolean addToSelection(E obj) {
        if (this._selection.add(obj)) {
            if (!this._multiple) {
                this._selection.clear();
                this._selection.add(obj);
            }
            this.fireSelectionEvent(obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromSelection(Object obj) {
        if (this._selection.remove(obj)) {
            this.fireEvent(8, -1, -1, -1);
            return true;
        }
        return false;
    }

    @Override
    public void clearSelection() {
        if (!this._selection.isEmpty()) {
            this._selection.clear();
            this.fireEvent(8, -1, -1, -1);
        }
    }

    protected void fireSelectionEvent(E e) {
        this.fireEvent(8, -1, -1, -1);
    }

    protected void removeAllSelection(Collection<?> c) {
        this._selection.removeAll(c);
    }

    protected void retainAllSelection(Collection<?> c) {
        this._selection.retainAll(c);
    }

    @Override
    public boolean isMultiple() {
        return this._multiple;
    }

    @Override
    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            this.fireEvent(9, -1, -1, -1);
            if (!multiple && this._selection.size() > 1) {
                E v = this._selection.iterator().next();
                this._selection.clear();
                this._selection.add(v);
                this.fireEvent(8, -1, -1, -1);
            }
        }
    }

    protected Set<E> newEmptySelection() {
        return new LinkedHashSet();
    }

    protected void writeSelection(ObjectOutputStream s) throws IOException {
        s.writeObject(this._selection);
    }

    protected void readSelection(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this._selection = (Set)s.readObject();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.writeSelection(s);
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.readSelection(s);
        this._listeners = new LinkedList<GroupsDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }

    public Object clone() {
        AbstractGroupsModel clone;
        try {
            clone = (AbstractGroupsModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._listeners = new LinkedList<GroupsDataListener>();
        clone._selection = clone.newEmptySelection();
        clone._selection.addAll(this._selection);
        return clone;
    }
}

