/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.impl;

import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.CloneableEventListener;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.Rows;
import org.zkoss.zul.event.DataLoadingEvent;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.GridDataLoader;
import org.zkoss.zul.impl.Padding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveGridDataLoader
extends GridDataLoader {
    private EventListener<DataLoadingEvent> _dataLoadingListener;
    private EventListener<Event> _onTopPadListener;
    private int _offset;
    private int _limit = 40;
    private int _oldTotalSize;
    private boolean _renderAll;

    public void init(Component owner, int offset, int limit) {
        super.init(owner, offset, limit);
        this._offset = offset;
        this._limit = limit;
        this.addDataLoadingListener(owner);
        this.addOnTopPadListener(owner);
    }

    public void reset() {
        this.removeDataLoadingListener(this.getOwner());
        this.removeOnTopPadListener(this.getOwner());
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLimit() {
        Grid grid = this.getGrid();
        return grid != null && this.inPagingMold() ? grid.getPaginal().getPageSize() : this._limit;
    }

    private Grid getGrid() {
        return (Grid)this.getOwner();
    }

    public void doListDataChange(ListDataEvent event) {
        if (!this.isCropper()) {
            super.doListDataChange(event);
        } else {
            this.doLiveListDataChange(event);
        }
        this.updateModelSize();
    }

    private void doLiveListDataChange(ListDataEvent event) {
        int newsz = event.getModel().getSize();
        int oldsz = this._oldTotalSize;
        int endindex = this._offset + this._limit - 1;
        this._oldTotalSize = newsz;
        int min = event.getIndex0();
        int max = event.getIndex1();
        switch (event.getType()) {
            case 1: {
                int cnt = newsz - oldsz;
                if (cnt <= 0) {
                    throw new UiException("Adding causes a smaller list?");
                }
                if (min <= endindex) {
                    this.syncModel(-1, -1);
                }
                this.updateModelInfo();
                break;
            }
            case 2: {
                int cnt = oldsz - newsz;
                if (cnt <= 0) {
                    throw new UiException("Removal causes a larger list?");
                }
                if (min >= 0) {
                    max = min + cnt - 1;
                } else if (max < 0) {
                    min = 0;
                    max = cnt - 1;
                }
                if (max > oldsz - 1) {
                    max = oldsz - 1;
                }
                if (min <= endindex) {
                    this.syncModel(-1, -1);
                }
                this.updateModelInfo();
                break;
            }
            case 7: {
                Grid grid = this.getGrid();
                ((Padding)grid.getExtraCtrl()).setHeight(-1);
                this.syncModel(-1, -1);
                grid.invalidate();
                break;
            }
            default: {
                this.syncData(min, max < 0 ? -1 : max - min + 1);
            }
        }
    }

    private void syncData(int offset, int limit) {
        if (!this.isCropper() || this._renderAll) {
            super.syncModel(offset, limit);
        } else {
            this.loadModel(-1, -1);
        }
    }

    private void updateModelSize() {
        Grid grid = this.getGrid();
        ListModel model = grid.getModel();
        if (model != null) {
            this._oldTotalSize = model.getSize();
        }
        if (this.inPagingMold()) {
            Paginal pgi = grid.getPaginal();
            pgi.setTotalSize(this.getTotalSize());
        }
    }

    public void syncModel(int offset, int limit) {
        this.updateModelSize();
        if (!this.isCropper() || this._renderAll) {
            super.syncModel(offset, limit);
        } else {
            this.loadModel(offset, limit);
        }
    }

    private void loadModel(int offset, int limit) {
        int min = limit < 0 ? (this._offset < 0 ? 0 : this._offset) : (offset < 0 ? 0 : offset);
        int pgsz = limit < 0 ? this._limit : limit;
        Grid grid = this.getGrid();
        ListModel model = grid.getModel();
        int tsz = model.getSize();
        int max = min + pgsz - 1;
        if (this.inPagingMold()) {
            Paginal pgi = grid.getPaginal();
            pgsz = pgi.getPageSize();
            if (offset < 0) {
                min = Math.min(pgi.getActivePage() * pgsz, tsz);
            }
            if ((max = min + pgsz - 1) >= tsz) {
                max = tsz - 1;
                min = max - max % pgsz;
            } else {
                min -= min % pgsz;
            }
        }
        if (min != this._offset || pgsz != this._limit || limit < 0 || offset < 0) {
            Rows rows = grid.getRows();
            if (rows != null) {
                rows.getChildren().clear();
            } else {
                rows = new Rows();
                rows.setParent((Component)grid);
            }
            this._offset = min;
            this._limit = pgsz;
            LinkedHashSet<Row> items = new LinkedHashSet<Row>();
            RowRenderer renderer = (RowRenderer)this.getRealRenderer();
            while (min <= max && min < tsz) {
                Row row = (Row)this.newUnloadedItem(renderer, min);
                rows.insertBefore((Component)row, null);
                items.add(row);
                ++min;
            }
            grid.renderItems(items);
            rows.invalidate();
        }
    }

    private void loadModelAndRenderItems(int offset, int limit) {
        Grid grid = this.getGrid();
        ListModel model = grid.getModel();
        if (model != null && !this._renderAll) {
            this.loadModel(offset, limit);
        } else {
            this._offset = offset;
            this._limit = limit;
        }
        Rows rows = grid.getRows();
        if (rows != null) {
            LinkedHashSet<Row> items = new LinkedHashSet<Row>();
            if (model != null) {
                if (!this._renderAll) {
                    for (Row row : rows.getChildren()) {
                        items.add(row);
                    }
                } else {
                    ListIterator it = rows.getChildren().listIterator(offset);
                    while (it.hasNext() && limit > 0) {
                        Row row = (Row)it.next();
                        items.add(row);
                        --limit;
                    }
                    rows.invalidate();
                }
                grid.renderItems(items);
            } else {
                Row row = (Row)rows.getFirstChild();
                while (row != null && limit != 0) {
                    Group g;
                    if (row.isVisible() && --offset < 0) {
                        --limit;
                        items.add(row);
                    }
                    if (row instanceof Group && !(g = (Group)row).isOpen()) {
                        int len = g.getItemCount();
                        for (int j = 0; j < len && row != null; row = (Row)row.getNextSibling(), ++j) {
                        }
                    }
                    if (row == null) continue;
                    row = (Row)row.getNextSibling();
                }
                rows.invalidate();
            }
        }
    }

    private void smartUpdate(Component comp, String key, Object value) {
        ((WebAppCtrl)Sessions.getCurrent().getWebApp()).getUiEngine().addSmartUpdate(comp, key, value, false);
    }

    private void removeDataLoadingListener(Component owner) {
        if (this._dataLoadingListener != null) {
            owner.removeEventListener("onDataLoading", this._dataLoadingListener);
            this._dataLoadingListener = null;
        }
    }

    private void addDataLoadingListener(Component owner) {
        if (this._dataLoadingListener == null) {
            this._dataLoadingListener = new CloneableEventListener<DataLoadingEvent>(){

                public void onEvent(DataLoadingEvent event) {
                    Grid grid = (Grid)event.getTarget();
                    if (LiveGridDataLoader.this.inPagingMold()) {
                        return;
                    }
                    int offset = event.getOffset();
                    int limit = event.getLimit();
                    LiveGridDataLoader.this.smartUpdate((Component)grid, "_scrolling", Boolean.TRUE);
                    LiveGridDataLoader.this.loadModelAndRenderItems(offset, limit);
                    LiveGridDataLoader.this.smartUpdate((Component)grid, "scrollPads_", new Integer(LiveGridDataLoader.this.getOffset()));
                }

                public Object willClone(Component comp) {
                    return null;
                }
            };
            owner.addEventListener("onDataLoading", this._dataLoadingListener);
        }
    }

    private void removeOnTopPadListener(Component owner) {
        if (this._onTopPadListener != null) {
            owner.removeEventListener("onTopPad", this._onTopPadListener);
            this._onTopPadListener = null;
        }
    }

    private void addOnTopPadListener(Component owner) {
        if (this._onTopPadListener == null) {
            this._onTopPadListener = new TopPadListener();
            owner.addEventListener("onTopPad", this._onTopPadListener);
        }
    }

    public void updateModelInfo() {
        UiEngine engine;
        Grid grid = this.getGrid();
        Page page = grid.getPage();
        UiEngine uiEngine = engine = page == null ? null : ((WebAppCtrl)page.getDesktop().getWebApp()).getUiEngine();
        if (engine != null) {
            engine.addSmartUpdate((Component)grid, "_offset", (Object)new Integer(this.getOffset()), false);
            engine.addSmartUpdate((Component)grid, "totalSize", (Object)new Integer(this.getTotalSize()), false);
        }
    }

    public void setLoadAll(boolean b) {
        if (this._renderAll != b) {
            ListModel model;
            Grid grid;
            this._renderAll = b;
            if (b && (grid = this.getGrid()) != null && (model = grid.getModel()) != null) {
                this.syncModel(-1, -1);
            }
        }
    }

    public boolean isCropper() {
        Grid grid = this.getGrid();
        if (grid != null) {
            String height = grid.getHeight();
            boolean isVflex = grid.isVflex();
            String vflex = grid.getVflex();
            return isVflex || "min".equals(vflex) || !Strings.isBlank((String)height) || this.inPagingMold() && grid.getModel() != null || super.isCropper();
        }
        return false;
    }

    public Set<? extends Component> getAvailableAtClient() {
        Grid grid = this.getGrid();
        if (grid != null && this.isCropper()) {
            ListModel model = grid.getModel();
            if (model == null && this.inPagingMold()) {
                return super.getAvailableAtClient();
            }
            return this.getAvailableAtClient(model != null && !this._renderAll ? 0 : this.getOffset(), this.getLimit());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopPadListener
    implements EventListener<Event>,
    Deferrable {
        private TopPadListener() {
        }

        public void onEvent(Event event) throws Exception {
            ((Padding)((Grid)event.getTarget()).getExtraCtrl()).setHeight(((Integer)event.getData()).intValue());
        }

        public boolean isDeferrable() {
            return true;
        }
    }
}

